/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import java.beans.ConstructorProperties;
import java.util.List;
import org.thingsboard.server.common.data.oauth2.OAuth2DomainInfo;
import org.thingsboard.server.common.data.oauth2.OAuth2MobileInfo;
import org.thingsboard.server.common.data.oauth2.OAuth2RegistrationInfo;

public class OAuth2ParamsInfo {
    private List<OAuth2DomainInfo> domainInfos;
    private List<OAuth2MobileInfo> mobileInfos;
    private List<OAuth2RegistrationInfo> clientRegistrations;

    public static OAuth2ParamsInfoBuilder builder() {
        return new OAuth2ParamsInfoBuilder();
    }

    public OAuth2ParamsInfoBuilder toBuilder() {
        return new OAuth2ParamsInfoBuilder().domainInfos(this.domainInfos).mobileInfos(this.mobileInfos).clientRegistrations(this.clientRegistrations);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2ParamsInfo)) {
            return false;
        }
        OAuth2ParamsInfo other = (OAuth2ParamsInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<OAuth2DomainInfo> this$domainInfos = this.getDomainInfos();
        List<OAuth2DomainInfo> other$domainInfos = other.getDomainInfos();
        if (this$domainInfos == null ? other$domainInfos != null : !((Object)this$domainInfos).equals(other$domainInfos)) {
            return false;
        }
        List<OAuth2MobileInfo> this$mobileInfos = this.getMobileInfos();
        List<OAuth2MobileInfo> other$mobileInfos = other.getMobileInfos();
        if (this$mobileInfos == null ? other$mobileInfos != null : !((Object)this$mobileInfos).equals(other$mobileInfos)) {
            return false;
        }
        List<OAuth2RegistrationInfo> this$clientRegistrations = this.getClientRegistrations();
        List<OAuth2RegistrationInfo> other$clientRegistrations = other.getClientRegistrations();
        return !(this$clientRegistrations == null ? other$clientRegistrations != null : !((Object)this$clientRegistrations).equals(other$clientRegistrations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuth2ParamsInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<OAuth2DomainInfo> $domainInfos = this.getDomainInfos();
        result = result * 59 + ($domainInfos == null ? 43 : ((Object)$domainInfos).hashCode());
        List<OAuth2MobileInfo> $mobileInfos = this.getMobileInfos();
        result = result * 59 + ($mobileInfos == null ? 43 : ((Object)$mobileInfos).hashCode());
        List<OAuth2RegistrationInfo> $clientRegistrations = this.getClientRegistrations();
        result = result * 59 + ($clientRegistrations == null ? 43 : ((Object)$clientRegistrations).hashCode());
        return result;
    }

    public List<OAuth2DomainInfo> getDomainInfos() {
        return this.domainInfos;
    }

    public List<OAuth2MobileInfo> getMobileInfos() {
        return this.mobileInfos;
    }

    public List<OAuth2RegistrationInfo> getClientRegistrations() {
        return this.clientRegistrations;
    }

    public void setDomainInfos(List<OAuth2DomainInfo> domainInfos) {
        this.domainInfos = domainInfos;
    }

    public void setMobileInfos(List<OAuth2MobileInfo> mobileInfos) {
        this.mobileInfos = mobileInfos;
    }

    public void setClientRegistrations(List<OAuth2RegistrationInfo> clientRegistrations) {
        this.clientRegistrations = clientRegistrations;
    }

    public String toString() {
        return "OAuth2ParamsInfo(domainInfos=" + this.getDomainInfos() + ", mobileInfos=" + this.getMobileInfos() + ", clientRegistrations=" + this.getClientRegistrations() + ")";
    }

    public OAuth2ParamsInfo() {
    }

    @ConstructorProperties(value={"domainInfos", "mobileInfos", "clientRegistrations"})
    public OAuth2ParamsInfo(List<OAuth2DomainInfo> domainInfos, List<OAuth2MobileInfo> mobileInfos, List<OAuth2RegistrationInfo> clientRegistrations) {
        this.domainInfos = domainInfos;
        this.mobileInfos = mobileInfos;
        this.clientRegistrations = clientRegistrations;
    }

    public static class OAuth2ParamsInfoBuilder {
        private List<OAuth2DomainInfo> domainInfos;
        private List<OAuth2MobileInfo> mobileInfos;
        private List<OAuth2RegistrationInfo> clientRegistrations;

        OAuth2ParamsInfoBuilder() {
        }

        public OAuth2ParamsInfoBuilder domainInfos(List<OAuth2DomainInfo> domainInfos) {
            this.domainInfos = domainInfos;
            return this;
        }

        public OAuth2ParamsInfoBuilder mobileInfos(List<OAuth2MobileInfo> mobileInfos) {
            this.mobileInfos = mobileInfos;
            return this;
        }

        public OAuth2ParamsInfoBuilder clientRegistrations(List<OAuth2RegistrationInfo> clientRegistrations) {
            this.clientRegistrations = clientRegistrations;
            return this;
        }

        public OAuth2ParamsInfo build() {
            return new OAuth2ParamsInfo(this.domainInfos, this.mobileInfos, this.clientRegistrations);
        }

        public String toString() {
            return "OAuth2ParamsInfo.OAuth2ParamsInfoBuilder(domainInfos=" + this.domainInfos + ", mobileInfos=" + this.mobileInfos + ", clientRegistrations=" + this.clientRegistrations + ")";
        }
    }
}

