/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.thingsboard;

import de.iip_ecosphere.platform.deviceMgt.DeviceDescriptor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.thingsboard.rest.client.RestClient;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.TsKvEntry;

public class ThingsBoardDeviceDescriptor
implements DeviceDescriptor {
    private static int deviceTimeout = 15000;
    private Device tbDevice;
    private RestClient tbClient;

    public ThingsBoardDeviceDescriptor(Device tbDevice, RestClient tbClient) {
        this.tbDevice = tbDevice;
        this.tbClient = tbClient;
    }

    public static int getDeviceTimeout() {
        return deviceTimeout;
    }

    public static void setDeviceTimeout(int timeout) {
        deviceTimeout = timeout;
    }

    public String getId() {
        return this.tbDevice.getName();
    }

    public String getManagedId() {
        return ((DeviceId)this.tbDevice.getId()).toString();
    }

    public String getIp() {
        DeviceId entityId = new DeviceId(UUID.fromString(this.getManagedId()));
        List attributesKeys = this.tbClient.getAttributeKeysByScope((EntityId)entityId, "device");
        List attributeKvEntries = this.tbClient.getAttributeKvEntries((EntityId)entityId, attributesKeys);
        return attributeKvEntries.stream().filter(key -> key.getKey().equals("ip")).map(kv -> (String)kv.getValue()).findFirst().orElse(null);
    }

    public String getRuntimeVersion() {
        return null;
    }

    public String getRuntimeName() {
        return null;
    }

    public String getResourceId() {
        return this.tbDevice.getName();
    }

    public DeviceDescriptor.State getState() {
        if (!this.tbClient.getTimeseriesKeys((EntityId)this.tbDevice.getId()).contains("active")) {
            return DeviceDescriptor.State.STARTING;
        }
        List active = this.tbClient.getLatestTimeseries((EntityId)this.tbDevice.getId(), Collections.singletonList("active"));
        TsKvEntry latest = active.stream().max(Comparator.comparingLong(TsKvEntry::getTs)).orElse(null);
        if (System.currentTimeMillis() - latest.getTs() < (long)deviceTimeout) {
            return DeviceDescriptor.State.AVAILABLE;
        }
        return DeviceDescriptor.State.UNDEFINED;
    }
}

