/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import org.thingsboard.server.common.data.ApiFeature;

public enum ApiUsageRecordKey {
    TRANSPORT_MSG_COUNT(ApiFeature.TRANSPORT, "transportMsgCount", "transportMsgLimit"),
    TRANSPORT_DP_COUNT(ApiFeature.TRANSPORT, "transportDataPointsCount", "transportDataPointsLimit"),
    STORAGE_DP_COUNT(ApiFeature.DB, "storageDataPointsCount", "storageDataPointsLimit"),
    RE_EXEC_COUNT(ApiFeature.RE, "ruleEngineExecutionCount", "ruleEngineExecutionLimit"),
    JS_EXEC_COUNT(ApiFeature.JS, "jsExecutionCount", "jsExecutionLimit"),
    EMAIL_EXEC_COUNT(ApiFeature.EMAIL, "emailCount", "emailLimit"),
    SMS_EXEC_COUNT(ApiFeature.SMS, "smsCount", "smsLimit"),
    CREATED_ALARMS_COUNT(ApiFeature.ALARM, "createdAlarmsCount", "createdAlarmsLimit");

    private static final ApiUsageRecordKey[] JS_RECORD_KEYS;
    private static final ApiUsageRecordKey[] RE_RECORD_KEYS;
    private static final ApiUsageRecordKey[] DB_RECORD_KEYS;
    private static final ApiUsageRecordKey[] TRANSPORT_RECORD_KEYS;
    private static final ApiUsageRecordKey[] EMAIL_RECORD_KEYS;
    private static final ApiUsageRecordKey[] SMS_RECORD_KEYS;
    private static final ApiUsageRecordKey[] ALARM_RECORD_KEYS;
    private final ApiFeature apiFeature;
    private final String apiCountKey;
    private final String apiLimitKey;

    private ApiUsageRecordKey(ApiFeature apiFeature, String apiCountKey, String apiLimitKey) {
        this.apiFeature = apiFeature;
        this.apiCountKey = apiCountKey;
        this.apiLimitKey = apiLimitKey;
    }

    public static ApiUsageRecordKey[] getKeys(ApiFeature feature) {
        switch (feature) {
            case TRANSPORT: {
                return TRANSPORT_RECORD_KEYS;
            }
            case DB: {
                return DB_RECORD_KEYS;
            }
            case RE: {
                return RE_RECORD_KEYS;
            }
            case JS: {
                return JS_RECORD_KEYS;
            }
            case EMAIL: {
                return EMAIL_RECORD_KEYS;
            }
            case SMS: {
                return SMS_RECORD_KEYS;
            }
            case ALARM: {
                return ALARM_RECORD_KEYS;
            }
        }
        return new ApiUsageRecordKey[0];
    }

    public ApiFeature getApiFeature() {
        return this.apiFeature;
    }

    public String getApiCountKey() {
        return this.apiCountKey;
    }

    public String getApiLimitKey() {
        return this.apiLimitKey;
    }

    static {
        JS_RECORD_KEYS = new ApiUsageRecordKey[]{JS_EXEC_COUNT};
        RE_RECORD_KEYS = new ApiUsageRecordKey[]{RE_EXEC_COUNT};
        DB_RECORD_KEYS = new ApiUsageRecordKey[]{STORAGE_DP_COUNT};
        TRANSPORT_RECORD_KEYS = new ApiUsageRecordKey[]{TRANSPORT_MSG_COUNT, TRANSPORT_DP_COUNT};
        EMAIL_RECORD_KEYS = new ApiUsageRecordKey[]{EMAIL_EXEC_COUNT};
        SMS_RECORD_KEYS = new ApiUsageRecordKey[]{SMS_EXEC_COUNT};
        ALARM_RECORD_KEYS = new ApiUsageRecordKey[]{CREATED_ALARMS_COUNT};
    }
}

