/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import java.beans.ConstructorProperties;

public class OAuth2CustomMapperConfig {
    private final String url;
    private final String username;
    private final String password;
    private final boolean sendToken;

    @ConstructorProperties(value={"url", "username", "password", "sendToken"})
    OAuth2CustomMapperConfig(String url, String username, String password, boolean sendToken) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.sendToken = sendToken;
    }

    public static OAuth2CustomMapperConfigBuilder builder() {
        return new OAuth2CustomMapperConfigBuilder();
    }

    public OAuth2CustomMapperConfigBuilder toBuilder() {
        return new OAuth2CustomMapperConfigBuilder().url(this.url).username(this.username).password(this.password).sendToken(this.sendToken);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2CustomMapperConfig)) {
            return false;
        }
        OAuth2CustomMapperConfig other = (OAuth2CustomMapperConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSendToken() != other.isSendToken()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuth2CustomMapperConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSendToken() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSendToken() {
        return this.sendToken;
    }

    public String toString() {
        return "OAuth2CustomMapperConfig(url=" + this.getUrl() + ", username=" + this.getUsername() + ", sendToken=" + this.isSendToken() + ")";
    }

    public static class OAuth2CustomMapperConfigBuilder {
        private String url;
        private String username;
        private String password;
        private boolean sendToken;

        OAuth2CustomMapperConfigBuilder() {
        }

        public OAuth2CustomMapperConfigBuilder url(String url) {
            this.url = url;
            return this;
        }

        public OAuth2CustomMapperConfigBuilder username(String username) {
            this.username = username;
            return this;
        }

        public OAuth2CustomMapperConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public OAuth2CustomMapperConfigBuilder sendToken(boolean sendToken) {
            this.sendToken = sendToken;
            return this;
        }

        public OAuth2CustomMapperConfig build() {
            return new OAuth2CustomMapperConfig(this.url, this.username, this.password, this.sendToken);
        }

        public String toString() {
            return "OAuth2CustomMapperConfig.OAuth2CustomMapperConfigBuilder(url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", sendToken=" + this.sendToken + ")";
        }
    }
}

