/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.page;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.thingsboard.server.common.data.page.SortOrder;

public class PageLink {
    private final String textSearch;
    private final int pageSize;
    private final int page;
    private final SortOrder sortOrder;

    public PageLink(PageLink pageLink) {
        this.pageSize = pageLink.getPageSize();
        this.page = pageLink.getPage();
        this.textSearch = pageLink.getTextSearch();
        this.sortOrder = pageLink.getSortOrder();
    }

    public PageLink(int pageSize) {
        this(pageSize, 0);
    }

    public PageLink(int pageSize, int page) {
        this(pageSize, page, null, null);
    }

    public PageLink(int pageSize, int page, String textSearch) {
        this(pageSize, page, textSearch, null);
    }

    public PageLink(int pageSize, int page, String textSearch, SortOrder sortOrder) {
        this.pageSize = pageSize;
        this.page = page;
        this.textSearch = textSearch;
        this.sortOrder = sortOrder;
    }

    @JsonIgnore
    public PageLink nextPageLink() {
        return new PageLink(this.pageSize, this.page + 1, this.textSearch, this.sortOrder);
    }

    public String getTextSearch() {
        return this.textSearch;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageLink)) {
            return false;
        }
        PageLink other = (PageLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        String this$textSearch = this.getTextSearch();
        String other$textSearch = other.getTextSearch();
        if (this$textSearch == null ? other$textSearch != null : !this$textSearch.equals(other$textSearch)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        return !(this$sortOrder == null ? other$sortOrder != null : !((Object)this$sortOrder).equals(other$sortOrder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getPage();
        String $textSearch = this.getTextSearch();
        result = result * 59 + ($textSearch == null ? 43 : $textSearch.hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)$sortOrder).hashCode());
        return result;
    }

    public String toString() {
        return "PageLink(textSearch=" + this.getTextSearch() + ", pageSize=" + this.getPageSize() + ", page=" + this.getPage() + ", sortOrder=" + this.getSortOrder() + ")";
    }
}

