/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.List;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.query.EntityDataPageLink;
import org.thingsboard.server.common.data.query.EntityDataSortOrder;

public class AlarmDataPageLink
extends EntityDataPageLink {
    private long startTs;
    private long endTs;
    private long timeWindow;
    private List<String> typeList;
    private List<AlarmSearchStatus> statusList;
    private List<AlarmSeverity> severityList;
    private boolean searchPropagatedAlarms;

    public AlarmDataPageLink() {
    }

    public AlarmDataPageLink(int pageSize, int page, String textSearch, EntityDataSortOrder sortOrder, boolean dynamic, boolean searchPropagatedAlarms, long startTs, long endTs, long timeWindow, List<String> typeList, List<AlarmSearchStatus> statusList, List<AlarmSeverity> severityList) {
        super(pageSize, page, textSearch, sortOrder, dynamic);
        this.searchPropagatedAlarms = searchPropagatedAlarms;
        this.startTs = startTs;
        this.endTs = endTs;
        this.timeWindow = timeWindow;
        this.typeList = typeList;
        this.statusList = statusList;
        this.severityList = severityList;
    }

    @Override
    @JsonIgnore
    public AlarmDataPageLink nextPageLink() {
        return new AlarmDataPageLink(this.getPageSize(), this.getPage() + 1, this.getTextSearch(), this.getSortOrder(), this.isDynamic(), this.searchPropagatedAlarms, this.startTs, this.endTs, this.timeWindow, this.typeList, this.statusList, this.severityList);
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public long getTimeWindow() {
        return this.timeWindow;
    }

    public List<String> getTypeList() {
        return this.typeList;
    }

    public List<AlarmSearchStatus> getStatusList() {
        return this.statusList;
    }

    public List<AlarmSeverity> getSeverityList() {
        return this.severityList;
    }

    public boolean isSearchPropagatedAlarms() {
        return this.searchPropagatedAlarms;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setTimeWindow(long timeWindow) {
        this.timeWindow = timeWindow;
    }

    public void setTypeList(List<String> typeList) {
        this.typeList = typeList;
    }

    public void setStatusList(List<AlarmSearchStatus> statusList) {
        this.statusList = statusList;
    }

    public void setSeverityList(List<AlarmSeverity> severityList) {
        this.severityList = severityList;
    }

    public void setSearchPropagatedAlarms(boolean searchPropagatedAlarms) {
        this.searchPropagatedAlarms = searchPropagatedAlarms;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmDataPageLink)) {
            return false;
        }
        AlarmDataPageLink other = (AlarmDataPageLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        if (this.getTimeWindow() != other.getTimeWindow()) {
            return false;
        }
        if (this.isSearchPropagatedAlarms() != other.isSearchPropagatedAlarms()) {
            return false;
        }
        List<String> this$typeList = this.getTypeList();
        List<String> other$typeList = other.getTypeList();
        if (this$typeList == null ? other$typeList != null : !((Object)this$typeList).equals(other$typeList)) {
            return false;
        }
        List<AlarmSearchStatus> this$statusList = this.getStatusList();
        List<AlarmSearchStatus> other$statusList = other.getStatusList();
        if (this$statusList == null ? other$statusList != null : !((Object)this$statusList).equals(other$statusList)) {
            return false;
        }
        List<AlarmSeverity> this$severityList = this.getSeverityList();
        List<AlarmSeverity> other$severityList = other.getSeverityList();
        return !(this$severityList == null ? other$severityList != null : !((Object)this$severityList).equals(other$severityList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AlarmDataPageLink;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        long $timeWindow = this.getTimeWindow();
        result = result * 59 + (int)($timeWindow >>> 32 ^ $timeWindow);
        result = result * 59 + (this.isSearchPropagatedAlarms() ? 79 : 97);
        List<String> $typeList = this.getTypeList();
        result = result * 59 + ($typeList == null ? 43 : ((Object)$typeList).hashCode());
        List<AlarmSearchStatus> $statusList = this.getStatusList();
        result = result * 59 + ($statusList == null ? 43 : ((Object)$statusList).hashCode());
        List<AlarmSeverity> $severityList = this.getSeverityList();
        result = result * 59 + ($severityList == null ? 43 : ((Object)$severityList).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AlarmDataPageLink(startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", timeWindow=" + this.getTimeWindow() + ", typeList=" + this.getTypeList() + ", statusList=" + this.getStatusList() + ", severityList=" + this.getSeverityList() + ", searchPropagatedAlarms=" + this.isSearchPropagatedAlarms() + ")";
    }

    @ConstructorProperties(value={"startTs", "endTs", "timeWindow", "typeList", "statusList", "severityList", "searchPropagatedAlarms"})
    public AlarmDataPageLink(long startTs, long endTs, long timeWindow, List<String> typeList, List<AlarmSearchStatus> statusList, List<AlarmSeverity> severityList, boolean searchPropagatedAlarms) {
        this.startTs = startTs;
        this.endTs = endTs;
        this.timeWindow = timeWindow;
        this.typeList = typeList;
        this.statusList = statusList;
        this.severityList = severityList;
        this.searchPropagatedAlarms = searchPropagatedAlarms;
    }
}

