/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.widget;

import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.validation.NoXss;

public class WidgetsBundle
extends SearchTextBased<WidgetsBundleId>
implements HasTenantId {
    private static final long serialVersionUID = -7627368878362410489L;
    private TenantId tenantId;
    @NoXss
    private String alias;
    @NoXss
    private String title;
    private String image;
    @NoXss
    private String description;

    public WidgetsBundle() {
    }

    public WidgetsBundle(WidgetsBundleId id) {
        super(id);
    }

    public WidgetsBundle(WidgetsBundle widgetsBundle) {
        super(widgetsBundle);
        this.tenantId = widgetsBundle.getTenantId();
        this.alias = widgetsBundle.getAlias();
        this.title = widgetsBundle.getTitle();
        this.image = widgetsBundle.getImage();
        this.description = widgetsBundle.getDescription();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getSearchText() {
        return this.getTitle();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WidgetsBundle that = (WidgetsBundle)o;
        if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
            return false;
        }
        if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(that.description) : that.description != null);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WidgetsBundle{");
        sb.append("tenantId=").append(this.tenantId);
        sb.append(", alias='").append(this.alias).append('\'');
        sb.append(", title='").append(this.title).append('\'');
        sb.append(", image='").append(this.image).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

