/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rest.client.utils;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;

public class RestJsonConverter {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String LAST_UPDATE_TS = "lastUpdateTs";
    private static final String TS = "ts";
    private static final String CAN_T_PARSE_VALUE = "Can't parse value: ";

    public static List<AttributeKvEntry> toAttributes(List<JsonNode> attributes) {
        if (!CollectionUtils.isEmpty(attributes)) {
            return attributes.stream().map(attr -> {
                KvEntry entry = RestJsonConverter.parseValue(attr.get(KEY).asText(), attr.get(VALUE));
                return new BaseAttributeKvEntry(entry, attr.get(LAST_UPDATE_TS).asLong());
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<TsKvEntry> toTimeseries(Map<String, List<JsonNode>> timeseries) {
        if (!CollectionUtils.isEmpty(timeseries)) {
            ArrayList<TsKvEntry> result = new ArrayList<TsKvEntry>();
            timeseries.forEach((key, values) -> result.addAll(values.stream().map(ts -> {
                KvEntry entry = RestJsonConverter.parseValue(key, ts.get(VALUE));
                return new BasicTsKvEntry(ts.get(TS).asLong(), entry);
            }).collect(Collectors.toList())));
            return result;
        }
        return Collections.emptyList();
    }

    private static KvEntry parseValue(String key, JsonNode value) {
        if (!value.isObject()) {
            if (value.isBoolean()) {
                return new BooleanDataEntry(key, Boolean.valueOf(value.asBoolean()));
            }
            if (value.isNumber()) {
                return RestJsonConverter.parseNumericValue(key, value);
            }
            if (value.isTextual()) {
                return new StringDataEntry(key, value.asText());
            }
            throw new RuntimeException(CAN_T_PARSE_VALUE + value);
        }
        return new JsonDataEntry(key, value.toString());
    }

    private static KvEntry parseNumericValue(String key, JsonNode value) {
        if (value.isFloatingPointNumber()) {
            return new DoubleDataEntry(key, Double.valueOf(value.asDouble()));
        }
        try {
            long longValue = Long.parseLong(value.toString());
            return new LongDataEntry(key, Long.valueOf(longValue));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Big integer values are not supported!");
        }
    }
}

