/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.css;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.owasp.validator.css.CssHandler;
import org.owasp.validator.css.CssScanner;
import org.owasp.validator.html.InternalPolicy;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.util.ErrorMessageUtil;
import org.owasp.validator.html.util.HTMLEntityEncoder;
import org.w3c.css.sac.InputSource;

public class ExternalCssScanner
extends CssScanner {
    public ExternalCssScanner(InternalPolicy policy, ResourceBundle messages) {
        super(policy, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseImportedStylesheets(LinkedList<?> stylesheets, CssHandler handler, ArrayList<String> errorMessages, int sizeLimit) throws ScanException {
        int importedStylesheets = 0;
        if (!stylesheets.isEmpty()) {
            int timeout = 1000;
            try {
                timeout = Integer.parseInt(this.policy.getDirective("connectionTimeout"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().disableAutomaticRetries().disableConnectionState().disableCookieManagement().setDefaultRequestConfig(requestConfig).build();
            int allowedImports = 1;
            try {
                allowedImports = Integer.parseInt(this.policy.getDirective("maxStyleSheetImports"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            while (!stylesheets.isEmpty()) {
                URI stylesheetUri = (URI)stylesheets.removeFirst();
                if (++importedStylesheets > allowedImports) {
                    errorMessages.add(ErrorMessageUtil.getMessage(this.messages, "error.css.import.exceeded", new Object[]{HTMLEntityEncoder.htmlEntityEncode(stylesheetUri.toString()), String.valueOf(allowedImports)}));
                    continue;
                }
                HttpGet stylesheetRequest = new HttpGet(stylesheetUri);
                byte[] stylesheet = null;
                try {
                    HttpResponse response = httpClient.execute((HttpUriRequest)stylesheetRequest);
                    stylesheet = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                    if (stylesheet != null && stylesheet.length > sizeLimit) {
                        errorMessages.add(ErrorMessageUtil.getMessage(this.messages, "error.css.import.toolarge", new Object[]{HTMLEntityEncoder.htmlEntityEncode(stylesheetUri.toString()), String.valueOf(this.policy.getMaxInputSize())}));
                        stylesheet = null;
                    }
                }
                catch (IOException ioe) {
                    errorMessages.add(ErrorMessageUtil.getMessage(this.messages, "error.css.import.failure", new Object[]{HTMLEntityEncoder.htmlEntityEncode(stylesheetUri.toString())}));
                }
                finally {
                    stylesheetRequest.releaseConnection();
                }
                if (stylesheet == null) continue;
                sizeLimit -= stylesheet.length;
                try {
                    InputSource nextStyleSheet = new InputSource((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(stylesheet), Charset.forName("UTF8")));
                    this.parser.parseStyleSheet(nextStyleSheet);
                }
                catch (IOException ioe) {
                    throw new ScanException(ioe);
                }
            }
        }
    }
}

