/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.thingsboard;

import de.iip_ecosphere.platform.deviceMgt.DeviceDescriptor;
import de.iip_ecosphere.platform.deviceMgt.thingsboard.ThingsBoardDeviceDescriptor;
import de.iip_ecosphere.platform.deviceMgt.thingsboard.ThingsBoardDeviceRegistry;
import de.iip_ecosphere.platform.deviceMgt.thingsboard.ThingsBoardDeviceRegistryFactoryDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.thingsboard.rest.client.RestClient;

public class IntegrationTests {
    public static final String A_DEVICE = "A_DEVICE";
    public static final String AN_IP = "AN_IP";
    private ThingsBoardDeviceRegistry registry;
    private RestClient restClient;

    @Before
    public void setUp() {
        ThingsBoardDeviceRegistryFactoryDescriptor factory = new ThingsBoardDeviceRegistryFactoryDescriptor();
        this.registry = (ThingsBoardDeviceRegistry)factory.createDeviceRegistryInstance();
        this.restClient = new RestClient("http://localhost:8080");
        this.restClient.login("tenant@thingsboard.org", "tenant");
    }

    @After
    public void tearDown() {
        this.registry.getIds().forEach(d -> this.registry.removeDevice(d));
    }

    @Test
    public void restClientIsAbleToConnect() {
        Assert.assertNotNull((Object)this.restClient);
    }

    @Test
    public void createDeviceRegistryInstance_createsInstance() {
        Assert.assertNotNull((Object)this.registry);
        Assert.assertNotNull((Object)this.registry.getRestClient());
    }

    @Test
    public void addDevice_withDevice_shouldAddDevice() {
        this.registry.addDevice(A_DEVICE, AN_IP);
        Assert.assertTrue((boolean)this.restClient.getTenantDevice(A_DEVICE).isPresent());
    }

    @Test
    public void addDevice_withOutDevice_shouldNotAddDevice() {
        int sizeBefore = this.registry.getIds().size();
        this.registry.addDevice("", AN_IP);
        this.registry.addDevice(null, AN_IP);
        this.registry.addDevice(A_DEVICE, "");
        this.registry.addDevice(A_DEVICE, null);
        Assert.assertEquals((long)sizeBefore, (long)this.registry.getIds().size());
        Assert.assertFalse((boolean)this.restClient.getTenantDevice(A_DEVICE).isPresent());
    }

    @Test
    public void addMultipleDevices_shouldAddAllDevices() {
        List<String> ids = IntegrationTests.generateRandomIds(10);
        ids.forEach(id -> this.registry.addDevice(id, AN_IP));
        ids.forEach(id -> Assert.assertTrue((boolean)this.restClient.getTenantDevice(id).isPresent()));
    }

    @Test
    public void removeDevice_removesDevice() {
        this.registry.addDevice(A_DEVICE, AN_IP);
        Assert.assertTrue((boolean)this.restClient.getTenantDevice(A_DEVICE).isPresent());
        this.registry.removeDevice(A_DEVICE);
        Assert.assertFalse((boolean)this.restClient.getTenantDevice(A_DEVICE).isPresent());
    }

    @Test
    public void addDevice_withDeviceAndIp_hasDeviceIdInternalIdAndIp() {
        this.registry.addDevice(A_DEVICE, AN_IP);
        DeviceDescriptor device = this.registry.getDevice(A_DEVICE);
        Assert.assertEquals((Object)A_DEVICE, (Object)device.getId());
        Assert.assertEquals((Object)AN_IP, (Object)device.getIp());
        Assert.assertNotNull((Object)device.getManagedId());
        Assert.assertNotEquals((Object)"", (Object)device.getManagedId());
    }

    @Test
    public void getState_withDeviceAddedButNoAlive_shouldBeSTARTING() {
        this.registry.addDevice(A_DEVICE, AN_IP);
        DeviceDescriptor device = this.registry.getDevice(A_DEVICE);
        Assert.assertEquals((Object)DeviceDescriptor.State.STARTING, (Object)device.getState());
    }

    @Test
    public void getState_withDeviceAddedAndAlive_shouldBeAVAILABLE() throws ExecutionException {
        this.registry.addDevice(A_DEVICE, AN_IP);
        this.registry.imAlive(A_DEVICE);
        DeviceDescriptor device = this.registry.getDevice(A_DEVICE);
        Assert.assertEquals((Object)DeviceDescriptor.State.AVAILABLE, (Object)device.getState());
    }

    @Test
    public void getState_withTimedOutDevice_shouldBeUNDEFINED() throws ExecutionException, InterruptedException {
        int timeOutBefore = ThingsBoardDeviceDescriptor.getDeviceTimeout();
        this.registry.addDevice(A_DEVICE, AN_IP);
        this.registry.imAlive(A_DEVICE);
        ThingsBoardDeviceDescriptor.setDeviceTimeout((int)250);
        DeviceDescriptor device = this.registry.getDevice(A_DEVICE);
        Thread.sleep(300L);
        Assert.assertEquals((Object)DeviceDescriptor.State.UNDEFINED, (Object)device.getState());
        ThingsBoardDeviceDescriptor.setDeviceTimeout((int)timeOutBefore);
    }

    @Test
    public void getRuntime_withValidDevice_returnsNull() {
        this.registry.addDevice(A_DEVICE, AN_IP);
        DeviceDescriptor device = this.registry.getDevice(A_DEVICE);
        Assert.assertNull((Object)device.getRuntimeName());
        Assert.assertNull((Object)device.getRuntimeVersion());
    }

    static List<String> generateRandomIds(int count) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            ids.add(UUID.randomUUID().toString());
        }
        return ids;
    }
}

