/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.device.profile;

import com.github.os72.protobuf.dynamic.DynamicSchema;
import com.github.os72.protobuf.dynamic.EnumDefinition;
import com.github.os72.protobuf.dynamic.MessageDefinition;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.TransportPayloadType;
import org.thingsboard.server.common.data.device.profile.TransportPayloadTypeConfiguration;

public class ProtoTransportPayloadConfiguration
implements TransportPayloadTypeConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ProtoTransportPayloadConfiguration.class);
    public static final Location LOCATION = new Location("", "", -1, -1);
    public static final String ATTRIBUTES_PROTO_SCHEMA = "attributes proto schema";
    public static final String TELEMETRY_PROTO_SCHEMA = "telemetry proto schema";
    public static final String RPC_RESPONSE_PROTO_SCHEMA = "rpc response proto schema";
    public static final String RPC_REQUEST_PROTO_SCHEMA = "rpc request proto schema";
    private static final String PROTO_3_SYNTAX = "proto3";
    private String deviceTelemetryProtoSchema;
    private String deviceAttributesProtoSchema;
    private String deviceRpcRequestProtoSchema;
    private String deviceRpcResponseProtoSchema;

    @Override
    public TransportPayloadType getTransportPayloadType() {
        return TransportPayloadType.PROTOBUF;
    }

    public Descriptors.Descriptor getTelemetryDynamicMessageDescriptor(String deviceTelemetryProtoSchema) {
        return this.getDescriptor(deviceTelemetryProtoSchema, TELEMETRY_PROTO_SCHEMA);
    }

    public Descriptors.Descriptor getAttributesDynamicMessageDescriptor(String deviceAttributesProtoSchema) {
        return this.getDescriptor(deviceAttributesProtoSchema, ATTRIBUTES_PROTO_SCHEMA);
    }

    public Descriptors.Descriptor getRpcResponseDynamicMessageDescriptor(String deviceRpcResponseProtoSchema) {
        return this.getDescriptor(deviceRpcResponseProtoSchema, RPC_RESPONSE_PROTO_SCHEMA);
    }

    public DynamicMessage.Builder getRpcRequestDynamicMessageBuilder(String deviceRpcRequestProtoSchema) {
        return this.getDynamicMessageBuilder(deviceRpcRequestProtoSchema, RPC_REQUEST_PROTO_SCHEMA);
    }

    public String getDeviceRpcResponseProtoSchema() {
        if (!this.isEmptyStr(this.deviceRpcResponseProtoSchema)) {
            return this.deviceRpcResponseProtoSchema;
        }
        return "syntax =\"proto3\";\npackage rpc;\n\nmessage RpcResponseMsg {\n  optional string payload = 1;\n}";
    }

    public String getDeviceRpcRequestProtoSchema() {
        if (!this.isEmptyStr(this.deviceRpcRequestProtoSchema)) {
            return this.deviceRpcRequestProtoSchema;
        }
        return "syntax =\"proto3\";\npackage rpc;\n\nmessage RpcRequestMsg {\n  optional string method = 1;\n  optional int32 requestId = 2;\n  optional string params = 3;\n}";
    }

    private Descriptors.Descriptor getDescriptor(String protoSchema, String schemaName) {
        try {
            DynamicMessage.Builder builder = this.getDynamicMessageBuilder(protoSchema, schemaName);
            return builder.getDescriptorForType();
        }
        catch (Exception e) {
            log.warn("Failed to get Message Descriptor due to {}", (Object)e.getMessage());
            return null;
        }
    }

    public DynamicMessage.Builder getDynamicMessageBuilder(String protoSchema, String schemaName) {
        ProtoFileElement protoFileElement = this.getTransportProtoSchema(protoSchema);
        DynamicSchema dynamicSchema = this.getDynamicSchema(protoFileElement, schemaName);
        String lastMsgName = this.getMessageTypes(protoFileElement.getTypes()).stream().map(MessageElement::getName).reduce((previous, last) -> last).get();
        return dynamicSchema.newMessageBuilder(lastMsgName);
    }

    public DynamicSchema getDynamicSchema(ProtoFileElement protoFileElement, String schemaName) {
        DynamicSchema.Builder schemaBuilder = DynamicSchema.newBuilder();
        schemaBuilder.setName(schemaName);
        schemaBuilder.setSyntax(PROTO_3_SYNTAX);
        schemaBuilder.setPackage(!this.isEmptyStr(protoFileElement.getPackageName()) ? protoFileElement.getPackageName() : schemaName.toLowerCase());
        List types = protoFileElement.getTypes();
        List<MessageElement> messageTypes = this.getMessageTypes(types);
        if (!messageTypes.isEmpty()) {
            List<EnumElement> enumTypes = this.getEnumElements(types);
            if (!enumTypes.isEmpty()) {
                enumTypes.forEach(enumElement -> {
                    EnumDefinition enumDefinition = this.getEnumDefinition((EnumElement)enumElement);
                    schemaBuilder.addEnumDefinition(enumDefinition);
                });
            }
            List<MessageDefinition> messageDefinitions = this.getMessageDefinitions(messageTypes);
            messageDefinitions.forEach(arg_0 -> ((DynamicSchema.Builder)schemaBuilder).addMessageDefinition(arg_0));
            try {
                return schemaBuilder.build();
            }
            catch (Descriptors.DescriptorValidationException e) {
                throw new RuntimeException("Failed to create dynamic schema due to: " + e.getMessage());
            }
        }
        throw new RuntimeException("Failed to get Dynamic Schema! Message types is empty for schema:" + schemaName);
    }

    public ProtoFileElement getTransportProtoSchema(String protoSchema) {
        return new ProtoParser(LOCATION, protoSchema.toCharArray()).readProtoFile();
    }

    private List<MessageElement> getMessageTypes(List<TypeElement> types) {
        return types.stream().filter(typeElement -> typeElement instanceof MessageElement).map(typeElement -> (MessageElement)typeElement).collect(Collectors.toList());
    }

    private List<EnumElement> getEnumElements(List<TypeElement> types) {
        return types.stream().filter(typeElement -> typeElement instanceof EnumElement).map(typeElement -> (EnumElement)typeElement).collect(Collectors.toList());
    }

    private List<MessageDefinition> getMessageDefinitions(List<MessageElement> messageElementsList) {
        if (!messageElementsList.isEmpty()) {
            ArrayList<MessageDefinition> messageDefinitions = new ArrayList<MessageDefinition>();
            messageElementsList.forEach(messageElement -> {
                MessageDefinition.Builder messageDefinitionBuilder = MessageDefinition.newBuilder((String)messageElement.getName());
                List nestedTypes = messageElement.getNestedTypes();
                if (!nestedTypes.isEmpty()) {
                    List<EnumElement> nestedEnumTypes = this.getEnumElements(nestedTypes);
                    if (!nestedEnumTypes.isEmpty()) {
                        nestedEnumTypes.forEach(enumElement -> {
                            EnumDefinition nestedEnumDefinition = this.getEnumDefinition((EnumElement)enumElement);
                            messageDefinitionBuilder.addEnumDefinition(nestedEnumDefinition);
                        });
                    }
                    List<MessageElement> nestedMessageTypes = this.getMessageTypes(nestedTypes);
                    List<MessageDefinition> nestedMessageDefinitions = this.getMessageDefinitions(nestedMessageTypes);
                    nestedMessageDefinitions.forEach(arg_0 -> ((MessageDefinition.Builder)messageDefinitionBuilder).addMessageDefinition(arg_0));
                }
                List messageElementFields = messageElement.getFields();
                List oneOfs = messageElement.getOneOfs();
                if (!oneOfs.isEmpty()) {
                    for (OneOfElement oneOfelement : oneOfs) {
                        MessageDefinition.OneofBuilder oneofBuilder = messageDefinitionBuilder.addOneof(oneOfelement.getName());
                        this.addMessageFieldsToTheOneOfDefinition(oneOfelement.getFields(), oneofBuilder);
                    }
                }
                if (!messageElementFields.isEmpty()) {
                    this.addMessageFieldsToTheMessageDefinition(messageElementFields, messageDefinitionBuilder);
                }
                messageDefinitions.add(messageDefinitionBuilder.build());
            });
            return messageDefinitions;
        }
        return Collections.emptyList();
    }

    private EnumDefinition getEnumDefinition(EnumElement enumElement) {
        List enumElementTypeConstants = enumElement.getConstants();
        EnumDefinition.Builder enumDefinitionBuilder = EnumDefinition.newBuilder((String)enumElement.getName());
        if (!enumElementTypeConstants.isEmpty()) {
            enumElementTypeConstants.forEach(constantElement -> enumDefinitionBuilder.addValue(constantElement.getName(), constantElement.getTag()));
        }
        return enumDefinitionBuilder.build();
    }

    private void addMessageFieldsToTheMessageDefinition(List<FieldElement> messageElementFields, MessageDefinition.Builder messageDefinitionBuilder) {
        messageElementFields.forEach(fieldElement -> {
            String labelStr = null;
            if (fieldElement.getLabel() != null) {
                labelStr = fieldElement.getLabel().name().toLowerCase();
            }
            messageDefinitionBuilder.addField(labelStr, fieldElement.getType(), fieldElement.getName(), fieldElement.getTag());
        });
    }

    private void addMessageFieldsToTheOneOfDefinition(List<FieldElement> oneOfsElementFields, MessageDefinition.OneofBuilder oneofBuilder) {
        oneOfsElementFields.forEach(fieldElement -> oneofBuilder.addField(fieldElement.getType(), fieldElement.getName(), fieldElement.getTag()));
        oneofBuilder.msgDefBuilder();
    }

    private boolean isEmptyStr(String str) {
        return str == null || "".equals(str);
    }

    public String getDeviceTelemetryProtoSchema() {
        return this.deviceTelemetryProtoSchema;
    }

    public String getDeviceAttributesProtoSchema() {
        return this.deviceAttributesProtoSchema;
    }

    public void setDeviceTelemetryProtoSchema(String deviceTelemetryProtoSchema) {
        this.deviceTelemetryProtoSchema = deviceTelemetryProtoSchema;
    }

    public void setDeviceAttributesProtoSchema(String deviceAttributesProtoSchema) {
        this.deviceAttributesProtoSchema = deviceAttributesProtoSchema;
    }

    public void setDeviceRpcRequestProtoSchema(String deviceRpcRequestProtoSchema) {
        this.deviceRpcRequestProtoSchema = deviceRpcRequestProtoSchema;
    }

    public void setDeviceRpcResponseProtoSchema(String deviceRpcResponseProtoSchema) {
        this.deviceRpcResponseProtoSchema = deviceRpcResponseProtoSchema;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtoTransportPayloadConfiguration)) {
            return false;
        }
        ProtoTransportPayloadConfiguration other = (ProtoTransportPayloadConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$deviceTelemetryProtoSchema = this.getDeviceTelemetryProtoSchema();
        String other$deviceTelemetryProtoSchema = other.getDeviceTelemetryProtoSchema();
        if (this$deviceTelemetryProtoSchema == null ? other$deviceTelemetryProtoSchema != null : !this$deviceTelemetryProtoSchema.equals(other$deviceTelemetryProtoSchema)) {
            return false;
        }
        String this$deviceAttributesProtoSchema = this.getDeviceAttributesProtoSchema();
        String other$deviceAttributesProtoSchema = other.getDeviceAttributesProtoSchema();
        if (this$deviceAttributesProtoSchema == null ? other$deviceAttributesProtoSchema != null : !this$deviceAttributesProtoSchema.equals(other$deviceAttributesProtoSchema)) {
            return false;
        }
        String this$deviceRpcRequestProtoSchema = this.getDeviceRpcRequestProtoSchema();
        String other$deviceRpcRequestProtoSchema = other.getDeviceRpcRequestProtoSchema();
        if (this$deviceRpcRequestProtoSchema == null ? other$deviceRpcRequestProtoSchema != null : !this$deviceRpcRequestProtoSchema.equals(other$deviceRpcRequestProtoSchema)) {
            return false;
        }
        String this$deviceRpcResponseProtoSchema = this.getDeviceRpcResponseProtoSchema();
        String other$deviceRpcResponseProtoSchema = other.getDeviceRpcResponseProtoSchema();
        return !(this$deviceRpcResponseProtoSchema == null ? other$deviceRpcResponseProtoSchema != null : !this$deviceRpcResponseProtoSchema.equals(other$deviceRpcResponseProtoSchema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProtoTransportPayloadConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $deviceTelemetryProtoSchema = this.getDeviceTelemetryProtoSchema();
        result = result * 59 + ($deviceTelemetryProtoSchema == null ? 43 : $deviceTelemetryProtoSchema.hashCode());
        String $deviceAttributesProtoSchema = this.getDeviceAttributesProtoSchema();
        result = result * 59 + ($deviceAttributesProtoSchema == null ? 43 : $deviceAttributesProtoSchema.hashCode());
        String $deviceRpcRequestProtoSchema = this.getDeviceRpcRequestProtoSchema();
        result = result * 59 + ($deviceRpcRequestProtoSchema == null ? 43 : $deviceRpcRequestProtoSchema.hashCode());
        String $deviceRpcResponseProtoSchema = this.getDeviceRpcResponseProtoSchema();
        result = result * 59 + ($deviceRpcResponseProtoSchema == null ? 43 : $deviceRpcResponseProtoSchema.hashCode());
        return result;
    }

    public String toString() {
        return "ProtoTransportPayloadConfiguration(deviceTelemetryProtoSchema=" + this.getDeviceTelemetryProtoSchema() + ", deviceAttributesProtoSchema=" + this.getDeviceAttributesProtoSchema() + ", deviceRpcRequestProtoSchema=" + this.getDeviceRpcRequestProtoSchema() + ", deviceRpcResponseProtoSchema=" + this.getDeviceRpcResponseProtoSchema() + ")";
    }
}

