/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.oauth2.MapperType;
import org.thingsboard.server.common.data.oauth2.OAuth2BasicMapperConfig;
import org.thingsboard.server.common.data.oauth2.OAuth2CustomMapperConfig;

public class OAuth2MapperConfig {
    private boolean allowUserCreation;
    private boolean activateUser;
    private MapperType type;
    private OAuth2BasicMapperConfig basic;
    private OAuth2CustomMapperConfig custom;

    @ConstructorProperties(value={"allowUserCreation", "activateUser", "type", "basic", "custom"})
    OAuth2MapperConfig(boolean allowUserCreation, boolean activateUser, MapperType type, OAuth2BasicMapperConfig basic, OAuth2CustomMapperConfig custom) {
        this.allowUserCreation = allowUserCreation;
        this.activateUser = activateUser;
        this.type = type;
        this.basic = basic;
        this.custom = custom;
    }

    public static OAuth2MapperConfigBuilder builder() {
        return new OAuth2MapperConfigBuilder();
    }

    public OAuth2MapperConfigBuilder toBuilder() {
        return new OAuth2MapperConfigBuilder().allowUserCreation(this.allowUserCreation).activateUser(this.activateUser).type(this.type).basic(this.basic).custom(this.custom);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2MapperConfig)) {
            return false;
        }
        OAuth2MapperConfig other = (OAuth2MapperConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllowUserCreation() != other.isAllowUserCreation()) {
            return false;
        }
        if (this.isActivateUser() != other.isActivateUser()) {
            return false;
        }
        MapperType this$type = this.getType();
        MapperType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        OAuth2BasicMapperConfig this$basic = this.getBasic();
        OAuth2BasicMapperConfig other$basic = other.getBasic();
        if (this$basic == null ? other$basic != null : !((Object)this$basic).equals(other$basic)) {
            return false;
        }
        OAuth2CustomMapperConfig this$custom = this.getCustom();
        OAuth2CustomMapperConfig other$custom = other.getCustom();
        return !(this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuth2MapperConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowUserCreation() ? 79 : 97);
        result = result * 59 + (this.isActivateUser() ? 79 : 97);
        MapperType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        OAuth2BasicMapperConfig $basic = this.getBasic();
        result = result * 59 + ($basic == null ? 43 : ((Object)$basic).hashCode());
        OAuth2CustomMapperConfig $custom = this.getCustom();
        result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
        return result;
    }

    public boolean isAllowUserCreation() {
        return this.allowUserCreation;
    }

    public boolean isActivateUser() {
        return this.activateUser;
    }

    public MapperType getType() {
        return this.type;
    }

    public OAuth2BasicMapperConfig getBasic() {
        return this.basic;
    }

    public OAuth2CustomMapperConfig getCustom() {
        return this.custom;
    }

    public void setAllowUserCreation(boolean allowUserCreation) {
        this.allowUserCreation = allowUserCreation;
    }

    public void setActivateUser(boolean activateUser) {
        this.activateUser = activateUser;
    }

    public void setType(MapperType type) {
        this.type = type;
    }

    public void setBasic(OAuth2BasicMapperConfig basic) {
        this.basic = basic;
    }

    public void setCustom(OAuth2CustomMapperConfig custom) {
        this.custom = custom;
    }

    public String toString() {
        return "OAuth2MapperConfig(allowUserCreation=" + this.isAllowUserCreation() + ", activateUser=" + this.isActivateUser() + ", type=" + this.getType() + ", basic=" + this.getBasic() + ", custom=" + this.getCustom() + ")";
    }

    public static class OAuth2MapperConfigBuilder {
        private boolean allowUserCreation;
        private boolean activateUser;
        private MapperType type;
        private OAuth2BasicMapperConfig basic;
        private OAuth2CustomMapperConfig custom;

        OAuth2MapperConfigBuilder() {
        }

        public OAuth2MapperConfigBuilder allowUserCreation(boolean allowUserCreation) {
            this.allowUserCreation = allowUserCreation;
            return this;
        }

        public OAuth2MapperConfigBuilder activateUser(boolean activateUser) {
            this.activateUser = activateUser;
            return this;
        }

        public OAuth2MapperConfigBuilder type(MapperType type) {
            this.type = type;
            return this;
        }

        public OAuth2MapperConfigBuilder basic(OAuth2BasicMapperConfig basic) {
            this.basic = basic;
            return this;
        }

        public OAuth2MapperConfigBuilder custom(OAuth2CustomMapperConfig custom) {
            this.custom = custom;
            return this;
        }

        public OAuth2MapperConfig build() {
            return new OAuth2MapperConfig(this.allowUserCreation, this.activateUser, this.type, this.basic, this.custom);
        }

        public String toString() {
            return "OAuth2MapperConfig.OAuth2MapperConfigBuilder(allowUserCreation=" + this.allowUserCreation + ", activateUser=" + this.activateUser + ", type=" + this.type + ", basic=" + this.basic + ", custom=" + this.custom + ")";
        }
    }
}

