/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import javax.validation.Valid;
import org.thingsboard.server.common.data.query.DynamicValue;
import org.thingsboard.server.common.data.validation.NoXss;

public class FilterPredicateValue<T>
implements Serializable {
    @NoXss
    private final T defaultValue;
    @NoXss
    private final T userValue;
    @Valid
    private final DynamicValue<T> dynamicValue;

    public FilterPredicateValue(T defaultValue) {
        this(defaultValue, null, (DynamicValue<Object>)null);
    }

    @JsonCreator
    public FilterPredicateValue(@JsonProperty(value="defaultValue") T defaultValue, @JsonProperty(value="userValue") T userValue, @JsonProperty(value="dynamicValue") DynamicValue<T> dynamicValue) {
        this.defaultValue = defaultValue;
        this.userValue = userValue;
        this.dynamicValue = dynamicValue;
    }

    @JsonIgnore
    public T getValue() {
        if (this.userValue != null) {
            return this.userValue;
        }
        if (this.dynamicValue != null && this.dynamicValue.getResolvedValue() != null) {
            return this.dynamicValue.getResolvedValue();
        }
        return this.defaultValue;
    }

    public static FilterPredicateValue<Double> fromDouble(double value) {
        return new FilterPredicateValue<Double>(value);
    }

    public static FilterPredicateValue<String> fromString(String value) {
        return new FilterPredicateValue<String>(value);
    }

    public static FilterPredicateValue<Boolean> fromBoolean(boolean value) {
        return new FilterPredicateValue<Boolean>(value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterPredicateValue)) {
            return false;
        }
        FilterPredicateValue other = (FilterPredicateValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$defaultValue = this.getDefaultValue();
        T other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        T this$userValue = this.getUserValue();
        T other$userValue = other.getUserValue();
        if (this$userValue == null ? other$userValue != null : !this$userValue.equals(other$userValue)) {
            return false;
        }
        DynamicValue<T> this$dynamicValue = this.getDynamicValue();
        DynamicValue<T> other$dynamicValue = other.getDynamicValue();
        return !(this$dynamicValue == null ? other$dynamicValue != null : !((Object)this$dynamicValue).equals(other$dynamicValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilterPredicateValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        T $userValue = this.getUserValue();
        result = result * 59 + ($userValue == null ? 43 : $userValue.hashCode());
        DynamicValue<T> $dynamicValue = this.getDynamicValue();
        result = result * 59 + ($dynamicValue == null ? 43 : ((Object)$dynamicValue).hashCode());
        return result;
    }

    public String toString() {
        return "FilterPredicateValue(defaultValue=" + this.getDefaultValue() + ", userValue=" + this.getUserValue() + ", dynamicValue=" + this.getDynamicValue() + ")";
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getUserValue() {
        return this.userValue;
    }

    public DynamicValue<T> getDynamicValue() {
        return this.dynamicValue;
    }
}

