/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.transport.snmp;

import java.util.Arrays;
import java.util.Optional;

public enum PrivacyProtocol {
    DES("1.3.6.1.6.3.10.1.2.2"),
    AES_128("1.3.6.1.6.3.10.1.2.4"),
    AES_192("1.3.6.1.4.1.4976.2.2.1.1.1"),
    AES_256("1.3.6.1.4.1.4976.2.2.1.1.2");

    private final String oid;

    private PrivacyProtocol(String oid) {
        this.oid = oid;
    }

    public String getOid() {
        return this.oid;
    }

    public static Optional<PrivacyProtocol> forName(String name) {
        return Arrays.stream(PrivacyProtocol.values()).filter(protocol -> protocol.name().equalsIgnoreCase(name)).findFirst();
    }
}

