/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.thingsboard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.deviceMgt.DeviceDescriptor;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistrationResponse;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistry;
import de.iip_ecosphere.platform.deviceMgt.thingsboard.ThingsBoardDeviceDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.thingsboard.rest.client.RestClient;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;

public class ThingsBoardDeviceRegistry
implements DeviceRegistry {
    public static final int PAGE_SIZE = 10;
    public static final String DEVICE_TYPE = "ecs";
    private RestClient restClient;

    public ThingsBoardDeviceRegistry(RestClient restClient) {
        this.restClient = restClient;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public Set<String> getIds() {
        return this.getTBDevices().stream().map(Device::getName).collect(Collectors.toSet());
    }

    private List<Device> getTBDevices() {
        ArrayList<Device> devices = new ArrayList<Device>();
        int page = 0;
        PageData devicePage = this.restClient.getTenantDevices(DEVICE_TYPE, new PageLink(10, page));
        do {
            devices.addAll(devicePage.getData());
        } while ((devicePage = this.restClient.getTenantDevices(DEVICE_TYPE, new PageLink(10, page++))).hasNext());
        return devices;
    }

    public Set<String> getManagedIds() {
        return this.getTBDevices().stream().map(d -> ((DeviceId)d.getId()).toString()).collect(Collectors.toSet());
    }

    public Collection<? extends DeviceDescriptor> getDevices() {
        return this.getTBDevices().stream().map(d -> new ThingsBoardDeviceDescriptor((Device)d, this.restClient)).collect(Collectors.toSet());
    }

    public DeviceDescriptor getDevice(String id) {
        return this.restClient.getTenantDevice(id).map(d -> new ThingsBoardDeviceDescriptor((Device)d, this.restClient)).orElse(null);
    }

    public DeviceDescriptor getDeviceByManagedId(String id) {
        return this.restClient.getDeviceById(new DeviceId(UUID.fromString(id))).map(tbDevice -> new ThingsBoardDeviceDescriptor((Device)tbDevice, this.restClient)).orElse(null);
    }

    public DeviceRegistrationResponse addDevice(String id, String ip) {
        DeviceRegistrationResponse result = new DeviceRegistrationResponse();
        if (id == null || id.isEmpty() || ip == null || ip.isEmpty()) {
            result.setSuccessful(false);
            result.setMessage("No id given");
            return result;
        }
        Device tbDevice = this.restClient.getTenantDevice(id).orElse(null);
        if (tbDevice == null) {
            Device device = new Device();
            device.setType(DEVICE_TYPE);
            device.setName(id);
            tbDevice = this.restClient.saveDevice(device);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode attribute = mapper.readTree("{\"ip\": \"" + ip + "\"}");
            this.restClient.saveDeviceAttributes((DeviceId)tbDevice.getId(), "SERVER_SCOPE", attribute);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        result.setSuccessful(true);
        return result;
    }

    public void removeDevice(String id) {
        if (id == null || id.isEmpty()) {
            return;
        }
        this.restClient.getTenantDevice(id).ifPresent(tbDevice -> this.restClient.deleteDevice((DeviceId)tbDevice.getId()));
    }

    public void imAlive(String id) throws ExecutionException {
        this.sendTelemetry(id, "{\"active\": true}");
    }

    public void sendTelemetry(String id, String telemetryData) throws ExecutionException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode telemetry = mapper.readTree(telemetryData);
            this.restClient.getTenantDevice(id).ifPresent(tbDevice -> this.restClient.saveEntityTelemetry((EntityId)tbDevice.getId(), "SERVER_SCOPE", telemetry));
        }
        catch (JsonProcessingException e) {
            throw new ExecutionException("TelemetryData is not json: ", e);
        }
    }
}

