/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.thingsboard;

import de.iip_ecosphere.platform.deviceMgt.thingsboard.IntegrationTests;
import de.iip_ecosphere.platform.deviceMgt.thingsboard.ThingsBoardDeviceRegistry;
import de.iip_ecosphere.platform.deviceMgt.thingsboard.ThingsBoardDeviceRegistryFactoryDescriptor;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.thingsboard.rest.client.RestClient;

public class PerformanceTests {
    public static final String A_DEVICE = "A_DEVICE";
    public static final String AN_IP = "AN_IP";
    private ThingsBoardDeviceRegistry registry;
    private RestClient restClient;

    @Before
    public void setUp() {
        ThingsBoardDeviceRegistryFactoryDescriptor factory = new ThingsBoardDeviceRegistryFactoryDescriptor();
        this.registry = (ThingsBoardDeviceRegistry)factory.createDeviceRegistryInstance();
        this.restClient = new RestClient("http://localhost:8080");
        this.restClient.login("tenant@thingsboard.org", "tenant");
    }

    @After
    public void tearDown() {
        this.registry.getIds().forEach(d -> this.registry.removeDevice(d));
    }

    @Test
    public void testAddSpeed() {
        long time = this.add(IntegrationTests.generateRandomIds(1));
        System.out.printf("Single Add finished in: %dms%n", time);
        time = this.add(IntegrationTests.generateRandomIds(1));
        System.out.printf("Single Add finished in: %dms%n", time);
        time = this.add(IntegrationTests.generateRandomIds(1));
        System.out.printf("Single Add finished in: %dms%n", time);
        int count = 500;
        time = this.add(IntegrationTests.generateRandomIds(count));
        System.out.printf("Mass (%dx) Add finished in: %dms", count, time);
    }

    @Test
    public void testRemoveSpeed() {
        for (int i = 0; i < 5; ++i) {
            List<String> ids = IntegrationTests.generateRandomIds(1);
            this.add(ids);
            long time = this.remove(ids);
            System.out.printf("Single Remove finished in: %dms%n", time);
        }
        List<String> ids = IntegrationTests.generateRandomIds(500);
        this.add(ids);
        long time = this.remove(ids);
        System.out.printf("Mass (%dx) Remove finished in: %dms", 500, time);
    }

    private long remove(List<String> ids) {
        long start = System.currentTimeMillis();
        ids.forEach(id -> this.registry.removeDevice(id));
        long end = System.currentTimeMillis();
        long time = end - start;
        return time;
    }

    private long add(List<String> ids) {
        long start = System.currentTimeMillis();
        ids.forEach(id -> this.registry.addDevice(id, AN_IP));
        long end = System.currentTimeMillis();
        return end - start;
    }
}

