/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rest.client.utils.RestJsonConverter;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.ClaimRequest;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceInfo;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceProfileInfo;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.EntityViewInfo;
import org.thingsboard.server.common.data.Event;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantInfo;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.UpdateMessage;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetInfo;
import org.thingsboard.server.common.data.asset.AssetSearchQuery;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.audit.AuditLog;
import org.thingsboard.server.common.data.device.DeviceSearchQuery;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeSearchQuery;
import org.thingsboard.server.common.data.entityview.EntityViewSearchQuery;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.OAuth2ClientRegistrationTemplateId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.oauth2.OAuth2ClientInfo;
import org.thingsboard.server.common.data.oauth2.OAuth2ClientRegistrationTemplate;
import org.thingsboard.server.common.data.oauth2.OAuth2Info;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.common.data.ota.ChecksumAlgorithm;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.plugin.ComponentDescriptor;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.query.AlarmData;
import org.thingsboard.server.common.data.query.AlarmDataQuery;
import org.thingsboard.server.common.data.query.EntityCountQuery;
import org.thingsboard.server.common.data.query.EntityData;
import org.thingsboard.server.common.data.query.EntityDataQuery;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationInfo;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.rule.DefaultRuleChainCreateRequest;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainData;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsType;
import org.thingsboard.server.common.data.security.model.SecuritySettings;
import org.thingsboard.server.common.data.security.model.UserPasswordPolicy;
import org.thingsboard.server.common.data.sms.config.TestSmsRequest;
import org.thingsboard.server.common.data.widget.WidgetType;
import org.thingsboard.server.common.data.widget.WidgetsBundle;

public class RestClient
implements ClientHttpRequestInterceptor,
Closeable {
    private static final String JWT_TOKEN_HEADER_PARAM = "X-Authorization";
    protected final RestTemplate restTemplate;
    protected final String baseURL;
    private String token;
    private String refreshToken;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private ExecutorService service = ThingsBoardExecutors.newWorkStealingPool((int)10, this.getClass());
    protected static final String ACTIVATE_TOKEN_REGEX = "/api/noauth/activate?activateToken=";

    public RestClient(String baseURL) {
        this(new RestTemplate(), baseURL);
    }

    public RestClient(RestTemplate restTemplate, String baseURL) {
        this.restTemplate = restTemplate;
        this.baseURL = baseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] bytes, ClientHttpRequestExecution execution) throws IOException {
        HttpRequestWrapper wrapper = new HttpRequestWrapper(request);
        wrapper.getHeaders().set(JWT_TOKEN_HEADER_PARAM, "Bearer " + this.token);
        ClientHttpResponse response = execution.execute((HttpRequest)wrapper, bytes);
        if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
            RestClient restClient = this;
            synchronized (restClient) {
                this.restTemplate.getInterceptors().remove(this);
                this.refreshToken();
                wrapper.getHeaders().set(JWT_TOKEN_HEADER_PARAM, "Bearer " + this.token);
                return execution.execute((HttpRequest)wrapper, bytes);
            }
        }
        return response;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public String getToken() {
        return this.token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void refreshToken() {
        HashMap<String, String> refreshTokenRequest = new HashMap<String, String>();
        refreshTokenRequest.put("refreshToken", this.refreshToken);
        ResponseEntity tokenInfo = this.restTemplate.postForEntity(this.baseURL + "/api/auth/token", refreshTokenRequest, JsonNode.class, new Object[0]);
        this.setTokenInfo((JsonNode)tokenInfo.getBody());
    }

    public void login(String username, String password) {
        HashMap<String, String> loginRequest = new HashMap<String, String>();
        loginRequest.put("username", username);
        loginRequest.put("password", password);
        ResponseEntity tokenInfo = this.restTemplate.postForEntity(this.baseURL + "/api/auth/login", loginRequest, JsonNode.class, new Object[0]);
        this.setTokenInfo((JsonNode)tokenInfo.getBody());
    }

    private void setTokenInfo(JsonNode tokenInfo) {
        this.token = tokenInfo.get("token").asText();
        this.refreshToken = tokenInfo.get("refreshToken").asText();
        this.restTemplate.getInterceptors().add(this);
    }

    public Optional<AdminSettings> getAdminSettings(String key) {
        try {
            ResponseEntity adminSettings = this.restTemplate.getForEntity(this.baseURL + "/api/admin/settings/{key}", AdminSettings.class, new Object[]{key});
            return Optional.ofNullable((AdminSettings)adminSettings.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public AdminSettings saveAdminSettings(AdminSettings adminSettings) {
        return (AdminSettings)this.restTemplate.postForEntity(this.baseURL + "/api/admin/settings", (Object)adminSettings, AdminSettings.class, new Object[0]).getBody();
    }

    public void sendTestMail(AdminSettings adminSettings) {
        this.restTemplate.postForLocation(this.baseURL + "/api/admin/settings/testMail", (Object)adminSettings, new Object[0]);
    }

    public void sendTestSms(TestSmsRequest testSmsRequest) {
        this.restTemplate.postForLocation(this.baseURL + "/api/admin/settings/testSms", (Object)testSmsRequest, new Object[0]);
    }

    public Optional<SecuritySettings> getSecuritySettings() {
        try {
            ResponseEntity securitySettings = this.restTemplate.getForEntity(this.baseURL + "/api/admin/securitySettings", SecuritySettings.class, new Object[0]);
            return Optional.ofNullable((SecuritySettings)securitySettings.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public SecuritySettings saveSecuritySettings(SecuritySettings securitySettings) {
        return (SecuritySettings)this.restTemplate.postForEntity(this.baseURL + "/api/admin/securitySettings", (Object)securitySettings, SecuritySettings.class, new Object[0]).getBody();
    }

    public Optional<UpdateMessage> checkUpdates() {
        try {
            ResponseEntity updateMsg = this.restTemplate.getForEntity(this.baseURL + "/api/admin/updates", UpdateMessage.class, new Object[0]);
            return Optional.ofNullable((UpdateMessage)updateMsg.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Alarm> getAlarmById(AlarmId alarmId) {
        try {
            ResponseEntity alarm = this.restTemplate.getForEntity(this.baseURL + "/api/alarm/{alarmId}", Alarm.class, new Object[]{alarmId.getId()});
            return Optional.ofNullable((Alarm)alarm.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<AlarmInfo> getAlarmInfoById(AlarmId alarmId) {
        try {
            ResponseEntity alarmInfo = this.restTemplate.getForEntity(this.baseURL + "/api/alarm/info/{alarmId}", AlarmInfo.class, new Object[]{alarmId.getId()});
            return Optional.ofNullable((AlarmInfo)alarmInfo.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Alarm saveAlarm(Alarm alarm) {
        return (Alarm)this.restTemplate.postForEntity(this.baseURL + "/api/alarm", (Object)alarm, Alarm.class, new Object[0]).getBody();
    }

    public void deleteAlarm(AlarmId alarmId) {
        this.restTemplate.delete(this.baseURL + "/api/alarm/{alarmId}", new Object[]{alarmId.getId()});
    }

    public void ackAlarm(AlarmId alarmId) {
        this.restTemplate.postForLocation(this.baseURL + "/api/alarm/{alarmId}/ack", null, new Object[]{alarmId.getId()});
    }

    public void clearAlarm(AlarmId alarmId) {
        this.restTemplate.postForLocation(this.baseURL + "/api/alarm/{alarmId}/clear", null, new Object[]{alarmId.getId()});
    }

    public PageData<AlarmInfo> getAlarms(EntityId entityId, AlarmSearchStatus searchStatus, AlarmStatus status, TimePageLink pageLink, Boolean fetchOriginator) {
        Object urlSecondPart = "/api/alarm/{entityType}/{entityId}?fetchOriginator={fetchOriginator}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("entityType", entityId.getEntityType().name());
        params.put("entityId", entityId.getId().toString());
        params.put("fetchOriginator", String.valueOf(fetchOriginator));
        if (searchStatus != null) {
            params.put("searchStatus", searchStatus.name());
            urlSecondPart = (String)urlSecondPart + "&searchStatus={searchStatus}";
        }
        if (status != null) {
            params.put("status", status.name());
            urlSecondPart = (String)urlSecondPart + "&status={status}";
        }
        this.addTimePageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + (String)urlSecondPart + "&" + this.getTimeUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<AlarmInfo>>(){}, params).getBody();
    }

    public Optional<AlarmSeverity> getHighestAlarmSeverity(EntityId entityId, AlarmSearchStatus searchStatus, AlarmStatus status) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("entityType", entityId.getEntityType().name());
        params.put("entityId", entityId.getId().toString());
        params.put("searchStatus", searchStatus.name());
        params.put("status", status.name());
        try {
            ResponseEntity alarmSeverity = this.restTemplate.getForEntity(this.baseURL + "/api/alarm/highestSeverity/{entityType}/{entityId}?searchStatus={searchStatus}&status={status}", AlarmSeverity.class, params);
            return Optional.ofNullable((AlarmSeverity)alarmSeverity.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    @Deprecated
    public Alarm createAlarm(Alarm alarm) {
        return (Alarm)this.restTemplate.postForEntity(this.baseURL + "/api/alarm", (Object)alarm, Alarm.class, new Object[0]).getBody();
    }

    public Optional<Asset> getAssetById(AssetId assetId) {
        try {
            ResponseEntity asset = this.restTemplate.getForEntity(this.baseURL + "/api/asset/{assetId}", Asset.class, new Object[]{assetId.getId()});
            return Optional.ofNullable((Asset)asset.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<AssetInfo> getAssetInfoById(AssetId assetId) {
        try {
            ResponseEntity asset = this.restTemplate.getForEntity(this.baseURL + "/api/asset/info/{assetId}", AssetInfo.class, new Object[]{assetId.getId()});
            return Optional.ofNullable((AssetInfo)asset.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Asset saveAsset(Asset asset) {
        return (Asset)this.restTemplate.postForEntity(this.baseURL + "/api/asset", (Object)asset, Asset.class, new Object[0]).getBody();
    }

    public void deleteAsset(AssetId assetId) {
        this.restTemplate.delete(this.baseURL + "/api/asset/{assetId}", new Object[]{assetId.getId()});
    }

    public Optional<Asset> assignAssetToCustomer(CustomerId customerId, AssetId assetId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerId", customerId.getId().toString());
        params.put("assetId", assetId.getId().toString());
        try {
            ResponseEntity asset = this.restTemplate.postForEntity(this.baseURL + "/api/customer/{customerId}/asset/{assetId}", null, Asset.class, params);
            return Optional.ofNullable((Asset)asset.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Asset> unassignAssetFromCustomer(AssetId assetId) {
        try {
            ResponseEntity asset = this.restTemplate.exchange(this.baseURL + "/api/customer/asset/{assetId}", HttpMethod.DELETE, HttpEntity.EMPTY, Asset.class, new Object[]{assetId.getId()});
            return Optional.ofNullable((Asset)asset.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Asset> assignAssetToPublicCustomer(AssetId assetId) {
        try {
            ResponseEntity asset = this.restTemplate.postForEntity(this.baseURL + "/api/customer/public/asset/{assetId}", null, Asset.class, new Object[]{assetId.getId()});
            return Optional.ofNullable((Asset)asset.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<Asset> getTenantAssets(PageLink pageLink, String assetType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", assetType);
        this.addPageLinkToParam(params, pageLink);
        ResponseEntity assets = this.restTemplate.exchange(this.baseURL + "/api/tenant/assets?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Asset>>(){}, params);
        return (PageData)assets.getBody();
    }

    public PageData<AssetInfo> getTenantAssetInfos(PageLink pageLink, String assetType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", assetType);
        this.addPageLinkToParam(params, pageLink);
        ResponseEntity assets = this.restTemplate.exchange(this.baseURL + "/api/tenant/assetInfos?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<AssetInfo>>(){}, params);
        return (PageData)assets.getBody();
    }

    public Optional<Asset> getTenantAsset(String assetName) {
        try {
            ResponseEntity asset = this.restTemplate.getForEntity(this.baseURL + "/api/tenant/assets?assetName={assetName}", Asset.class, new Object[]{assetName});
            return Optional.ofNullable((Asset)asset.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<Asset> getCustomerAssets(CustomerId customerId, PageLink pageLink, String assetType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerId", customerId.getId().toString());
        params.put("type", assetType);
        this.addPageLinkToParam(params, pageLink);
        ResponseEntity assets = this.restTemplate.exchange(this.baseURL + "/api/customer/{customerId}/assets?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Asset>>(){}, params);
        return (PageData)assets.getBody();
    }

    public PageData<AssetInfo> getCustomerAssetInfos(CustomerId customerId, PageLink pageLink, String assetType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerId", customerId.getId().toString());
        params.put("type", assetType);
        this.addPageLinkToParam(params, pageLink);
        ResponseEntity assets = this.restTemplate.exchange(this.baseURL + "/api/customer/{customerId}/assetInfos?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<AssetInfo>>(){}, params);
        return (PageData)assets.getBody();
    }

    public List<Asset> getAssetsByIds(List<AssetId> assetIds) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/assets?assetIds={assetIds}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Asset>>(){}, new Object[]{this.listIdsToString(assetIds)}).getBody();
    }

    public List<Asset> findByQuery(AssetSearchQuery query) {
        return (List)this.restTemplate.exchange(URI.create(this.baseURL + "/api/assets"), HttpMethod.POST, new HttpEntity((Object)query), (ParameterizedTypeReference)new ParameterizedTypeReference<List<Asset>>(){}).getBody();
    }

    public List<EntitySubtype> getAssetTypes() {
        return (List)this.restTemplate.exchange(URI.create(this.baseURL + "/api/asset/types"), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntitySubtype>>(){}).getBody();
    }

    @Deprecated
    public Optional<Asset> findAsset(String name) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("assetName", name);
        try {
            ResponseEntity assetEntity = this.restTemplate.getForEntity(this.baseURL + "/api/tenant/assets?assetName={assetName}", Asset.class, params);
            return Optional.of((Asset)assetEntity.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    @Deprecated
    public Asset createAsset(Asset asset) {
        return (Asset)this.restTemplate.postForEntity(this.baseURL + "/api/asset", (Object)asset, Asset.class, new Object[0]).getBody();
    }

    @Deprecated
    public Asset createAsset(String name, String type) {
        Asset asset = new Asset();
        asset.setName(name);
        asset.setType(type);
        return (Asset)this.restTemplate.postForEntity(this.baseURL + "/api/asset", (Object)asset, Asset.class, new Object[0]).getBody();
    }

    @Deprecated
    public Asset assignAsset(CustomerId customerId, AssetId assetId) {
        return (Asset)this.restTemplate.postForEntity(this.baseURL + "/api/customer/{customerId}/asset/{assetId}", (Object)HttpEntity.EMPTY, Asset.class, new Object[]{customerId.toString(), assetId.toString()}).getBody();
    }

    public PageData<AuditLog> getAuditLogsByCustomerId(CustomerId customerId, TimePageLink pageLink, List<ActionType> actionTypes) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerId", customerId.getId().toString());
        params.put("actionTypes", this.listEnumToString(actionTypes));
        this.addTimePageLinkToParam(params, pageLink);
        ResponseEntity auditLog = this.restTemplate.exchange(this.baseURL + "/api/audit/logs/customer/{customerId}?actionTypes={actionTypes}&" + this.getTimeUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<AuditLog>>(){}, params);
        return (PageData)auditLog.getBody();
    }

    public PageData<AuditLog> getAuditLogsByUserId(UserId userId, TimePageLink pageLink, List<ActionType> actionTypes) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId.getId().toString());
        params.put("actionTypes", this.listEnumToString(actionTypes));
        this.addTimePageLinkToParam(params, pageLink);
        ResponseEntity auditLog = this.restTemplate.exchange(this.baseURL + "/api/audit/logs/user/{userId}?actionTypes={actionTypes}&" + this.getTimeUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<AuditLog>>(){}, params);
        return (PageData)auditLog.getBody();
    }

    public PageData<AuditLog> getAuditLogsByEntityId(EntityId entityId, List<ActionType> actionTypes, TimePageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("entityType", entityId.getEntityType().name());
        params.put("entityId", entityId.getId().toString());
        params.put("actionTypes", this.listEnumToString(actionTypes));
        this.addTimePageLinkToParam(params, pageLink);
        ResponseEntity auditLog = this.restTemplate.exchange(this.baseURL + "/api/audit/logs/entity/{entityType}/{entityId}?actionTypes={actionTypes}&" + this.getTimeUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<AuditLog>>(){}, params);
        return (PageData)auditLog.getBody();
    }

    public PageData<AuditLog> getAuditLogs(TimePageLink pageLink, List<ActionType> actionTypes) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("actionTypes", this.listEnumToString(actionTypes));
        this.addTimePageLinkToParam(params, pageLink);
        ResponseEntity auditLog = this.restTemplate.exchange(this.baseURL + "/api/audit/logs?actionTypes={actionTypes}&" + this.getTimeUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<AuditLog>>(){}, params);
        return (PageData)auditLog.getBody();
    }

    public String getActivateToken(UserId userId) {
        String activationLink = this.getActivationLink(userId);
        return activationLink.substring(activationLink.lastIndexOf(ACTIVATE_TOKEN_REGEX) + ACTIVATE_TOKEN_REGEX.length());
    }

    public Optional<User> getUser() {
        ResponseEntity user = this.restTemplate.getForEntity(this.baseURL + "/api/auth/user", User.class, new Object[0]);
        return Optional.ofNullable((User)user.getBody());
    }

    public void logout() {
        this.restTemplate.postForLocation(this.baseURL + "/api/auth/logout", null, new Object[0]);
    }

    public void changePassword(String currentPassword, String newPassword) {
        ObjectNode changePasswordRequest = this.objectMapper.createObjectNode();
        changePasswordRequest.put("currentPassword", currentPassword);
        changePasswordRequest.put("newPassword", newPassword);
        this.restTemplate.postForLocation(this.baseURL + "/api/auth/changePassword", (Object)changePasswordRequest, new Object[0]);
    }

    public Optional<UserPasswordPolicy> getUserPasswordPolicy() {
        try {
            ResponseEntity userPasswordPolicy = this.restTemplate.getForEntity(this.baseURL + "/api/noauth/userPasswordPolicy", UserPasswordPolicy.class, new Object[0]);
            return Optional.ofNullable((UserPasswordPolicy)userPasswordPolicy.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public ResponseEntity<String> checkActivateToken(UserId userId) {
        String activateToken = this.getActivateToken(userId);
        return this.restTemplate.getForEntity(this.baseURL + "/api/noauth/activate?activateToken={activateToken}", String.class, new Object[]{activateToken});
    }

    public void requestResetPasswordByEmail(String email) {
        ObjectNode resetPasswordByEmailRequest = this.objectMapper.createObjectNode();
        resetPasswordByEmailRequest.put("email", email);
        this.restTemplate.postForLocation(this.baseURL + "/api/noauth/resetPasswordByEmail", (Object)resetPasswordByEmailRequest, new Object[0]);
    }

    public Optional<JsonNode> activateUser(UserId userId, String password) {
        return this.activateUser(userId, password, true);
    }

    public Optional<JsonNode> activateUser(UserId userId, String password, boolean sendActivationMail) {
        ObjectNode activateRequest = this.objectMapper.createObjectNode();
        activateRequest.put("activateToken", this.getActivateToken(userId));
        activateRequest.put("password", password);
        try {
            ResponseEntity jsonNode = this.restTemplate.postForEntity(this.baseURL + "/api/noauth/activate?sendActivationMail={sendActivationMail}", (Object)activateRequest, JsonNode.class, new Object[]{sendActivationMail});
            return Optional.ofNullable((JsonNode)jsonNode.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<ComponentDescriptor> getComponentDescriptorByClazz(String componentDescriptorClazz) {
        try {
            ResponseEntity componentDescriptor = this.restTemplate.getForEntity(this.baseURL + "/api/component/{componentDescriptorClazz}", ComponentDescriptor.class, new Object[]{componentDescriptorClazz});
            return Optional.ofNullable((ComponentDescriptor)componentDescriptor.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public List<ComponentDescriptor> getComponentDescriptorsByType(ComponentType componentType) {
        return this.getComponentDescriptorsByType(componentType, RuleChainType.CORE);
    }

    public List<ComponentDescriptor> getComponentDescriptorsByType(ComponentType componentType, RuleChainType ruleChainType) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/components/" + componentType.name() + "/?ruleChainType={ruleChainType}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ComponentDescriptor>>(){}, new Object[]{ruleChainType}).getBody();
    }

    public List<ComponentDescriptor> getComponentDescriptorsByTypes(List<ComponentType> componentTypes) {
        return this.getComponentDescriptorsByTypes(componentTypes, RuleChainType.CORE);
    }

    public List<ComponentDescriptor> getComponentDescriptorsByTypes(List<ComponentType> componentTypes, RuleChainType ruleChainType) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/components?componentTypes={componentTypes}&ruleChainType={ruleChainType}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ComponentDescriptor>>(){}, new Object[]{this.listEnumToString(componentTypes), ruleChainType}).getBody();
    }

    public Optional<Customer> getCustomerById(CustomerId customerId) {
        try {
            ResponseEntity customer = this.restTemplate.getForEntity(this.baseURL + "/api/customer/{customerId}", Customer.class, new Object[]{customerId.getId()});
            return Optional.ofNullable((Customer)customer.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<JsonNode> getShortCustomerInfoById(CustomerId customerId) {
        try {
            ResponseEntity customerInfo = this.restTemplate.getForEntity(this.baseURL + "/api/customer/{customerId}/shortInfo", JsonNode.class, new Object[]{customerId.getId()});
            return Optional.ofNullable((JsonNode)customerInfo.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public String getCustomerTitleById(CustomerId customerId) {
        return (String)this.restTemplate.getForObject(this.baseURL + "/api/customer/{customerId}/title", String.class, new Object[]{customerId.getId()});
    }

    public Customer saveCustomer(Customer customer) {
        return (Customer)this.restTemplate.postForEntity(this.baseURL + "/api/customer", (Object)customer, Customer.class, new Object[0]).getBody();
    }

    public void deleteCustomer(CustomerId customerId) {
        this.restTemplate.delete(this.baseURL + "/api/customer/{customerId}", new Object[]{customerId.getId()});
    }

    public PageData<Customer> getCustomers(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        ResponseEntity customer = this.restTemplate.exchange(this.baseURL + "/api/customers?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Customer>>(){}, params);
        return (PageData)customer.getBody();
    }

    public Optional<Customer> getTenantCustomer(String customerTitle) {
        try {
            ResponseEntity customer = this.restTemplate.getForEntity(this.baseURL + "/api/tenant/customers?customerTitle={customerTitle}", Customer.class, new Object[]{customerTitle});
            return Optional.ofNullable((Customer)customer.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    @Deprecated
    public Optional<Customer> findCustomer(String title) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerTitle", title);
        try {
            ResponseEntity customerEntity = this.restTemplate.getForEntity(this.baseURL + "/api/tenant/customers?customerTitle={customerTitle}", Customer.class, params);
            return Optional.of((Customer)customerEntity.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    @Deprecated
    public Customer createCustomer(Customer customer) {
        return (Customer)this.restTemplate.postForEntity(this.baseURL + "/api/customer", (Object)customer, Customer.class, new Object[0]).getBody();
    }

    @Deprecated
    public Customer createCustomer(String title) {
        Customer customer = new Customer();
        customer.setTitle(title);
        return (Customer)this.restTemplate.postForEntity(this.baseURL + "/api/customer", (Object)customer, Customer.class, new Object[0]).getBody();
    }

    public Long getServerTime() {
        return (Long)this.restTemplate.getForObject(this.baseURL + "/api/dashboard/serverTime", Long.class, new Object[0]);
    }

    public Long getMaxDatapointsLimit() {
        return (Long)this.restTemplate.getForObject(this.baseURL + "/api/dashboard/maxDatapointsLimit", Long.class, new Object[0]);
    }

    public Optional<DashboardInfo> getDashboardInfoById(DashboardId dashboardId) {
        try {
            ResponseEntity dashboardInfo = this.restTemplate.getForEntity(this.baseURL + "/api/dashboard/info/{dashboardId}", DashboardInfo.class, new Object[]{dashboardId.getId()});
            return Optional.ofNullable((DashboardInfo)dashboardInfo.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Dashboard> getDashboardById(DashboardId dashboardId) {
        try {
            ResponseEntity dashboard = this.restTemplate.getForEntity(this.baseURL + "/api/dashboard/{dashboardId}", Dashboard.class, new Object[]{dashboardId.getId()});
            return Optional.ofNullable((Dashboard)dashboard.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Dashboard saveDashboard(Dashboard dashboard) {
        return (Dashboard)this.restTemplate.postForEntity(this.baseURL + "/api/dashboard", (Object)dashboard, Dashboard.class, new Object[0]).getBody();
    }

    public void deleteDashboard(DashboardId dashboardId) {
        this.restTemplate.delete(this.baseURL + "/api/dashboard/{dashboardId}", new Object[]{dashboardId.getId()});
    }

    public Optional<Dashboard> assignDashboardToCustomer(CustomerId customerId, DashboardId dashboardId) {
        try {
            ResponseEntity dashboard = this.restTemplate.postForEntity(this.baseURL + "/api/customer/{customerId}/dashboard/{dashboardId}", null, Dashboard.class, new Object[]{customerId.getId(), dashboardId.getId()});
            return Optional.ofNullable((Dashboard)dashboard.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Dashboard> unassignDashboardFromCustomer(CustomerId customerId, DashboardId dashboardId) {
        try {
            ResponseEntity dashboard = this.restTemplate.exchange(this.baseURL + "/api/customer/{customerId}/dashboard/{dashboardId}", HttpMethod.DELETE, HttpEntity.EMPTY, Dashboard.class, new Object[]{customerId.getId(), dashboardId.getId()});
            return Optional.ofNullable((Dashboard)dashboard.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Dashboard> updateDashboardCustomers(DashboardId dashboardId, List<CustomerId> customerIds) {
        Object[] customerIdArray = customerIds.stream().map(customerId -> customerId.getId().toString()).toArray();
        try {
            ResponseEntity dashboard = this.restTemplate.postForEntity(this.baseURL + "/api/dashboard/{dashboardId}/customers", (Object)customerIdArray, Dashboard.class, new Object[]{dashboardId.getId()});
            return Optional.ofNullable((Dashboard)dashboard.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Dashboard> addDashboardCustomers(DashboardId dashboardId, List<CustomerId> customerIds) {
        Object[] customerIdArray = customerIds.stream().map(customerId -> customerId.getId().toString()).toArray();
        try {
            ResponseEntity dashboard = this.restTemplate.postForEntity(this.baseURL + "/api/dashboard/{dashboardId}/customers/add", (Object)customerIdArray, Dashboard.class, new Object[]{dashboardId.getId()});
            return Optional.ofNullable((Dashboard)dashboard.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Dashboard> removeDashboardCustomers(DashboardId dashboardId, List<CustomerId> customerIds) {
        Object[] customerIdArray = customerIds.stream().map(customerId -> customerId.getId().toString()).toArray();
        try {
            ResponseEntity dashboard = this.restTemplate.postForEntity(this.baseURL + "/api/dashboard/{dashboardId}/customers/remove", (Object)customerIdArray, Dashboard.class, new Object[]{dashboardId.getId()});
            return Optional.ofNullable((Dashboard)dashboard.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Dashboard> assignDashboardToPublicCustomer(DashboardId dashboardId) {
        try {
            ResponseEntity dashboard = this.restTemplate.postForEntity(this.baseURL + "/api/customer/public/dashboard/{dashboardId}", null, Dashboard.class, new Object[]{dashboardId.getId()});
            return Optional.ofNullable((Dashboard)dashboard.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Dashboard> unassignDashboardFromPublicCustomer(DashboardId dashboardId) {
        try {
            ResponseEntity dashboard = this.restTemplate.exchange(this.baseURL + "/api/customer/public/dashboard/{dashboardId}", HttpMethod.DELETE, HttpEntity.EMPTY, Dashboard.class, new Object[]{dashboardId.getId()});
            return Optional.ofNullable((Dashboard)dashboard.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<DashboardInfo> getTenantDashboards(TenantId tenantId, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId.getId().toString());
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenant/{tenantId}/dashboards?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<DashboardInfo>>(){}, params).getBody();
    }

    public PageData<DashboardInfo> getTenantDashboards(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenant/dashboards?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<DashboardInfo>>(){}, params).getBody();
    }

    public PageData<DashboardInfo> getCustomerDashboards(CustomerId customerId, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerId", customerId.getId().toString());
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/customer/{customerId}/dashboards?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<DashboardInfo>>(){}, params).getBody();
    }

    @Deprecated
    public Dashboard createDashboard(Dashboard dashboard) {
        return (Dashboard)this.restTemplate.postForEntity(this.baseURL + "/api/dashboard", (Object)dashboard, Dashboard.class, new Object[0]).getBody();
    }

    @Deprecated
    public List<DashboardInfo> findTenantDashboards() {
        try {
            ResponseEntity dashboards = this.restTemplate.exchange(this.baseURL + "/api/tenant/dashboards?pageSize=100000", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<DashboardInfo>>(){}, new Object[0]);
            return ((PageData)dashboards.getBody()).getData();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Collections.emptyList();
            }
            throw exception;
        }
    }

    public Optional<Device> getDeviceById(DeviceId deviceId) {
        try {
            ResponseEntity device = this.restTemplate.getForEntity(this.baseURL + "/api/device/{deviceId}", Device.class, new Object[]{deviceId.getId()});
            return Optional.ofNullable((Device)device.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<DeviceInfo> getDeviceInfoById(DeviceId deviceId) {
        try {
            ResponseEntity device = this.restTemplate.getForEntity(this.baseURL + "/api/device/info/{deviceId}", DeviceInfo.class, new Object[]{deviceId});
            return Optional.ofNullable((DeviceInfo)device.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Device saveDevice(Device device) {
        return this.saveDevice(device, null);
    }

    public Device saveDevice(Device device, String accessToken) {
        return (Device)this.restTemplate.postForEntity(this.baseURL + "/api/device?accessToken={accessToken}", (Object)device, Device.class, new Object[]{accessToken}).getBody();
    }

    public void deleteDevice(DeviceId deviceId) {
        this.restTemplate.delete(this.baseURL + "/api/device/{deviceId}", new Object[]{deviceId.getId()});
    }

    public Optional<Device> assignDeviceToCustomer(CustomerId customerId, DeviceId deviceId) {
        try {
            ResponseEntity device = this.restTemplate.postForEntity(this.baseURL + "/api/customer/{customerId}/device/{deviceId}", null, Device.class, new Object[]{customerId.getId(), deviceId.getId()});
            return Optional.ofNullable((Device)device.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Device> unassignDeviceFromCustomer(DeviceId deviceId) {
        try {
            ResponseEntity device = this.restTemplate.exchange(this.baseURL + "/api/customer/device/{deviceId}", HttpMethod.DELETE, HttpEntity.EMPTY, Device.class, new Object[]{deviceId.getId()});
            return Optional.ofNullable((Device)device.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Device> assignDeviceToPublicCustomer(DeviceId deviceId) {
        try {
            ResponseEntity device = this.restTemplate.postForEntity(this.baseURL + "/api/customer/public/device/{deviceId}", null, Device.class, new Object[]{deviceId.getId()});
            return Optional.ofNullable((Device)device.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<DeviceCredentials> getDeviceCredentialsByDeviceId(DeviceId deviceId) {
        try {
            ResponseEntity deviceCredentials = this.restTemplate.getForEntity(this.baseURL + "/api/device/{deviceId}/credentials", DeviceCredentials.class, new Object[]{deviceId.getId()});
            return Optional.ofNullable((DeviceCredentials)deviceCredentials.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public DeviceCredentials saveDeviceCredentials(DeviceCredentials deviceCredentials) {
        return (DeviceCredentials)this.restTemplate.postForEntity(this.baseURL + "/api/device/credentials", (Object)deviceCredentials, DeviceCredentials.class, new Object[0]).getBody();
    }

    public Optional<Device> saveDeviceWithCredentials(Device device, DeviceCredentials credentials) {
        try {
            ConcurrentHashMap<Class, Object> deviceCredentials = new ConcurrentHashMap<Class, Object>();
            deviceCredentials.put(Device.class, device);
            deviceCredentials.put(DeviceCredentials.class, credentials);
            ResponseEntity deviceOpt = this.restTemplate.postForEntity(this.baseURL + "/api/lwm2m/device-credentials", deviceCredentials, Device.class, new Object[0]);
            return Optional.ofNullable((Device)deviceOpt.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<Device> getTenantDevices(String type, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", type);
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenant/devices?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Device>>(){}, params).getBody();
    }

    public PageData<DeviceInfo> getTenantDeviceInfos(String type, DeviceProfileId deviceProfileId, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", type);
        params.put("deviceProfileId", deviceProfileId != null ? deviceProfileId.toString() : null);
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenant/deviceInfos?type={type}&deviceProfileId={deviceProfileId}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<DeviceInfo>>(){}, params).getBody();
    }

    public Optional<Device> getTenantDevice(String deviceName) {
        try {
            ResponseEntity device = this.restTemplate.getForEntity(this.baseURL + "/api/tenant/devices?deviceName={deviceName}", Device.class, new Object[]{deviceName});
            return Optional.ofNullable((Device)device.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<Device> getCustomerDevices(CustomerId customerId, String deviceType, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerId", customerId.getId().toString());
        params.put("type", deviceType);
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/customer/{customerId}/devices?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Device>>(){}, params).getBody();
    }

    public PageData<DeviceInfo> getCustomerDeviceInfos(CustomerId customerId, String deviceType, DeviceProfileId deviceProfileId, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerId", customerId.toString());
        params.put("type", deviceType);
        params.put("deviceProfileId", deviceProfileId != null ? deviceProfileId.toString() : null);
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/customer/{customerId}/devices?type={type}&deviceProfileId={deviceProfileId}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<DeviceInfo>>(){}, params).getBody();
    }

    public List<Device> getDevicesByIds(List<DeviceId> deviceIds) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/devices?deviceIds={deviceIds}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Device>>(){}, new Object[]{this.listIdsToString(deviceIds)}).getBody();
    }

    public List<Device> findByQuery(DeviceSearchQuery query) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/devices", HttpMethod.POST, new HttpEntity((Object)query), (ParameterizedTypeReference)new ParameterizedTypeReference<List<Device>>(){}, new Object[0]).getBody();
    }

    public List<EntitySubtype> getDeviceTypes() {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/device/types", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntitySubtype>>(){}, new Object[0]).getBody();
    }

    public JsonNode claimDevice(String deviceName, ClaimRequest claimRequest) {
        return (JsonNode)this.restTemplate.exchange(this.baseURL + "/api/customer/device/{deviceName}/claim", HttpMethod.POST, new HttpEntity((Object)claimRequest), (ParameterizedTypeReference)new ParameterizedTypeReference<JsonNode>(){}, new Object[]{deviceName}).getBody();
    }

    public void reClaimDevice(String deviceName) {
        this.restTemplate.delete(this.baseURL + "/api/customer/device/{deviceName}/claim", new Object[]{deviceName});
    }

    public Device assignDeviceToTenant(TenantId tenantId, DeviceId deviceId) {
        return (Device)this.restTemplate.postForEntity(this.baseURL + "/api/tenant/{tenantId}/device/{deviceId}", (Object)HttpEntity.EMPTY, Device.class, new Object[]{tenantId, deviceId}).getBody();
    }

    public Long countDevicesByTenantIdAndDeviceProfileIdAndEmptyOtaPackage(OtaPackageType otaPackageType, DeviceProfileId deviceProfileId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("otaPackageType", otaPackageType.name());
        params.put("deviceProfileId", deviceProfileId.getId().toString());
        return (Long)this.restTemplate.exchange(this.baseURL + "/api/devices/count/{otaPackageType}/{deviceProfileId}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<Long>(){}, params).getBody();
    }

    @Deprecated
    public Device createDevice(String name, String type) {
        Device device = new Device();
        device.setName(name);
        device.setType(type);
        return this.doCreateDevice(device, null);
    }

    @Deprecated
    public Device createDevice(Device device) {
        return this.doCreateDevice(device, null);
    }

    @Deprecated
    public Device createDevice(Device device, String accessToken) {
        return this.doCreateDevice(device, accessToken);
    }

    @Deprecated
    private Device doCreateDevice(Device device, String accessToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        Object deviceCreationUrl = "/api/device";
        if (!StringUtils.isEmpty((Object)accessToken)) {
            deviceCreationUrl = (String)deviceCreationUrl + "?accessToken={accessToken}";
            params.put("accessToken", accessToken);
        }
        return (Device)this.restTemplate.postForEntity(this.baseURL + (String)deviceCreationUrl, (Object)device, Device.class, params).getBody();
    }

    @Deprecated
    public DeviceCredentials getCredentials(DeviceId id) {
        return (DeviceCredentials)this.restTemplate.getForEntity(this.baseURL + "/api/device/" + id.getId().toString() + "/credentials", DeviceCredentials.class, new Object[0]).getBody();
    }

    @Deprecated
    public Optional<Device> findDevice(String name) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deviceName", name);
        try {
            ResponseEntity deviceEntity = this.restTemplate.getForEntity(this.baseURL + "/api/tenant/devices?deviceName={deviceName}", Device.class, params);
            return Optional.of((Device)deviceEntity.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    @Deprecated
    public DeviceCredentials updateDeviceCredentials(DeviceId deviceId, String token) {
        DeviceCredentials deviceCredentials = this.getCredentials(deviceId);
        deviceCredentials.setCredentialsType(DeviceCredentialsType.ACCESS_TOKEN);
        deviceCredentials.setCredentialsId(token);
        return this.saveDeviceCredentials(deviceCredentials);
    }

    @Deprecated
    public Device assignDevice(CustomerId customerId, DeviceId deviceId) {
        return (Device)this.restTemplate.postForEntity(this.baseURL + "/api/customer/{customerId}/device/{deviceId}", null, Device.class, new Object[]{customerId.toString(), deviceId.toString()}).getBody();
    }

    public Optional<DeviceProfile> getDeviceProfileById(DeviceProfileId deviceProfileId) {
        try {
            ResponseEntity deviceProfile = this.restTemplate.getForEntity(this.baseURL + "/api/deviceProfile/{deviceProfileId}", DeviceProfile.class, new Object[]{deviceProfileId});
            return Optional.ofNullable((DeviceProfile)deviceProfile.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<DeviceProfileInfo> getDeviceProfileInfoById(DeviceProfileId deviceProfileId) {
        try {
            ResponseEntity deviceProfileInfo = this.restTemplate.getForEntity(this.baseURL + "/api/deviceProfileInfo/{deviceProfileId}", DeviceProfileInfo.class, new Object[]{deviceProfileId});
            return Optional.ofNullable((DeviceProfileInfo)deviceProfileInfo.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public DeviceProfileInfo getDefaultDeviceProfileInfo() {
        return (DeviceProfileInfo)this.restTemplate.getForEntity(this.baseURL + "/api/deviceProfileInfo/default", DeviceProfileInfo.class, new Object[0]).getBody();
    }

    public DeviceProfile saveDeviceProfile(DeviceProfile deviceProfile) {
        return (DeviceProfile)this.restTemplate.postForEntity(this.baseURL + "/api/deviceProfile", (Object)deviceProfile, DeviceProfile.class, new Object[0]).getBody();
    }

    public void deleteDeviceProfile(DeviceProfileId deviceProfileId) {
        this.restTemplate.delete(this.baseURL + "/api/deviceProfile/{deviceProfileId}", new Object[]{deviceProfileId});
    }

    public DeviceProfile setDefaultDeviceProfile(DeviceProfileId deviceProfileId) {
        return (DeviceProfile)this.restTemplate.postForEntity(this.baseURL + "/api/deviceProfile/{deviceProfileId}/default", (Object)HttpEntity.EMPTY, DeviceProfile.class, new Object[]{deviceProfileId}).getBody();
    }

    public PageData<DeviceProfile> getDeviceProfiles(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/deviceProfiles?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<DeviceProfile>>(){}, params).getBody();
    }

    public PageData<DeviceProfileInfo> getDeviceProfileInfos(PageLink pageLink, DeviceTransportType deviceTransportType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deviceTransportType", deviceTransportType != null ? deviceTransportType.name() : null);
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/deviceProfileInfos?deviceTransportType={deviceTransportType}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<DeviceProfileInfo>>(){}, params).getBody();
    }

    public Long countEntitiesByQuery(EntityCountQuery query) {
        return (Long)this.restTemplate.postForObject(this.baseURL + "/api/entitiesQuery/count", (Object)query, Long.class, new Object[0]);
    }

    public PageData<EntityData> findEntityDataByQuery(EntityDataQuery query) {
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/entitiesQuery/find", HttpMethod.POST, new HttpEntity((Object)query), (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<EntityData>>(){}, new Object[0]).getBody();
    }

    public PageData<AlarmData> findAlarmDataByQuery(AlarmDataQuery query) {
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/alarmsQuery/find", HttpMethod.POST, new HttpEntity((Object)query), (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<AlarmData>>(){}, new Object[0]).getBody();
    }

    public void saveRelation(EntityRelation relation) {
        this.restTemplate.postForLocation(this.baseURL + "/api/relation", (Object)relation, new Object[0]);
    }

    public void deleteRelation(EntityId fromId, String relationType, RelationTypeGroup relationTypeGroup, EntityId toId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fromId", fromId.getId().toString());
        params.put("fromType", fromId.getEntityType().name());
        params.put("relationType", relationType);
        params.put("relationTypeGroup", relationTypeGroup.name());
        params.put("toId", toId.getId().toString());
        params.put("toType", toId.getEntityType().name());
        this.restTemplate.delete(this.baseURL + "/api/relation?fromId={fromId}&fromType={fromType}&relationType={relationType}&relationTypeGroup={relationTypeGroup}&toId={toId}&toType={toType}", params);
    }

    public void deleteRelations(EntityId entityId) {
        this.restTemplate.delete(this.baseURL + "/api/relations?entityId={entityId}&entityType={entityType}", new Object[]{entityId.getId().toString(), entityId.getEntityType().name()});
    }

    public Optional<EntityRelation> getRelation(EntityId fromId, String relationType, RelationTypeGroup relationTypeGroup, EntityId toId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fromId", fromId.getId().toString());
        params.put("fromType", fromId.getEntityType().name());
        params.put("relationType", relationType);
        params.put("relationTypeGroup", relationTypeGroup.name());
        params.put("toId", toId.getId().toString());
        params.put("toType", toId.getEntityType().name());
        try {
            ResponseEntity entityRelation = this.restTemplate.getForEntity(this.baseURL + "/api/relation?fromId={fromId}&fromType={fromType}&relationType={relationType}&relationTypeGroup={relationTypeGroup}&toId={toId}&toType={toType}", EntityRelation.class, params);
            return Optional.ofNullable((EntityRelation)entityRelation.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public List<EntityRelation> findByFrom(EntityId fromId, RelationTypeGroup relationTypeGroup) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fromId", fromId.getId().toString());
        params.put("fromType", fromId.getEntityType().name());
        params.put("relationTypeGroup", relationTypeGroup.name());
        return (List)this.restTemplate.exchange(this.baseURL + "/api/relations?fromId={fromId}&fromType={fromType}&relationTypeGroup={relationTypeGroup}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntityRelation>>(){}, params).getBody();
    }

    public List<EntityRelationInfo> findInfoByFrom(EntityId fromId, RelationTypeGroup relationTypeGroup) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fromId", fromId.getId().toString());
        params.put("fromType", fromId.getEntityType().name());
        params.put("relationTypeGroup", relationTypeGroup.name());
        return (List)this.restTemplate.exchange(this.baseURL + "/api/relations/info?fromId={fromId}&fromType={fromType}&relationTypeGroup={relationTypeGroup}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntityRelationInfo>>(){}, params).getBody();
    }

    public List<EntityRelation> findByFrom(EntityId fromId, String relationType, RelationTypeGroup relationTypeGroup) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fromId", fromId.getId().toString());
        params.put("fromType", fromId.getEntityType().name());
        params.put("relationType", relationType);
        params.put("relationTypeGroup", relationTypeGroup.name());
        return (List)this.restTemplate.exchange(this.baseURL + "/api/relations?fromId={fromId}&fromType={fromType}&relationType={relationType}&relationTypeGroup={relationTypeGroup}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntityRelation>>(){}, params).getBody();
    }

    public List<EntityRelation> findByTo(EntityId toId, RelationTypeGroup relationTypeGroup) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("toId", toId.getId().toString());
        params.put("toType", toId.getEntityType().name());
        params.put("relationTypeGroup", relationTypeGroup.name());
        return (List)this.restTemplate.exchange(this.baseURL + "/api/relations?toId={toId}&toType={toType}&relationTypeGroup={relationTypeGroup}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntityRelation>>(){}, params).getBody();
    }

    public List<EntityRelationInfo> findInfoByTo(EntityId toId, RelationTypeGroup relationTypeGroup) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("toId", toId.getId().toString());
        params.put("toType", toId.getEntityType().name());
        params.put("relationTypeGroup", relationTypeGroup.name());
        return (List)this.restTemplate.exchange(this.baseURL + "/api/relations/info?toId={toId}&toType={toType}&relationTypeGroup={relationTypeGroup}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntityRelationInfo>>(){}, params).getBody();
    }

    public List<EntityRelation> findByTo(EntityId toId, String relationType, RelationTypeGroup relationTypeGroup) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("toId", toId.getId().toString());
        params.put("toType", toId.getEntityType().name());
        params.put("relationType", relationType);
        params.put("relationTypeGroup", relationTypeGroup.name());
        return (List)this.restTemplate.exchange(this.baseURL + "/api/relations?toId={toId}&toType={toType}&relationType={relationType}&relationTypeGroup={relationTypeGroup}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntityRelation>>(){}, params).getBody();
    }

    public List<EntityRelation> findByQuery(EntityRelationsQuery query) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/relations", HttpMethod.POST, new HttpEntity((Object)query), (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntityRelation>>(){}, new Object[0]).getBody();
    }

    public List<EntityRelationInfo> findInfoByQuery(EntityRelationsQuery query) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/relations/info", HttpMethod.POST, new HttpEntity((Object)query), (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntityRelationInfo>>(){}, new Object[0]).getBody();
    }

    @Deprecated
    public EntityRelation makeRelation(String relationType, EntityId idFrom, EntityId idTo) {
        EntityRelation relation = new EntityRelation();
        relation.setFrom(idFrom);
        relation.setTo(idTo);
        relation.setType(relationType);
        return (EntityRelation)this.restTemplate.postForEntity(this.baseURL + "/api/relation", (Object)relation, EntityRelation.class, new Object[0]).getBody();
    }

    public Optional<EntityView> getEntityViewById(EntityViewId entityViewId) {
        try {
            ResponseEntity entityView = this.restTemplate.getForEntity(this.baseURL + "/api/entityView/{entityViewId}", EntityView.class, new Object[]{entityViewId.getId()});
            return Optional.ofNullable((EntityView)entityView.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<EntityViewInfo> getEntityViewInfoById(EntityViewId entityViewId) {
        try {
            ResponseEntity entityView = this.restTemplate.getForEntity(this.baseURL + "/api/entityView/info/{entityViewId}", EntityViewInfo.class, new Object[]{entityViewId});
            return Optional.ofNullable((EntityViewInfo)entityView.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public EntityView saveEntityView(EntityView entityView) {
        return (EntityView)this.restTemplate.postForEntity(this.baseURL + "/api/entityView", (Object)entityView, EntityView.class, new Object[0]).getBody();
    }

    public void deleteEntityView(EntityViewId entityViewId) {
        this.restTemplate.delete(this.baseURL + "/api/entityView/{entityViewId}", new Object[]{entityViewId.getId()});
    }

    public Optional<EntityView> getTenantEntityView(String entityViewName) {
        try {
            ResponseEntity entityView = this.restTemplate.getForEntity(this.baseURL + "/api/tenant/entityViews?entityViewName={entityViewName}", EntityView.class, new Object[]{entityViewName});
            return Optional.ofNullable((EntityView)entityView.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<EntityView> assignEntityViewToCustomer(CustomerId customerId, EntityViewId entityViewId) {
        try {
            ResponseEntity entityView = this.restTemplate.postForEntity(this.baseURL + "/api/customer/{customerId}/entityView/{entityViewId}", null, EntityView.class, new Object[]{customerId.getId(), entityViewId.getId()});
            return Optional.ofNullable((EntityView)entityView.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<EntityView> unassignEntityViewFromCustomer(EntityViewId entityViewId) {
        try {
            ResponseEntity entityView = this.restTemplate.exchange(this.baseURL + "/api/customer/entityView/{entityViewId}", HttpMethod.DELETE, HttpEntity.EMPTY, EntityView.class, new Object[]{entityViewId.getId()});
            return Optional.ofNullable((EntityView)entityView.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<EntityView> getCustomerEntityViews(CustomerId customerId, String entityViewType, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerId", customerId.getId().toString());
        params.put("type", entityViewType);
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/customer/{customerId}/entityViews?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<EntityView>>(){}, params).getBody();
    }

    public PageData<EntityViewInfo> getCustomerEntityViewInfos(CustomerId customerId, String entityViewType, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerId", customerId.toString());
        params.put("type", entityViewType);
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/customer/{customerId}/entityViewInfos?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<EntityViewInfo>>(){}, params).getBody();
    }

    public PageData<EntityView> getTenantEntityViews(String entityViewType, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", entityViewType);
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenant/entityViews?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<EntityView>>(){}, params).getBody();
    }

    public PageData<EntityViewInfo> getTenantEntityViewInfos(String entityViewType, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", entityViewType);
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenant/entityViewInfos?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<EntityViewInfo>>(){}, params).getBody();
    }

    public List<EntityView> findByQuery(EntityViewSearchQuery query) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/entityViews", HttpMethod.POST, new HttpEntity((Object)query), (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntityView>>(){}, new Object[0]).getBody();
    }

    public List<EntitySubtype> getEntityViewTypes() {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/entityView/types", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntitySubtype>>(){}, new Object[0]).getBody();
    }

    public Optional<EntityView> assignEntityViewToPublicCustomer(EntityViewId entityViewId) {
        try {
            ResponseEntity entityView = this.restTemplate.postForEntity(this.baseURL + "/api/customer/public/entityView/{entityViewId}", null, EntityView.class, new Object[]{entityViewId.getId()});
            return Optional.ofNullable((EntityView)entityView.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<Event> getEvents(EntityId entityId, String eventType, TenantId tenantId, TimePageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("entityType", entityId.getEntityType().name());
        params.put("entityId", entityId.getId().toString());
        params.put("eventType", eventType);
        params.put("tenantId", tenantId.getId().toString());
        this.addTimePageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/events/{entityType}/{entityId}/{eventType}?tenantId={tenantId}&" + this.getTimeUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Event>>(){}, params).getBody();
    }

    public PageData<Event> getEvents(EntityId entityId, TenantId tenantId, TimePageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("entityType", entityId.getEntityType().name());
        params.put("entityId", entityId.getId().toString());
        params.put("tenantId", tenantId.getId().toString());
        this.addTimePageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/events/{entityType}/{entityId}?tenantId={tenantId}&" + this.getTimeUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Event>>(){}, params).getBody();
    }

    public OAuth2ClientRegistrationTemplate saveClientRegistrationTemplate(OAuth2ClientRegistrationTemplate clientRegistrationTemplate) {
        return (OAuth2ClientRegistrationTemplate)this.restTemplate.postForEntity(this.baseURL + "/api/oauth2/config/template", (Object)clientRegistrationTemplate, OAuth2ClientRegistrationTemplate.class, new Object[0]).getBody();
    }

    public void deleteClientRegistrationTemplate(OAuth2ClientRegistrationTemplateId oAuth2ClientRegistrationTemplateId) {
        this.restTemplate.delete(this.baseURL + "/api/oauth2/config/template/{clientRegistrationTemplateId}", new Object[]{oAuth2ClientRegistrationTemplateId});
    }

    public List<OAuth2ClientRegistrationTemplate> getClientRegistrationTemplates() {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/oauth2/config/template", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<OAuth2ClientRegistrationTemplate>>(){}, new Object[0]).getBody();
    }

    public List<OAuth2ClientInfo> getOAuth2Clients(String pkgName, PlatformType platformType) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder urlBuilder = new StringBuilder(this.baseURL);
        urlBuilder.append("/api/noauth/oauth2Clients");
        if (pkgName != null) {
            urlBuilder.append("?pkgName={pkgName}");
            params.put("pkgName", pkgName);
        }
        if (platformType != null) {
            if (pkgName != null) {
                urlBuilder.append("&");
            } else {
                urlBuilder.append("?");
            }
            urlBuilder.append("platform={platform}");
            params.put("platform", platformType.name());
        }
        return (List)this.restTemplate.exchange(urlBuilder.toString(), HttpMethod.POST, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<OAuth2ClientInfo>>(){}, params).getBody();
    }

    public OAuth2Info getCurrentOAuth2Info() {
        return (OAuth2Info)this.restTemplate.getForEntity(this.baseURL + "/api/oauth2/config", OAuth2Info.class, new Object[0]).getBody();
    }

    public OAuth2Info saveOAuth2Info(OAuth2Info oauth2Info) {
        return (OAuth2Info)this.restTemplate.postForEntity(this.baseURL + "/api/oauth2/config", (Object)oauth2Info, OAuth2Info.class, new Object[0]).getBody();
    }

    public String getLoginProcessingUrl() {
        return (String)this.restTemplate.getForEntity(this.baseURL + "/api/oauth2/loginProcessingUrl", String.class, new Object[0]).getBody();
    }

    public void handleOneWayDeviceRPCRequest(DeviceId deviceId, JsonNode requestBody) {
        this.restTemplate.postForLocation(this.baseURL + "/api/rpc/oneway/{deviceId}", (Object)requestBody, new Object[]{deviceId.getId()});
    }

    public JsonNode handleTwoWayDeviceRPCRequest(DeviceId deviceId, JsonNode requestBody) {
        return (JsonNode)this.restTemplate.exchange(this.baseURL + "/api/rpc/twoway/{deviceId}", HttpMethod.POST, new HttpEntity((Object)requestBody), (ParameterizedTypeReference)new ParameterizedTypeReference<JsonNode>(){}, new Object[]{deviceId.getId()}).getBody();
    }

    public Optional<RuleChain> getRuleChainById(RuleChainId ruleChainId) {
        try {
            ResponseEntity ruleChain = this.restTemplate.getForEntity(this.baseURL + "/api/ruleChain/{ruleChainId}", RuleChain.class, new Object[]{ruleChainId.getId()});
            return Optional.ofNullable((RuleChain)ruleChain.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<RuleChainMetaData> getRuleChainMetaData(RuleChainId ruleChainId) {
        try {
            ResponseEntity ruleChainMetaData = this.restTemplate.getForEntity(this.baseURL + "/api/ruleChain/{ruleChainId}/metadata", RuleChainMetaData.class, new Object[]{ruleChainId.getId()});
            return Optional.ofNullable((RuleChainMetaData)ruleChainMetaData.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public RuleChain saveRuleChain(RuleChain ruleChain) {
        return (RuleChain)this.restTemplate.postForEntity(this.baseURL + "/api/ruleChain", (Object)ruleChain, RuleChain.class, new Object[0]).getBody();
    }

    public RuleChain saveRuleChain(DefaultRuleChainCreateRequest request) {
        return (RuleChain)this.restTemplate.postForEntity(this.baseURL + "/api/ruleChain/device/default", (Object)request, RuleChain.class, new Object[0]).getBody();
    }

    public Optional<RuleChain> setRootRuleChain(RuleChainId ruleChainId) {
        try {
            ResponseEntity ruleChain = this.restTemplate.postForEntity(this.baseURL + "/api/ruleChain/{ruleChainId}/root", null, RuleChain.class, new Object[]{ruleChainId.getId()});
            return Optional.ofNullable((RuleChain)ruleChain.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public RuleChainMetaData saveRuleChainMetaData(RuleChainMetaData ruleChainMetaData) {
        return (RuleChainMetaData)this.restTemplate.postForEntity(this.baseURL + "/api/ruleChain/metadata", (Object)ruleChainMetaData, RuleChainMetaData.class, new Object[0]).getBody();
    }

    public PageData<RuleChain> getRuleChains(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/ruleChains?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<RuleChain>>(){}, params).getBody();
    }

    public void deleteRuleChain(RuleChainId ruleChainId) {
        this.restTemplate.delete(this.baseURL + "/api/ruleChain/{ruleChainId}", new Object[]{ruleChainId.getId()});
    }

    public Optional<JsonNode> getLatestRuleNodeDebugInput(RuleNodeId ruleNodeId) {
        try {
            ResponseEntity jsonNode = this.restTemplate.getForEntity(this.baseURL + "/api/ruleNode/{ruleNodeId}/debugIn", JsonNode.class, new Object[]{ruleNodeId.getId()});
            return Optional.ofNullable((JsonNode)jsonNode.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<JsonNode> testScript(JsonNode inputParams) {
        try {
            ResponseEntity jsonNode = this.restTemplate.postForEntity(this.baseURL + "/api/ruleChain/testScript", (Object)inputParams, JsonNode.class, new Object[0]);
            return Optional.ofNullable((JsonNode)jsonNode.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public RuleChainData exportRuleChains(int limit) {
        return (RuleChainData)this.restTemplate.getForEntity(this.baseURL + "/api/ruleChains/export?limit=" + limit, RuleChainData.class, new Object[0]).getBody();
    }

    public void importRuleChains(RuleChainData ruleChainData, boolean overwrite) {
        this.restTemplate.postForLocation(this.baseURL + "/api/ruleChains/import?overwrite=" + overwrite, (Object)ruleChainData, new Object[0]);
    }

    public List<String> getAttributeKeys(EntityId entityId) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/keys/attributes", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<String>>(){}, new Object[]{entityId.getEntityType().name(), entityId.getId().toString()}).getBody();
    }

    public List<String> getAttributeKeysByScope(EntityId entityId, String scope) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/keys/attributes/{scope}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<String>>(){}, new Object[]{entityId.getEntityType().name(), entityId.getId().toString(), scope}).getBody();
    }

    public List<AttributeKvEntry> getAttributeKvEntries(EntityId entityId, List<String> keys) {
        List attributes = (List)this.restTemplate.exchange(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/values/attributes?keys={keys}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<JsonNode>>(){}, new Object[]{entityId.getEntityType().name(), entityId.getId(), this.listToString(keys)}).getBody();
        return RestJsonConverter.toAttributes(attributes);
    }

    public Future<List<AttributeKvEntry>> getAttributeKvEntriesAsync(EntityId entityId, List<String> keys) {
        return this.service.submit(() -> this.getAttributeKvEntries(entityId, keys));
    }

    public List<AttributeKvEntry> getAttributesByScope(EntityId entityId, String scope, List<String> keys) {
        List attributes = (List)this.restTemplate.exchange(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/values/attributes/{scope}?keys={keys}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<JsonNode>>(){}, new Object[]{entityId.getEntityType().name(), entityId.getId().toString(), scope, this.listToString(keys)}).getBody();
        return RestJsonConverter.toAttributes(attributes);
    }

    public List<String> getTimeseriesKeys(EntityId entityId) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/keys/timeseries", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<String>>(){}, new Object[]{entityId.getEntityType().name(), entityId.getId().toString()}).getBody();
    }

    public List<TsKvEntry> getLatestTimeseries(EntityId entityId, List<String> keys) {
        return this.getLatestTimeseries(entityId, keys, true);
    }

    public List<TsKvEntry> getLatestTimeseries(EntityId entityId, List<String> keys, boolean useStrictDataTypes) {
        Map timeseries = (Map)this.restTemplate.exchange(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/values/timeseries?keys={keys}&useStrictDataTypes={useStrictDataTypes}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, List<JsonNode>>>(){}, new Object[]{entityId.getEntityType().name(), entityId.getId().toString(), this.listToString(keys), useStrictDataTypes}).getBody();
        return RestJsonConverter.toTimeseries(timeseries);
    }

    @Deprecated
    public List<TsKvEntry> getTimeseries(EntityId entityId, List<String> keys, Long interval, Aggregation agg, TimePageLink pageLink) {
        return this.getTimeseries(entityId, keys, interval, agg, pageLink, true);
    }

    @Deprecated
    public List<TsKvEntry> getTimeseries(EntityId entityId, List<String> keys, Long interval, Aggregation agg, TimePageLink pageLink, boolean useStrictDataTypes) {
        SortOrder sortOrder = pageLink.getSortOrder();
        return this.getTimeseries(entityId, keys, interval, agg, sortOrder != null ? sortOrder.getDirection() : null, pageLink.getStartTime(), pageLink.getEndTime(), 100, useStrictDataTypes);
    }

    public List<TsKvEntry> getTimeseries(EntityId entityId, List<String> keys, Long interval, Aggregation agg, SortOrder.Direction sortOrder, Long startTime, Long endTime, Integer limit, boolean useStrictDataTypes) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("entityType", entityId.getEntityType().name());
        params.put("entityId", entityId.getId().toString());
        params.put("keys", this.listToString(keys));
        params.put("interval", interval == null ? "0" : interval.toString());
        params.put("agg", agg == null ? "NONE" : agg.name());
        params.put("limit", limit != null ? limit.toString() : "100");
        params.put("orderBy", sortOrder != null ? sortOrder.name() : "DESC");
        params.put("useStrictDataTypes", Boolean.toString(useStrictDataTypes));
        StringBuilder urlBuilder = new StringBuilder(this.baseURL);
        urlBuilder.append("/api/plugins/telemetry/{entityType}/{entityId}/values/timeseries?keys={keys}&interval={interval}&limit={limit}&agg={agg}&useStrictDataTypes={useStrictDataTypes}&orderBy={orderBy}");
        if (startTime != null) {
            urlBuilder.append("&startTs={startTs}");
            params.put("startTs", String.valueOf(startTime));
        }
        if (endTime != null) {
            urlBuilder.append("&endTs={endTs}");
            params.put("endTs", String.valueOf(endTime));
        }
        Map timeseries = (Map)this.restTemplate.exchange(urlBuilder.toString(), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, List<JsonNode>>>(){}, params).getBody();
        return RestJsonConverter.toTimeseries(timeseries);
    }

    public boolean saveDeviceAttributes(DeviceId deviceId, String scope, JsonNode request) {
        return this.restTemplate.postForEntity(this.baseURL + "/api/plugins/telemetry/{deviceId}/{scope}", (Object)request, Object.class, new Object[]{deviceId.getId().toString(), scope}).getStatusCode().is2xxSuccessful();
    }

    public boolean saveEntityAttributesV1(EntityId entityId, String scope, JsonNode request) {
        return this.restTemplate.postForEntity(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/{scope}", (Object)request, Object.class, new Object[]{entityId.getEntityType().name(), entityId.getId().toString(), scope}).getStatusCode().is2xxSuccessful();
    }

    public boolean saveEntityAttributesV2(EntityId entityId, String scope, JsonNode request) {
        return this.restTemplate.postForEntity(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/attributes/{scope}", (Object)request, Object.class, new Object[]{entityId.getEntityType().name(), entityId.getId().toString(), scope}).getStatusCode().is2xxSuccessful();
    }

    public boolean saveEntityTelemetry(EntityId entityId, String scope, JsonNode request) {
        return this.restTemplate.postForEntity(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/timeseries/{scope}", (Object)request, Object.class, new Object[]{entityId.getEntityType().name(), entityId.getId().toString(), scope}).getStatusCode().is2xxSuccessful();
    }

    public boolean saveEntityTelemetryWithTTL(EntityId entityId, String scope, Long ttl, JsonNode request) {
        return this.restTemplate.postForEntity(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/timeseries/{scope}/{ttl}", (Object)request, Object.class, new Object[]{entityId.getEntityType().name(), entityId.getId().toString(), scope, ttl}).getStatusCode().is2xxSuccessful();
    }

    public boolean deleteEntityTimeseries(EntityId entityId, List<String> keys, boolean deleteAllDataForKeys, Long startTs, Long endTs, boolean rewriteLatestIfDeleted) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("entityType", entityId.getEntityType().name());
        params.put("entityId", entityId.getId().toString());
        params.put("keys", this.listToString(keys));
        params.put("deleteAllDataForKeys", String.valueOf(deleteAllDataForKeys));
        params.put("startTs", startTs.toString());
        params.put("endTs", endTs.toString());
        params.put("rewriteLatestIfDeleted", String.valueOf(rewriteLatestIfDeleted));
        return this.restTemplate.exchange(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/timeseries/delete?keys={keys}&deleteAllDataForKeys={deleteAllDataForKeys}&startTs={startTs}&endTs={endTs}&rewriteLatestIfDeleted={rewriteLatestIfDeleted}", HttpMethod.DELETE, HttpEntity.EMPTY, Object.class, params).getStatusCode().is2xxSuccessful();
    }

    public boolean deleteEntityAttributes(DeviceId deviceId, String scope, List<String> keys) {
        return this.restTemplate.exchange(this.baseURL + "/api/plugins/telemetry/{deviceId}/{scope}?keys={keys}", HttpMethod.DELETE, HttpEntity.EMPTY, Object.class, new Object[]{deviceId.getId().toString(), scope, this.listToString(keys)}).getStatusCode().is2xxSuccessful();
    }

    public boolean deleteEntityAttributes(EntityId entityId, String scope, List<String> keys) {
        return this.restTemplate.exchange(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/{scope}?keys={keys}", HttpMethod.DELETE, HttpEntity.EMPTY, Object.class, new Object[]{entityId.getEntityType().name(), entityId.getId().toString(), scope, this.listToString(keys)}).getStatusCode().is2xxSuccessful();
    }

    public Optional<Tenant> getTenantById(TenantId tenantId) {
        try {
            ResponseEntity tenant = this.restTemplate.getForEntity(this.baseURL + "/api/tenant/{tenantId}", Tenant.class, new Object[]{tenantId.getId()});
            return Optional.ofNullable((Tenant)tenant.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<TenantInfo> getTenantInfoById(TenantId tenantId) {
        try {
            ResponseEntity tenant = this.restTemplate.getForEntity(this.baseURL + "/api/tenant/info/{tenantId}", TenantInfo.class, new Object[]{tenantId});
            return Optional.ofNullable((TenantInfo)tenant.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Tenant saveTenant(Tenant tenant) {
        return (Tenant)this.restTemplate.postForEntity(this.baseURL + "/api/tenant", (Object)tenant, Tenant.class, new Object[0]).getBody();
    }

    public void deleteTenant(TenantId tenantId) {
        this.restTemplate.delete(this.baseURL + "/api/tenant/{tenantId}", new Object[]{tenantId.getId()});
    }

    public PageData<Tenant> getTenants(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenants?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Tenant>>(){}, params).getBody();
    }

    public PageData<TenantInfo> getTenantInfos(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenantInfos?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<TenantInfo>>(){}, params).getBody();
    }

    public Optional<TenantProfile> getTenantProfileById(TenantProfileId tenantProfileId) {
        try {
            ResponseEntity tenantProfile = this.restTemplate.getForEntity(this.baseURL + "/api/tenantProfile/{tenantProfileId}", TenantProfile.class, new Object[]{tenantProfileId});
            return Optional.ofNullable((TenantProfile)tenantProfile.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<EntityInfo> getTenantProfileInfoById(TenantProfileId tenantProfileId) {
        try {
            ResponseEntity entityInfo = this.restTemplate.getForEntity(this.baseURL + "/api/tenantProfileInfo/{tenantProfileId}", EntityInfo.class, new Object[]{tenantProfileId});
            return Optional.ofNullable((EntityInfo)entityInfo.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public EntityInfo getDefaultTenantProfileInfo() {
        return (EntityInfo)this.restTemplate.getForEntity(this.baseURL + "/api/tenantProfileInfo/default", EntityInfo.class, new Object[0]).getBody();
    }

    public TenantProfile saveTenantProfile(TenantProfile tenantProfile) {
        return (TenantProfile)this.restTemplate.postForEntity(this.baseURL + "/api/tenantProfile", (Object)tenantProfile, TenantProfile.class, new Object[0]).getBody();
    }

    public void deleteTenantProfile(TenantProfileId tenantProfileId) {
        this.restTemplate.delete(this.baseURL + "/api/tenantProfile/{tenantProfileId}", new Object[]{tenantProfileId});
    }

    public TenantProfile setDefaultTenantProfile(TenantProfileId tenantProfileId) {
        return (TenantProfile)this.restTemplate.exchange(this.baseURL + "/api/tenantProfile/{tenantProfileId}/default", HttpMethod.POST, HttpEntity.EMPTY, TenantProfile.class, new Object[]{tenantProfileId}).getBody();
    }

    public PageData<TenantProfile> getTenantProfiles(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenantProfiles?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<TenantProfile>>(){}, params).getBody();
    }

    public PageData<EntityInfo> getTenantProfileInfos(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenantProfileInfos?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<EntityInfo>>(){}, params).getBody();
    }

    public Optional<User> getUserById(UserId userId) {
        try {
            ResponseEntity user = this.restTemplate.getForEntity(this.baseURL + "/api/user/{userId}", User.class, new Object[]{userId.getId()});
            return Optional.ofNullable((User)user.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Boolean isUserTokenAccessEnabled() {
        return (Boolean)this.restTemplate.getForEntity(this.baseURL + "/api/user/tokenAccessEnabled", Boolean.class, new Object[0]).getBody();
    }

    public Optional<JsonNode> getUserToken(UserId userId) {
        try {
            ResponseEntity userToken = this.restTemplate.getForEntity(this.baseURL + "/api/user/{userId}/token", JsonNode.class, new Object[]{userId.getId()});
            return Optional.ofNullable((JsonNode)userToken.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public User saveUser(User user, boolean sendActivationMail) {
        return (User)this.restTemplate.postForEntity(this.baseURL + "/api/user?sendActivationMail={sendActivationMail}", (Object)user, User.class, new Object[]{sendActivationMail}).getBody();
    }

    public void sendActivationEmail(String email) {
        this.restTemplate.postForLocation(this.baseURL + "/api/user/sendActivationMail?email={email}", null, new Object[]{email});
    }

    public String getActivationLink(UserId userId) {
        return (String)this.restTemplate.getForEntity(this.baseURL + "/api/user/{userId}/activationLink", String.class, new Object[]{userId.getId()}).getBody();
    }

    public void deleteUser(UserId userId) {
        this.restTemplate.delete(this.baseURL + "/api/user/{userId}", new Object[]{userId.getId()});
    }

    public PageData<User> getUsers(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/users?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<User>>(){}, params).getBody();
    }

    public PageData<User> getTenantAdmins(TenantId tenantId, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId.getId().toString());
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenant/{tenantId}/users?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<User>>(){}, params).getBody();
    }

    public PageData<User> getCustomerUsers(CustomerId customerId, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerId", customerId.getId().toString());
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/customer/{customerId}/users?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<User>>(){}, params).getBody();
    }

    public void setUserCredentialsEnabled(UserId userId, boolean userCredentialsEnabled) {
        this.restTemplate.postForLocation(this.baseURL + "/api/user/{userId}/userCredentialsEnabled?userCredentialsEnabled={userCredentialsEnabled}", null, new Object[]{userId.getId(), userCredentialsEnabled});
    }

    public Optional<WidgetsBundle> getWidgetsBundleById(WidgetsBundleId widgetsBundleId) {
        try {
            ResponseEntity widgetsBundle = this.restTemplate.getForEntity(this.baseURL + "/api/widgetsBundle/{widgetsBundleId}", WidgetsBundle.class, new Object[]{widgetsBundleId.getId()});
            return Optional.ofNullable((WidgetsBundle)widgetsBundle.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public WidgetsBundle saveWidgetsBundle(WidgetsBundle widgetsBundle) {
        return (WidgetsBundle)this.restTemplate.postForEntity(this.baseURL + "/api/widgetsBundle", (Object)widgetsBundle, WidgetsBundle.class, new Object[0]).getBody();
    }

    public void deleteWidgetsBundle(WidgetsBundleId widgetsBundleId) {
        this.restTemplate.delete(this.baseURL + "/api/widgetsBundle/{widgetsBundleId}", new Object[]{widgetsBundleId.getId()});
    }

    public PageData<WidgetsBundle> getWidgetsBundles(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/widgetsBundles?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<WidgetsBundle>>(){}, params).getBody();
    }

    public List<WidgetsBundle> getWidgetsBundles() {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/widgetsBundles", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<WidgetsBundle>>(){}, new Object[0]).getBody();
    }

    public Optional<WidgetType> getWidgetTypeById(WidgetTypeId widgetTypeId) {
        try {
            ResponseEntity widgetType = this.restTemplate.getForEntity(this.baseURL + "/api/widgetType/{widgetTypeId}", WidgetType.class, new Object[]{widgetTypeId.getId()});
            return Optional.ofNullable((WidgetType)widgetType.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public WidgetType saveWidgetType(WidgetType widgetType) {
        return (WidgetType)this.restTemplate.postForEntity(this.baseURL + "/api/widgetType", (Object)widgetType, WidgetType.class, new Object[0]).getBody();
    }

    public void deleteWidgetType(WidgetTypeId widgetTypeId) {
        this.restTemplate.delete(this.baseURL + "/api/widgetType/{widgetTypeId}", new Object[]{widgetTypeId.getId()});
    }

    public List<WidgetType> getBundleWidgetTypes(boolean isSystem, String bundleAlias) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/widgetTypes?isSystem={isSystem}&bundleAlias={bundleAlias}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<WidgetType>>(){}, new Object[]{isSystem, bundleAlias}).getBody();
    }

    public Optional<WidgetType> getWidgetType(boolean isSystem, String bundleAlias, String alias) {
        try {
            ResponseEntity widgetType = this.restTemplate.getForEntity(this.baseURL + "/api/widgetType?isSystem={isSystem}&bundleAlias={bundleAlias}&alias={alias}", WidgetType.class, new Object[]{isSystem, bundleAlias, alias});
            return Optional.ofNullable((WidgetType)widgetType.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Edge saveEdge(Edge edge) {
        return (Edge)this.restTemplate.postForEntity(this.baseURL + "/api/edge", (Object)edge, Edge.class, new Object[0]).getBody();
    }

    public void deleteEdge(EdgeId edgeId) {
        this.restTemplate.delete(this.baseURL + "/api/edge/{edgeId}", new Object[]{edgeId.getId()});
    }

    public Optional<Edge> getEdgeById(EdgeId edgeId) {
        try {
            ResponseEntity edge = this.restTemplate.getForEntity(this.baseURL + "/api/edge/{edgeId}", Edge.class, new Object[]{edgeId.getId()});
            return Optional.ofNullable((Edge)edge.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Edge> assignEdgeToCustomer(CustomerId customerId, EdgeId edgeId) {
        try {
            ResponseEntity edge = this.restTemplate.postForEntity(this.baseURL + "/api/customer/{customerId}/edge/{edgeId}", null, Edge.class, new Object[]{customerId.getId(), edgeId.getId()});
            return Optional.ofNullable((Edge)edge.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Edge> assignEdgeToPublicCustomer(EdgeId edgeId) {
        try {
            ResponseEntity edge = this.restTemplate.postForEntity(this.baseURL + "/api/customer/public/edge/{edgeId}", null, Edge.class, new Object[]{edgeId.getId()});
            return Optional.ofNullable((Edge)edge.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Edge> setRootRuleChain(EdgeId edgeId, RuleChainId ruleChainId) {
        try {
            ResponseEntity ruleChain = this.restTemplate.postForEntity(this.baseURL + "/api/edge/{edgeId}/{ruleChainId}/root", null, Edge.class, new Object[]{edgeId.getId(), ruleChainId.getId()});
            return Optional.ofNullable((Edge)ruleChain.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<Edge> getEdges(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/edges?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Edge>>(){}, params).getBody();
    }

    public Optional<Edge> unassignEdgeFromCustomer(EdgeId edgeId) {
        try {
            ResponseEntity edge = this.restTemplate.exchange(this.baseURL + "/api/customer/edge/{edgeId}", HttpMethod.DELETE, HttpEntity.EMPTY, Edge.class, new Object[]{edgeId.getId()});
            return Optional.ofNullable((Edge)edge.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Device> assignDeviceToEdge(EdgeId edgeId, DeviceId deviceId) {
        try {
            ResponseEntity device = this.restTemplate.postForEntity(this.baseURL + "/api/edge/{edgeId}/device/{deviceId}", null, Device.class, new Object[]{edgeId.getId(), deviceId.getId()});
            return Optional.ofNullable((Device)device.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Device> unassignDeviceFromEdge(EdgeId edgeId, DeviceId deviceId) {
        try {
            ResponseEntity device = this.restTemplate.exchange(this.baseURL + "/api/edge/{edgeId}/device/{deviceId}", HttpMethod.DELETE, HttpEntity.EMPTY, Device.class, new Object[]{edgeId.getId(), deviceId.getId()});
            return Optional.ofNullable((Device)device.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<Device> getEdgeDevices(EdgeId edgeId, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("edgeId", edgeId.getId().toString());
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/edge/{edgeId}/devices?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Device>>(){}, params).getBody();
    }

    public Optional<Asset> assignAssetToEdge(EdgeId edgeId, AssetId assetId) {
        try {
            ResponseEntity asset = this.restTemplate.postForEntity(this.baseURL + "/api/edge/{edgeId}/asset/{assetId}", null, Asset.class, new Object[]{edgeId.getId(), assetId.getId()});
            return Optional.ofNullable((Asset)asset.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Asset> unassignAssetFromEdge(EdgeId edgeId, AssetId assetId) {
        try {
            ResponseEntity asset = this.restTemplate.exchange(this.baseURL + "/api/edge/{edgeId}/asset/{assetId}", HttpMethod.DELETE, HttpEntity.EMPTY, Asset.class, new Object[]{edgeId.getId(), assetId.getId()});
            return Optional.ofNullable((Asset)asset.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<Asset> getEdgeAssets(EdgeId edgeId, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("edgeId", edgeId.getId().toString());
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/edge/{edgeId}/assets?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Asset>>(){}, params).getBody();
    }

    public Optional<Dashboard> assignDashboardToEdge(EdgeId edgeId, DashboardId dashboardId) {
        try {
            ResponseEntity dashboard = this.restTemplate.postForEntity(this.baseURL + "/api/edge/{edgeId}/dashboard/{dashboardId}", null, Dashboard.class, new Object[]{edgeId.getId(), dashboardId.getId()});
            return Optional.ofNullable((Dashboard)dashboard.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<Dashboard> unassignDashboardFromEdge(EdgeId edgeId, DashboardId dashboardId) {
        try {
            ResponseEntity dashboard = this.restTemplate.exchange(this.baseURL + "/api/edge/{edgeId}/dashboard/{dashboardId}", HttpMethod.DELETE, HttpEntity.EMPTY, Dashboard.class, new Object[]{edgeId.getId(), dashboardId.getId()});
            return Optional.ofNullable((Dashboard)dashboard.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<DashboardInfo> getEdgeDashboards(EdgeId edgeId, TimePageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("edgeId", edgeId.getId().toString());
        this.addPageLinkToParam(params, (PageLink)pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/edge/{edgeId}/dashboards?" + this.getUrlParams((PageLink)pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<DashboardInfo>>(){}, params).getBody();
    }

    public Optional<EntityView> assignEntityViewToEdge(EdgeId edgeId, EntityViewId entityViewId) {
        try {
            ResponseEntity entityView = this.restTemplate.postForEntity(this.baseURL + "/api/edge/{edgeId}/entityView/{entityViewId}", null, EntityView.class, new Object[]{edgeId.getId(), entityViewId.getId()});
            return Optional.ofNullable((EntityView)entityView.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<EntityView> unassignEntityViewFromEdge(EdgeId edgeId, EntityViewId entityViewId) {
        try {
            ResponseEntity entityView = this.restTemplate.exchange(this.baseURL + "/api/edge/{edgeId}/entityView/{entityViewId}", HttpMethod.DELETE, HttpEntity.EMPTY, EntityView.class, new Object[]{edgeId.getId(), entityViewId.getId()});
            return Optional.ofNullable((EntityView)entityView.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<EntityView> getEdgeEntityViews(EdgeId edgeId, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("edgeId", edgeId.getId().toString());
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/edge/{edgeId}/entityViews?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<EntityView>>(){}, params).getBody();
    }

    public Optional<RuleChain> assignRuleChainToEdge(EdgeId edgeId, RuleChainId ruleChainId) {
        try {
            ResponseEntity ruleChain = this.restTemplate.postForEntity(this.baseURL + "/api/edge/{edgeId}/ruleChain/{ruleChainId}", null, RuleChain.class, new Object[]{edgeId.getId(), ruleChainId.getId()});
            return Optional.ofNullable((RuleChain)ruleChain.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<RuleChain> unassignRuleChainFromEdge(EdgeId edgeId, RuleChainId ruleChainId) {
        try {
            ResponseEntity ruleChain = this.restTemplate.exchange(this.baseURL + "/api/edge/{edgeId}/ruleChain/{ruleChainId}", HttpMethod.DELETE, HttpEntity.EMPTY, RuleChain.class, new Object[]{edgeId.getId(), ruleChainId.getId()});
            return Optional.ofNullable((RuleChain)ruleChain.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<RuleChain> getEdgeRuleChains(EdgeId edgeId, TimePageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("edgeId", edgeId.getId().toString());
        this.addPageLinkToParam(params, (PageLink)pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/edge/{edgeId}/ruleChains?" + this.getUrlParams((PageLink)pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<RuleChain>>(){}, params).getBody();
    }

    public Optional<RuleChain> setAutoAssignToEdgeRuleChain(RuleChainId ruleChainId) {
        try {
            ResponseEntity ruleChain = this.restTemplate.postForEntity(this.baseURL + "/api/ruleChain/{ruleChainId}/autoAssignToEdge", null, RuleChain.class, new Object[]{ruleChainId.getId()});
            return Optional.ofNullable((RuleChain)ruleChain.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public Optional<RuleChain> unsetAutoAssignToEdgeRuleChain(RuleChainId ruleChainId) {
        try {
            ResponseEntity ruleChain = this.restTemplate.exchange(this.baseURL + "/api/ruleChain/{ruleChainId}/autoAssignToEdge", HttpMethod.DELETE, HttpEntity.EMPTY, RuleChain.class, new Object[]{ruleChainId.getId()});
            return Optional.ofNullable((RuleChain)ruleChain.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public List<RuleChain> getAutoAssignToEdgeRuleChains() {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/ruleChain/autoAssignToEdgeRuleChains", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<RuleChain>>(){}, new Object[0]).getBody();
    }

    public Optional<RuleChain> setRootEdgeTemplateRuleChain(RuleChainId ruleChainId) {
        try {
            ResponseEntity ruleChain = this.restTemplate.postForEntity(this.baseURL + "/api/ruleChain/{ruleChainId}/edgeTemplateRoot", null, RuleChain.class, new Object[]{ruleChainId.getId()});
            return Optional.ofNullable((RuleChain)ruleChain.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<Edge> getTenantEdges(String type, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", type);
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/tenant/edges?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Edge>>(){}, params).getBody();
    }

    public Optional<Edge> getTenantEdge(String edgeName) {
        try {
            ResponseEntity edge = this.restTemplate.getForEntity(this.baseURL + "/api/tenant/edges?edgeName={edgeName}", Edge.class, new Object[]{edgeName});
            return Optional.ofNullable((Edge)edge.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public PageData<Edge> getCustomerEdges(CustomerId customerId, PageLink pageLink, String edgeType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerId", customerId.getId().toString());
        params.put("type", edgeType);
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/customer/{customerId}/edges?type={type}&" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<Edge>>(){}, params).getBody();
    }

    public List<Edge> getEdgesByIds(List<EdgeId> edgeIds) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/edges?edgeIds={edgeIds}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Edge>>(){}, new Object[]{this.listIdsToString(edgeIds)}).getBody();
    }

    public List<Edge> findByQuery(EdgeSearchQuery query) {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/edges", HttpMethod.POST, new HttpEntity((Object)query), (ParameterizedTypeReference)new ParameterizedTypeReference<List<Edge>>(){}, new Object[0]).getBody();
    }

    public List<EntitySubtype> getEdgeTypes() {
        return (List)this.restTemplate.exchange(this.baseURL + "/api/edge/types", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<List<EntitySubtype>>(){}, new Object[0]).getBody();
    }

    public PageData<EdgeEvent> getEdgeEvents(EdgeId edgeId, TimePageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("edgeId", edgeId.toString());
        this.addPageLinkToParam(params, (PageLink)pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/edge/{edgeId}/events?" + this.getUrlParams((PageLink)pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<EdgeEvent>>(){}, params).getBody();
    }

    public void syncEdge(EdgeId edgeId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("edgeId", edgeId.toString());
        this.restTemplate.postForEntity(this.baseURL + "/api/edge/sync/{edgeId}", null, EdgeId.class, params);
    }

    public ResponseEntity<Resource> downloadResource(TbResourceId resourceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resourceId", resourceId.getId().toString());
        return this.restTemplate.exchange(this.baseURL + "/api/resource/{resourceId}/download", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<Resource>(){}, params);
    }

    public TbResourceInfo getResourceInfoById(TbResourceId resourceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resourceId", resourceId.getId().toString());
        return (TbResourceInfo)this.restTemplate.exchange(this.baseURL + "/api/resource/info/{resourceId}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<TbResourceInfo>(){}, params).getBody();
    }

    public TbResource getResourceId(TbResourceId resourceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resourceId", resourceId.getId().toString());
        return (TbResource)this.restTemplate.exchange(this.baseURL + "/api/resource/{resourceId}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<TbResource>(){}, params).getBody();
    }

    public TbResource saveResource(TbResource resource) {
        return (TbResource)this.restTemplate.postForEntity(this.baseURL + "/api/resource", (Object)resource, TbResource.class, new Object[0]).getBody();
    }

    public PageData<TbResourceInfo> getResources(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/resource?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<TbResourceInfo>>(){}, params).getBody();
    }

    public void deleteResource(TbResourceId resourceId) {
        this.restTemplate.delete("/api/resource/{resourceId}", new Object[]{resourceId.getId().toString()});
    }

    public ResponseEntity<Resource> downloadOtaPackage(OtaPackageId otaPackageId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("otaPackageId", otaPackageId.getId().toString());
        return this.restTemplate.exchange(this.baseURL + "/api/otaPackage/{otaPackageId}/download", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<Resource>(){}, params);
    }

    public OtaPackageInfo getOtaPackageInfoById(OtaPackageId otaPackageId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("otaPackageId", otaPackageId.getId().toString());
        return (OtaPackageInfo)this.restTemplate.exchange(this.baseURL + "/api/otaPackage/info/{otaPackageId}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<OtaPackageInfo>(){}, params).getBody();
    }

    public OtaPackage getOtaPackageById(OtaPackageId otaPackageId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("otaPackageId", otaPackageId.getId().toString());
        return (OtaPackage)this.restTemplate.exchange(this.baseURL + "/api/otaPackage/{otaPackageId}", HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<OtaPackage>(){}, params).getBody();
    }

    public OtaPackageInfo saveOtaPackageInfo(OtaPackageInfo otaPackageInfo, boolean isUrl) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("isUrl", Boolean.toString(isUrl));
        return (OtaPackageInfo)this.restTemplate.postForEntity(this.baseURL + "/api/otaPackage?isUrl={isUrl}", (Object)otaPackageInfo, OtaPackageInfo.class, params).getBody();
    }

    public OtaPackageInfo saveOtaPackageData(OtaPackageId otaPackageId, String checkSum, ChecksumAlgorithm checksumAlgorithm, MultipartFile file) throws Exception {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap fileMap = new LinkedMultiValueMap();
        fileMap.add((Object)"Content-Disposition", (Object)("form-data; name=file; filename=" + file.getName()));
        HttpEntity fileEntity = new HttpEntity((Object)new ByteArrayResource(file.getBytes()), (MultiValueMap)fileMap);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"file", (Object)fileEntity);
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)header);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("otaPackageId", otaPackageId.getId().toString());
        params.put("checksumAlgorithm", checksumAlgorithm.name());
        Object url = "/api/otaPackage/{otaPackageId}?checksumAlgorithm={checksumAlgorithm}";
        if (checkSum != null) {
            url = (String)url + "&checkSum={checkSum}";
        }
        return (OtaPackageInfo)this.restTemplate.postForEntity(this.baseURL + (String)url, (Object)requestEntity, OtaPackageInfo.class, params).getBody();
    }

    public PageData<OtaPackageInfo> getOtaPackages(PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/otaPackages?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<OtaPackageInfo>>(){}, params).getBody();
    }

    public PageData<OtaPackageInfo> getOtaPackages(DeviceProfileId deviceProfileId, OtaPackageType otaPackageType, boolean hasData, PageLink pageLink) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hasData", String.valueOf(hasData));
        params.put("deviceProfileId", deviceProfileId.getId().toString());
        params.put("type", otaPackageType.name());
        this.addPageLinkToParam(params, pageLink);
        return (PageData)this.restTemplate.exchange(this.baseURL + "/api/otaPackages/{deviceProfileId}/{type}/{hasData}?" + this.getUrlParams(pageLink), HttpMethod.GET, HttpEntity.EMPTY, (ParameterizedTypeReference)new ParameterizedTypeReference<PageData<OtaPackageInfo>>(){}, params).getBody();
    }

    public void deleteOtaPackage(OtaPackageId otaPackageId) {
        this.restTemplate.delete(this.baseURL + "/api/otaPackage/{otaPackageId}", new Object[]{otaPackageId.getId().toString()});
    }

    @Deprecated
    public Optional<JsonNode> getAttributes(String accessToken, String clientKeys, String sharedKeys) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accessToken", accessToken);
        params.put("clientKeys", clientKeys);
        params.put("sharedKeys", sharedKeys);
        try {
            ResponseEntity telemetryEntity = this.restTemplate.getForEntity(this.baseURL + "/api/v1/{accessToken}/attributes?clientKeys={clientKeys}&sharedKeys={sharedKeys}", JsonNode.class, params);
            return Optional.of((JsonNode)telemetryEntity.getBody());
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    private String getTimeUrlParams(TimePageLink pageLink) {
        Object urlParams = this.getUrlParams((PageLink)pageLink);
        if (pageLink.getStartTime() != null) {
            urlParams = (String)urlParams + "&startTime={startTime}";
        }
        if (pageLink.getEndTime() != null) {
            urlParams = (String)urlParams + "&endTime={endTime}";
        }
        return urlParams;
    }

    private String getUrlParams(PageLink pageLink) {
        Object urlParams = "pageSize={pageSize}&page={page}";
        if (!StringUtils.isEmpty((Object)pageLink.getTextSearch())) {
            urlParams = (String)urlParams + "&textSearch={textSearch}";
        }
        if (pageLink.getSortOrder() != null) {
            urlParams = (String)urlParams + "&sortProperty={sortProperty}&sortOrder={sortOrder}";
        }
        return urlParams;
    }

    private void addTimePageLinkToParam(Map<String, String> params, TimePageLink pageLink) {
        this.addPageLinkToParam(params, (PageLink)pageLink);
        if (pageLink.getStartTime() != null) {
            params.put("startTime", String.valueOf(pageLink.getStartTime()));
        }
        if (pageLink.getEndTime() != null) {
            params.put("endTime", String.valueOf(pageLink.getEndTime()));
        }
    }

    private void addPageLinkToParam(Map<String, String> params, PageLink pageLink) {
        params.put("pageSize", String.valueOf(pageLink.getPageSize()));
        params.put("page", String.valueOf(pageLink.getPage()));
        if (!StringUtils.isEmpty((Object)pageLink.getTextSearch())) {
            params.put("textSearch", pageLink.getTextSearch());
        }
        if (pageLink.getSortOrder() != null) {
            params.put("sortProperty", pageLink.getSortOrder().getProperty());
            params.put("sortOrder", pageLink.getSortOrder().getDirection().name());
        }
    }

    private String listToString(List<String> list) {
        return String.join((CharSequence)",", list);
    }

    private String listIdsToString(List<? extends EntityId> list) {
        return this.listToString(list.stream().map(id -> id.getId().toString()).collect(Collectors.toList()));
    }

    private String listEnumToString(List<? extends Enum> list) {
        return this.listToString(list.stream().map(Enum::name).collect(Collectors.toList()));
    }

    @Override
    public void close() {
        if (this.service != null) {
            this.service.shutdown();
        }
    }
}

