/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileData;
import org.thingsboard.server.common.data.validation.NoXss;

public class TenantProfile
extends SearchTextBased<TenantProfileId>
implements HasName {
    private static final Logger log = LoggerFactory.getLogger(TenantProfile.class);
    @NoXss
    private String name;
    @NoXss
    private String description;
    private boolean isDefault;
    private boolean isolatedTbCore;
    private boolean isolatedTbRuleEngine;
    private transient TenantProfileData profileData;
    @JsonIgnore
    private byte[] profileDataBytes;

    public TenantProfile() {
    }

    public TenantProfile(TenantProfileId tenantProfileId) {
        super(tenantProfileId);
    }

    public TenantProfile(TenantProfile tenantProfile) {
        super(tenantProfile);
        this.name = tenantProfile.getName();
        this.description = tenantProfile.getDescription();
        this.isDefault = tenantProfile.isDefault();
        this.isolatedTbCore = tenantProfile.isIsolatedTbCore();
        this.isolatedTbRuleEngine = tenantProfile.isIsolatedTbRuleEngine();
        this.setProfileData(tenantProfile.getProfileData());
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TenantProfileData getProfileData() {
        if (this.profileData != null) {
            return this.profileData;
        }
        if (this.profileDataBytes != null) {
            try {
                this.profileData = (TenantProfileData)SearchTextBasedWithAdditionalInfo.mapper.readValue((InputStream)new ByteArrayInputStream(this.profileDataBytes), TenantProfileData.class);
            }
            catch (IOException e) {
                log.warn("Can't deserialize tenant profile data: ", (Throwable)e);
                return this.createDefaultTenantProfileData();
            }
            return this.profileData;
        }
        return this.createDefaultTenantProfileData();
    }

    @JsonIgnore
    public Optional<DefaultTenantProfileConfiguration> getProfileConfiguration() {
        return Optional.ofNullable(this.getProfileData().getConfiguration()).filter(profileConfiguration -> profileConfiguration instanceof DefaultTenantProfileConfiguration).map(profileConfiguration -> (DefaultTenantProfileConfiguration)profileConfiguration);
    }

    public TenantProfileData createDefaultTenantProfileData() {
        TenantProfileData tpd = new TenantProfileData();
        tpd.setConfiguration(new DefaultTenantProfileConfiguration());
        return tpd;
    }

    public void setProfileData(TenantProfileData data) {
        this.profileData = data;
        try {
            this.profileDataBytes = data != null ? SearchTextBasedWithAdditionalInfo.mapper.writeValueAsBytes((Object)data) : null;
        }
        catch (JsonProcessingException e) {
            log.warn("Can't serialize tenant profile data: ", (Throwable)e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isIsolatedTbCore() {
        return this.isolatedTbCore;
    }

    public boolean isIsolatedTbRuleEngine() {
        return this.isolatedTbRuleEngine;
    }

    public byte[] getProfileDataBytes() {
        return this.profileDataBytes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setIsolatedTbCore(boolean isolatedTbCore) {
        this.isolatedTbCore = isolatedTbCore;
    }

    public void setIsolatedTbRuleEngine(boolean isolatedTbRuleEngine) {
        this.isolatedTbRuleEngine = isolatedTbRuleEngine;
    }

    @JsonIgnore
    public void setProfileDataBytes(byte[] profileDataBytes) {
        this.profileDataBytes = profileDataBytes;
    }

    @Override
    public String toString() {
        return "TenantProfile(name=" + this.getName() + ", description=" + this.getDescription() + ", isDefault=" + this.isDefault() + ", isolatedTbCore=" + this.isIsolatedTbCore() + ", isolatedTbRuleEngine=" + this.isIsolatedTbRuleEngine() + ", profileData=" + this.getProfileData() + ", profileDataBytes=" + Arrays.toString(this.getProfileDataBytes()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantProfile)) {
            return false;
        }
        TenantProfile other = (TenantProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDefault() != other.isDefault()) {
            return false;
        }
        if (this.isIsolatedTbCore() != other.isIsolatedTbCore()) {
            return false;
        }
        if (this.isIsolatedTbRuleEngine() != other.isIsolatedTbRuleEngine()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        return Arrays.equals(this.getProfileDataBytes(), other.getProfileDataBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TenantProfile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDefault() ? 79 : 97);
        result = result * 59 + (this.isIsolatedTbCore() ? 79 : 97);
        result = result * 59 + (this.isIsolatedTbRuleEngine() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + Arrays.hashCode(this.getProfileDataBytes());
        return result;
    }
}

