/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.id;

import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.ApiUsageStateId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.RpcId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;

public class EntityIdFactory {
    public static EntityId getByTypeAndId(String type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(EntityType.valueOf(type), UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndUuid(String type, UUID uuid) {
        return EntityIdFactory.getByTypeAndUuid(EntityType.valueOf(type), uuid);
    }

    public static EntityId getByTypeAndUuid(EntityType type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(type, UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndUuid(EntityType type, UUID uuid) {
        switch (type) {
            case TENANT: {
                return new TenantId(uuid);
            }
            case CUSTOMER: {
                return new CustomerId(uuid);
            }
            case USER: {
                return new UserId(uuid);
            }
            case DASHBOARD: {
                return new DashboardId(uuid);
            }
            case DEVICE: {
                return new DeviceId(uuid);
            }
            case ASSET: {
                return new AssetId(uuid);
            }
            case ALARM: {
                return new AlarmId(uuid);
            }
            case RULE_CHAIN: {
                return new RuleChainId(uuid);
            }
            case RULE_NODE: {
                return new RuleNodeId(uuid);
            }
            case ENTITY_VIEW: {
                return new EntityViewId(uuid);
            }
            case WIDGETS_BUNDLE: {
                return new WidgetsBundleId(uuid);
            }
            case WIDGET_TYPE: {
                return new WidgetTypeId(uuid);
            }
            case DEVICE_PROFILE: {
                return new DeviceProfileId(uuid);
            }
            case TENANT_PROFILE: {
                return new TenantProfileId(uuid);
            }
            case API_USAGE_STATE: {
                return new ApiUsageStateId(uuid);
            }
            case TB_RESOURCE: {
                return new TbResourceId(uuid);
            }
            case OTA_PACKAGE: {
                return new OtaPackageId(uuid);
            }
            case EDGE: {
                return new EdgeId(uuid);
            }
            case RPC: {
                return new RpcId(uuid);
            }
        }
        throw new IllegalArgumentException("EntityType " + type + " is not supported!");
    }

    public static EntityId getByEdgeEventTypeAndUuid(EdgeEventType edgeEventType, UUID uuid) {
        switch (edgeEventType) {
            case CUSTOMER: {
                return new CustomerId(uuid);
            }
            case USER: {
                return new UserId(uuid);
            }
            case DASHBOARD: {
                return new DashboardId(uuid);
            }
            case DEVICE: {
                return new DeviceId(uuid);
            }
            case DEVICE_PROFILE: {
                return new DeviceProfileId(uuid);
            }
            case ASSET: {
                return new AssetId(uuid);
            }
            case ALARM: {
                return new AlarmId(uuid);
            }
            case RULE_CHAIN: {
                return new RuleChainId(uuid);
            }
            case ENTITY_VIEW: {
                return new EntityViewId(uuid);
            }
            case WIDGETS_BUNDLE: {
                return new WidgetsBundleId(uuid);
            }
            case WIDGET_TYPE: {
                return new WidgetTypeId(uuid);
            }
            case EDGE: {
                return new EdgeId(uuid);
            }
        }
        throw new IllegalArgumentException("EdgeEventType " + edgeEventType + " is not supported!");
    }
}

