/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.device.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.device.data.DeviceTransportConfiguration;
import org.thingsboard.server.common.data.transport.snmp.AuthenticationProtocol;
import org.thingsboard.server.common.data.transport.snmp.PrivacyProtocol;
import org.thingsboard.server.common.data.transport.snmp.SnmpProtocolVersion;

public class SnmpDeviceTransportConfiguration
implements DeviceTransportConfiguration {
    private String host = "localhost";
    private Integer port = 161;
    private SnmpProtocolVersion protocolVersion = SnmpProtocolVersion.V2C;
    private String community = "public";
    private String username;
    private String securityName;
    private String contextName;
    private AuthenticationProtocol authenticationProtocol;
    private String authenticationPassphrase;
    private PrivacyProtocol privacyProtocol;
    private String privacyPassphrase;
    private String engineId;

    @Override
    public DeviceTransportType getType() {
        return DeviceTransportType.SNMP;
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            throw new IllegalArgumentException("Transport configuration is not valid");
        }
    }

    @JsonIgnore
    private boolean isValid() {
        boolean isValid;
        boolean bl = isValid = StringUtils.isNotBlank((CharSequence)this.host) && this.port != null && this.protocolVersion != null;
        if (isValid) {
            switch (this.protocolVersion) {
                case V1: 
                case V2C: {
                    isValid = StringUtils.isNotEmpty((CharSequence)this.community);
                    break;
                }
                case V3: {
                    isValid = StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.securityName) && this.contextName != null && this.authenticationProtocol != null && StringUtils.isNotBlank((CharSequence)this.authenticationPassphrase) && this.privacyProtocol != null && StringUtils.isNotBlank((CharSequence)this.privacyPassphrase) && this.engineId != null;
                }
            }
        }
        return isValid;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public SnmpProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getCommunity() {
        return this.community;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public AuthenticationProtocol getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public String getAuthenticationPassphrase() {
        return this.authenticationPassphrase;
    }

    public PrivacyProtocol getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public String getPrivacyPassphrase() {
        return this.privacyPassphrase;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setProtocolVersion(SnmpProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public void setAuthenticationProtocol(AuthenticationProtocol authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
    }

    public void setAuthenticationPassphrase(String authenticationPassphrase) {
        this.authenticationPassphrase = authenticationPassphrase;
    }

    public void setPrivacyProtocol(PrivacyProtocol privacyProtocol) {
        this.privacyProtocol = privacyProtocol;
    }

    public void setPrivacyPassphrase(String privacyPassphrase) {
        this.privacyPassphrase = privacyPassphrase;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpDeviceTransportConfiguration)) {
            return false;
        }
        SnmpDeviceTransportConfiguration other = (SnmpDeviceTransportConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        SnmpProtocolVersion this$protocolVersion = this.getProtocolVersion();
        SnmpProtocolVersion other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !((Object)((Object)this$protocolVersion)).equals((Object)other$protocolVersion)) {
            return false;
        }
        String this$community = this.getCommunity();
        String other$community = other.getCommunity();
        if (this$community == null ? other$community != null : !this$community.equals(other$community)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$securityName = this.getSecurityName();
        String other$securityName = other.getSecurityName();
        if (this$securityName == null ? other$securityName != null : !this$securityName.equals(other$securityName)) {
            return false;
        }
        String this$contextName = this.getContextName();
        String other$contextName = other.getContextName();
        if (this$contextName == null ? other$contextName != null : !this$contextName.equals(other$contextName)) {
            return false;
        }
        AuthenticationProtocol this$authenticationProtocol = this.getAuthenticationProtocol();
        AuthenticationProtocol other$authenticationProtocol = other.getAuthenticationProtocol();
        if (this$authenticationProtocol == null ? other$authenticationProtocol != null : !((Object)((Object)this$authenticationProtocol)).equals((Object)other$authenticationProtocol)) {
            return false;
        }
        String this$authenticationPassphrase = this.getAuthenticationPassphrase();
        String other$authenticationPassphrase = other.getAuthenticationPassphrase();
        if (this$authenticationPassphrase == null ? other$authenticationPassphrase != null : !this$authenticationPassphrase.equals(other$authenticationPassphrase)) {
            return false;
        }
        PrivacyProtocol this$privacyProtocol = this.getPrivacyProtocol();
        PrivacyProtocol other$privacyProtocol = other.getPrivacyProtocol();
        if (this$privacyProtocol == null ? other$privacyProtocol != null : !((Object)((Object)this$privacyProtocol)).equals((Object)other$privacyProtocol)) {
            return false;
        }
        String this$privacyPassphrase = this.getPrivacyPassphrase();
        String other$privacyPassphrase = other.getPrivacyPassphrase();
        if (this$privacyPassphrase == null ? other$privacyPassphrase != null : !this$privacyPassphrase.equals(other$privacyPassphrase)) {
            return false;
        }
        String this$engineId = this.getEngineId();
        String other$engineId = other.getEngineId();
        return !(this$engineId == null ? other$engineId != null : !this$engineId.equals(other$engineId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SnmpDeviceTransportConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        SnmpProtocolVersion $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : ((Object)((Object)$protocolVersion)).hashCode());
        String $community = this.getCommunity();
        result = result * 59 + ($community == null ? 43 : $community.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $securityName = this.getSecurityName();
        result = result * 59 + ($securityName == null ? 43 : $securityName.hashCode());
        String $contextName = this.getContextName();
        result = result * 59 + ($contextName == null ? 43 : $contextName.hashCode());
        AuthenticationProtocol $authenticationProtocol = this.getAuthenticationProtocol();
        result = result * 59 + ($authenticationProtocol == null ? 43 : ((Object)((Object)$authenticationProtocol)).hashCode());
        String $authenticationPassphrase = this.getAuthenticationPassphrase();
        result = result * 59 + ($authenticationPassphrase == null ? 43 : $authenticationPassphrase.hashCode());
        PrivacyProtocol $privacyProtocol = this.getPrivacyProtocol();
        result = result * 59 + ($privacyProtocol == null ? 43 : ((Object)((Object)$privacyProtocol)).hashCode());
        String $privacyPassphrase = this.getPrivacyPassphrase();
        result = result * 59 + ($privacyPassphrase == null ? 43 : $privacyPassphrase.hashCode());
        String $engineId = this.getEngineId();
        result = result * 59 + ($engineId == null ? 43 : $engineId.hashCode());
        return result;
    }

    public String toString() {
        return "SnmpDeviceTransportConfiguration(host=" + this.getHost() + ", port=" + this.getPort() + ", protocolVersion=" + this.getProtocolVersion() + ")";
    }
}

