/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.ota;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.HasOtaPackage;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.ota.OtaPackageKey;
import org.thingsboard.server.common.data.ota.OtaPackageType;

public class OtaPackageUtil {
    private static final Logger log = LoggerFactory.getLogger(OtaPackageUtil.class);
    public static final List<String> ALL_FW_ATTRIBUTE_KEYS = new ArrayList<String>();
    public static final List<String> ALL_SW_ATTRIBUTE_KEYS;

    public static List<String> getAttributeKeys(OtaPackageType firmwareType) {
        switch (firmwareType) {
            case FIRMWARE: {
                return ALL_FW_ATTRIBUTE_KEYS;
            }
            case SOFTWARE: {
                return ALL_SW_ATTRIBUTE_KEYS;
            }
        }
        return Collections.emptyList();
    }

    public static String getAttributeKey(OtaPackageType type, OtaPackageKey key) {
        return type.getKeyPrefix() + "_" + key.getValue();
    }

    public static String getTargetTelemetryKey(OtaPackageType type, OtaPackageKey key) {
        return OtaPackageUtil.getTelemetryKey("target_", type, key);
    }

    public static String getCurrentTelemetryKey(OtaPackageType type, OtaPackageKey key) {
        return OtaPackageUtil.getTelemetryKey("current_", type, key);
    }

    private static String getTelemetryKey(String prefix, OtaPackageType type, OtaPackageKey key) {
        return prefix + type.getKeyPrefix() + "_" + key.getValue();
    }

    public static String getTelemetryKey(OtaPackageType type, OtaPackageKey key) {
        return type.getKeyPrefix() + "_" + key.getValue();
    }

    public static OtaPackageId getOtaPackageId(HasOtaPackage entity, OtaPackageType type) {
        switch (type) {
            case FIRMWARE: {
                return entity.getFirmwareId();
            }
            case SOFTWARE: {
                return entity.getSoftwareId();
            }
        }
        log.warn("Unsupported ota package type: [{}]", (Object)type);
        return null;
    }

    public static <T> T getByOtaPackageType(Supplier<T> firmwareSupplier, Supplier<T> softwareSupplier, OtaPackageType type) {
        switch (type) {
            case FIRMWARE: {
                return firmwareSupplier.get();
            }
            case SOFTWARE: {
                return softwareSupplier.get();
            }
        }
        throw new RuntimeException("Unsupported OtaPackage type: " + type);
    }

    static {
        for (OtaPackageKey key : OtaPackageKey.values()) {
            ALL_FW_ATTRIBUTE_KEYS.add(OtaPackageUtil.getAttributeKey(OtaPackageType.FIRMWARE, key));
        }
        ALL_SW_ATTRIBUTE_KEYS = new ArrayList<String>();
        for (OtaPackageKey key : OtaPackageKey.values()) {
            ALL_SW_ATTRIBUTE_KEYS.add(OtaPackageUtil.getAttributeKey(OtaPackageType.SOFTWARE, key));
        }
    }
}

