/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.registry;

import de.iip_ecosphere.platform.deviceMgt.MockInterceptor;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistry;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryAas;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryAasClient;
import de.iip_ecosphere.platform.deviceMgt.registry.StubDeviceRegistryFactoryDescriptor;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.OperationsProvider;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import test.de.iip_ecosphere.platform.support.aas.TestWithPlugin;

public class DeviceRegistryAasTest
extends TestWithPlugin {
    public static final String A_VALID_DEVICE = "A_VALID_DEVICE";
    public static final String AN_INVALID_DEVICE = "AN_INVALID_DEVICE";
    public static final String SOME_TELEMETRY_DATA = "{\"someField\": \"someData\"}";
    public static final String AN_IP = "1.1.1.1";
    private static final Class<?> CONTRIBUTOR_CLASS = DeviceRegistryAas.class;
    private Aas aas;
    private Server implServer;
    private Server aasServer;
    private Submodel resourcesSubmodel;
    private SubmodelElementCollection deviceRegistry;
    private MockInterceptor interceptor = new MockInterceptor();

    @Before
    public void setUp() throws Exception {
        super.setup();
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup(), (boolean)true);
        AasPartRegistry.AasBuildResult res = AasPartRegistry.build(CONTRIBUTOR_CLASS::isInstance);
        res.getProtocolServerBuilder().setInterceptor((OperationsProvider.Interceptor)this.interceptor);
        this.implServer = (Server)res.getProtocolServerBuilder().build();
        this.implServer.start();
        this.aasServer = AasPartRegistry.deploy((List)res.getAas(), (String[])new String[0]);
        this.aasServer.start();
        this.aas = AasPartRegistry.retrieveIipAas();
        this.aas.accept((AasVisitor)new AasPrintVisitor());
        this.resourcesSubmodel = this.aas.getSubmodel("resources");
        this.deviceRegistry = this.resourcesSubmodel.getSubmodelElementCollection("deviceRegistry");
    }

    @After
    public void tearDown() {
        this.interceptor.clear();
        this.implServer.stop(true);
        this.aasServer.stop(true);
        Mockito.reset((Object[])new DeviceRegistry[]{StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry()});
    }

    @Test
    public void init_contributorClassLoads() {
        Assert.assertTrue((boolean)AasPartRegistry.contributorClasses().contains(CONTRIBUTOR_CLASS));
    }

    @Test
    public void init_contributedAasIsDeployed() {
        Assert.assertNotNull((Object)this.resourcesSubmodel);
        Assert.assertNotNull((Object)this.deviceRegistry);
    }

    @Test
    public void op_addDevice_withValidDeviceIdentifier_addsDevice() throws ExecutionException, IOException {
        DeviceRegistryAasTest.mockDeviceResource(A_VALID_DEVICE);
        DeviceRegistryAasClient client = new DeviceRegistryAasClient();
        client.addDevice(A_VALID_DEVICE, AN_IP);
        Set devices = client.getDevices();
        Assert.assertNotNull((Object)devices);
        int elementsCount = devices.size();
        Assert.assertEquals((long)1L, (long)elementsCount);
        SubmodelElementCollection device = (SubmodelElementCollection)devices.stream().findFirst().get();
        Assert.assertNotNull((Object)device);
        Property managedId = device.getProperty("managedId");
        Assert.assertNotNull((Object)managedId);
        Assert.assertEquals((Object)A_VALID_DEVICE, (Object)managedId.getValue());
        AasPartRegistry.retrieveIipAas().accept((AasVisitor)new AasPrintVisitor());
    }

    @Test
    public void op_addDevice_validDevice_exposesIp() throws IOException, ExecutionException {
        DeviceRegistryAasTest.mockDeviceResource(A_VALID_DEVICE);
        DeviceRegistryAasClient client = new DeviceRegistryAasClient();
        client.addDevice(A_VALID_DEVICE, AN_IP);
        SubmodelElementCollection device = (SubmodelElementCollection)client.getDevices().stream().findFirst().get();
        Property property = device.getProperty("ip");
        Assert.assertNotNull((Object)property);
        Assert.assertEquals((Object)AN_IP, (Object)property.getValue());
    }

    @Test
    public void op_removeDevice_withValidDeviceIdentifier_removesDevice() throws ExecutionException, IOException {
        DeviceRegistryAasTest.mockDeviceResource(A_VALID_DEVICE);
        DeviceRegistryAasClient client = new DeviceRegistryAasClient();
        int beforeCount = client.getDevices().size();
        client.addDevice(A_VALID_DEVICE, AN_IP);
        client = new DeviceRegistryAasClient();
        int addCount = client.getDevices().size();
        Assert.assertEquals((long)1L, (long)addCount);
        client.removeDevice(A_VALID_DEVICE);
        client = new DeviceRegistryAasClient();
        int afterCount = client.getDevices().size();
        Assert.assertEquals((long)beforeCount, (long)afterCount);
    }

    @Test
    public void op_imAlive_isCallable() throws IOException, ExecutionException {
        Operation operation = this.getOperation("imAlive");
        Assert.assertNotNull((Object)operation);
        Object invoke = operation.invoke(new Object[]{A_VALID_DEVICE});
        Assert.assertNotNull((Object)invoke);
    }

    private Operation getOperation(String operationName) {
        Operation operation = this.aas.getSubmodel("resources").getSubmodelElementCollection("deviceRegistry").getOperation(operationName);
        return operation;
    }

    @Test
    public void op_imAlive_callsImAliveFromRegistry() throws ExecutionException {
        DeviceRegistry mockRegistry = StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry();
        this.getOperation("imAlive").invoke(new Object[]{A_VALID_DEVICE});
        ((DeviceRegistry)Mockito.verify((Object)mockRegistry)).imAlive((String)Mockito.eq((Object)A_VALID_DEVICE));
    }

    @Test
    public void op_sendTelemetry_isCallable() throws ExecutionException {
        Operation operation = this.getOperation("sendTelemetry");
        Assert.assertNotNull((Object)operation);
        Object invoke = operation.invoke(new Object[]{A_VALID_DEVICE, SOME_TELEMETRY_DATA});
        Assert.assertNotNull((Object)invoke);
    }

    @Test
    public void op_sendTelemetry_deliversTelemetryToRegistry() throws ExecutionException {
        DeviceRegistry mockRegistry = StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry();
        this.getOperation("sendTelemetry").invoke(new Object[]{A_VALID_DEVICE, SOME_TELEMETRY_DATA});
        ((DeviceRegistry)Mockito.verify((Object)mockRegistry)).sendTelemetry((String)Mockito.eq((Object)A_VALID_DEVICE), (String)Mockito.eq((Object)SOME_TELEMETRY_DATA));
    }

    @Test
    public void op_removeDevice_withInvalidDeviceIdentifier_doesNotRemoveDevice() throws ExecutionException, IOException {
        DeviceRegistryAasClient client = new DeviceRegistryAasClient();
        int beforeCount = client.getDevices().size();
        client.removeDevice(AN_INVALID_DEVICE);
        client = new DeviceRegistryAasClient();
        int afterCount = client.getDevices().size();
        Assert.assertEquals((long)beforeCount, (long)afterCount);
    }

    public static void mockDeviceResource(String aDeviceId) throws IOException {
        ActiveAasBase.getSubmodel((String)"resources").createSubmodelElementCollectionBuilder(aDeviceId).build();
    }
}

