/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.mockito.Mockito;

public class SocketUtils {
    public static Socket mockSocket() {
        Socket inSocket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)inSocket.getInetAddress()).thenReturn((Object)((InetAddress)Mockito.mock(InetAddress.class)));
        return inSocket;
    }

    public static class MockInputStream
    extends InputStream {
        private final String payload;
        private int index = 0;

        public MockInputStream(String payload) {
            this.payload = payload;
        }

        @Override
        public int read() throws IOException {
            if (this.index >= this.payload.getBytes().length) {
                return -1;
            }
            byte aByte = this.payload.getBytes()[this.index];
            ++this.index;
            return aByte;
        }
    }

    public static class MockOutputStream
    extends OutputStream {
        private final List<Integer> payload = new ArrayList<Integer>();

        @Override
        public void write(int iVal) throws IOException {
            this.payload.add(iVal);
        }

        public String getAsString() {
            if (this.payload.size() == 0) {
                return null;
            }
            byte[] bytes = new byte[this.payload.size()];
            for (int i = 0; i < this.payload.size(); ++i) {
                bytes[i] = this.payload.get(i).byteValue();
            }
            return new String(bytes);
        }
    }
}

