/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.storage;

import de.iip_ecosphere.platform.deviceMgt.DeviceMgtSetup;
import de.iip_ecosphere.platform.deviceMgt.storage.PackageStorageSetup;
import de.iip_ecosphere.platform.deviceMgt.storage.Storage;
import de.iip_ecosphere.platform.deviceMgt.storage.StorageFactoryDescriptor;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.Plugin;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import java.io.IOException;
import java.util.Optional;

public class StorageFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)StorageFactory.class.getName());
    private static final StorageFactory INSTANCE = new StorageFactory();
    private Storage runtimeStorage;
    private Storage configStorage;
    private DeviceMgtSetup setup;
    private StorageFactoryDescriptor desc;

    public static StorageFactory getInstance() {
        return INSTANCE;
    }

    public Storage createStorage(PackageStorageSetup setup) {
        this.initDesc();
        Storage storage = setup != null && this.desc != null ? this.desc.createPackageStorage(setup) : null;
        return storage;
    }

    public Storage createRuntimeStorage() {
        this.loadSetup();
        this.initDesc();
        if (this.runtimeStorage == null && this.setup != null && this.desc != null) {
            this.runtimeStorage = this.createStorage(this.setup.getRuntimeStorage());
        }
        return this.runtimeStorage;
    }

    private void initDesc() {
        if (this.desc == null) {
            Plugin plugin = PluginManager.getPlugin(StorageFactoryDescriptor.class);
            if (null != plugin) {
                this.desc = (StorageFactoryDescriptor)plugin.getInstance();
            } else {
                Optional storageFactoryDescriptors = ServiceLoaderUtils.findFirst(StorageFactoryDescriptor.class);
                if (storageFactoryDescriptors.isPresent()) {
                    this.desc = (StorageFactoryDescriptor)storageFactoryDescriptors.get();
                } else {
                    LOGGER.info("No StorageFactoryDescriptor implementation available");
                }
            }
        }
    }

    public Storage createConfigStorage() {
        this.loadSetup();
        this.initDesc();
        if (this.configStorage == null && this.setup != null && this.desc != null) {
            this.configStorage = this.createStorage(this.setup.getConfigStorage());
        }
        return this.configStorage;
    }

    private void loadSetup() {
        if (this.setup == null) {
            try {
                this.setup = (DeviceMgtSetup)((Object)DeviceMgtSetup.readFromYaml(DeviceMgtSetup.class));
            }
            catch (IOException e) {
                LOGGER.error("Cannot load Configuration: ", (Throwable)e);
            }
        }
    }

    public void setSetup(DeviceMgtSetup configuration) {
        this.setup = configuration;
    }

    public DeviceMgtSetup getSetup() {
        this.loadSetup();
        return this.setup;
    }
}

