/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.registry;

import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistry;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryFactoryDescriptor;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryProxy;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.Plugin;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import java.util.Optional;

public class DeviceRegistryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DeviceRegistryFactory.class.getName());
    private static DeviceRegistryFactoryDescriptor desc;
    private static DeviceRegistryProxy proxy;

    public static DeviceRegistry getDeviceRegistry() {
        if (null == desc) {
            Plugin plugin = PluginManager.getPlugin(DeviceRegistryFactoryDescriptor.class);
            if (null != plugin) {
                desc = (DeviceRegistryFactoryDescriptor)plugin.getInstance();
            } else {
                Optional first = ServiceLoaderUtils.findFirst(DeviceRegistryFactoryDescriptor.class);
                if (first.isPresent()) {
                    desc = (DeviceRegistryFactoryDescriptor)first.get();
                } else {
                    LOGGER.warn("No Device Registry implementation available.");
                }
            }
        }
        if (null == proxy && null != desc) {
            proxy = new DeviceRegistryProxy(desc.createDeviceRegistryInstance());
        }
        return proxy;
    }

    static void resetDeviceRegistryFactory() {
        desc = null;
        proxy = null;
    }
}

