/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt;

import de.iip_ecosphere.platform.support.aas.OperationsProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class MockInterceptor
implements OperationsProvider.Interceptor {
    private Map<String, Function<Object[], Object>> operations = new HashMap<String, Function<Object[], Object>>();
    private Map<String, Integer> counters = new HashMap<String, Integer>();

    private String getKey(String category, String name) {
        return category + "_" + name;
    }

    public Function<Object[], Object> getOperation(String category, String name, Function<Object[], Object> origin) {
        String key = this.getKey(category, name);
        this.counters.put(key, this.getCounter(key) + 1);
        Function<Object[], Object> result = this.operations.get(key);
        return null == result ? origin : result;
    }

    public void intercept(String name, Function<Object[], Object> function) {
        this.intercept("service", name, function);
    }

    public void intercept(String category, String name, Function<Object[], Object> function) {
        this.operations.put(this.getKey(category, name), function);
    }

    public int getCalls(String name) {
        return this.getCalls("service", name);
    }

    private int getCounter(String key) {
        Integer result = this.counters.get(key);
        return null == result ? 0 : result;
    }

    public int getCalls(String category, String name) {
        return this.getCounter(this.getKey(category, name));
    }

    public void clear() {
        this.operations.clear();
        this.counters.clear();
    }
}

