/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.registry;

import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistrationResponse;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistry;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryAas;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryAasClient;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryAasTest;
import de.iip_ecosphere.platform.deviceMgt.registry.StubDeviceRegistryFactoryDescriptor;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import test.de.iip_ecosphere.platform.support.aas.TestWithPlugin;

public class DeviceRegistryAasClientTest
extends TestWithPlugin {
    public static final String A_DEVICE_ID = "A_DEVICE_ID";
    public static final String AN_INVALID_DEVICE_ID = "AN_INVALID_DEVICE";
    public static final String SOME_TELEMETRY = "{\"testField\": 123}";
    public static final String AN_IP = "1.1.1.1";
    private static final Class<?> CONTRIBUTOR_CLASS = DeviceRegistryAas.class;
    private Server implServer;
    private Server aasServer;
    private DeviceRegistryAasClient client;

    @Before
    public void setUp() throws Exception {
        super.setup();
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup(), (boolean)true);
        AasPartRegistry.AasBuildResult res = AasPartRegistry.build(CONTRIBUTOR_CLASS::isInstance);
        this.implServer = (Server)res.getProtocolServerBuilder().build();
        this.implServer.start();
        this.aasServer = AasPartRegistry.deploy((List)res.getAas(), (String[])new String[0]);
        this.aasServer.start();
        this.client = new DeviceRegistryAasClient();
    }

    @After
    public void tearDown() {
        Mockito.reset((Object[])new DeviceRegistry[]{StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry()});
    }

    @Test
    public void getDevices_withNoDevices_shouldReturnEmptyCollection() {
        Assert.assertEquals((long)0L, (long)this.client.getDevices().size());
    }

    @Test
    public void getDevices_withOneDevice_shouldReturnCollectionWithTheOneDevice() throws ExecutionException, IOException {
        DeviceRegistryAasTest.mockDeviceResource(A_DEVICE_ID);
        DeviceRegistrationResponse mockResp = new DeviceRegistrationResponse();
        mockResp.setSuccessful(true);
        Mockito.when((Object)StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry().addDevice(A_DEVICE_ID, AN_IP)).thenReturn((Object)mockResp);
        DeviceRegistrationResponse resp = this.client.addDevice(A_DEVICE_ID, AN_IP);
        Assert.assertNotNull((Object)resp);
        Assert.assertTrue((boolean)resp.isSuccessful());
        AasPartRegistry.retrieveIipAas().accept((AasVisitor)new AasPrintVisitor());
        this.client = new DeviceRegistryAasClient();
        Assert.assertEquals((long)1L, (long)this.client.getDevices().size());
        Assert.assertNotNull((Object)this.client.getDevice(A_DEVICE_ID));
    }

    @Test
    public void getDevice_withInvalidDevice_shouldReturnNull() {
        Assert.assertNull((Object)this.client.getDevice(AN_INVALID_DEVICE_ID));
    }

    @Test
    public void getDevice_withValidDevice_shouldNotReturnNull() throws ExecutionException, IOException {
        DeviceRegistrationResponse mockResp = new DeviceRegistrationResponse();
        mockResp.setSuccessful(true);
        Mockito.when((Object)StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry().addDevice(A_DEVICE_ID, AN_IP)).thenReturn((Object)mockResp);
        DeviceRegistryAasTest.mockDeviceResource(A_DEVICE_ID);
        DeviceRegistrationResponse resp = this.client.addDevice(A_DEVICE_ID, AN_IP);
        Assert.assertNotNull((Object)resp);
        Assert.assertTrue((boolean)resp.isSuccessful());
        this.client = new DeviceRegistryAasClient();
        SubmodelElementCollection device = this.client.getDevice(A_DEVICE_ID);
        Assert.assertNotNull((Object)device);
        Assert.assertNotNull((Object)device.getProperty("managedId").getValue());
    }

    @Test
    public void addDevice_withDevice_shouldAddDevice() throws ExecutionException, IOException {
        DeviceRegistryAasTest.mockDeviceResource(A_DEVICE_ID);
        DeviceRegistrationResponse mockResp = new DeviceRegistrationResponse();
        mockResp.setSuccessful(true);
        Mockito.when((Object)StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry().addDevice(A_DEVICE_ID, AN_IP)).thenReturn((Object)mockResp);
        DeviceRegistrationResponse resp = this.client.addDevice(A_DEVICE_ID, AN_IP);
        Assert.assertNotNull((Object)resp);
        Assert.assertTrue((boolean)resp.isSuccessful());
        this.client = new DeviceRegistryAasClient();
        Assert.assertNotNull((Object)this.client.getDevice(A_DEVICE_ID));
    }

    @Test
    public void addDevice_invalidDevice() throws ExecutionException, IOException {
        DeviceRegistryAasTest.mockDeviceResource(A_DEVICE_ID);
        DeviceRegistrationResponse mockResp = new DeviceRegistrationResponse();
        mockResp.setSuccessful(false);
        mockResp.setMessage("FAILED");
        Mockito.when((Object)StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry().addDevice(A_DEVICE_ID, AN_IP)).thenReturn((Object)mockResp);
        DeviceRegistrationResponse resp = this.client.addDevice(A_DEVICE_ID, AN_IP);
        Assert.assertNotNull((Object)resp);
        Assert.assertFalse((boolean)resp.isSuccessful());
        Assert.assertTrue((resp.getMessage().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void sendTelemetry_withDeviceAndTelementry_shouldSendTelemetryToRegistry() throws ExecutionException {
        DeviceRegistry mockRegistry = StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry();
        this.client.sendTelemetry(A_DEVICE_ID, SOME_TELEMETRY);
        ((DeviceRegistry)Mockito.verify((Object)mockRegistry)).sendTelemetry((String)ArgumentMatchers.eq((Object)A_DEVICE_ID), (String)ArgumentMatchers.eq((Object)SOME_TELEMETRY));
    }

    @Test
    public void imAlive_withDevice_shouldCallImAliveFromRegistry() throws ExecutionException {
        DeviceRegistry mockRegistry = StubDeviceRegistryFactoryDescriptor.mockDeviceRegistry();
        this.client.imAlive(A_DEVICE_ID);
        ((DeviceRegistry)Mockito.verify((Object)mockRegistry)).imAlive((String)ArgumentMatchers.eq((Object)A_DEVICE_ID));
    }
}

