/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt;

import de.iip_ecosphere.platform.deviceMgt.DeviceFirmwareOperations;
import de.iip_ecosphere.platform.deviceMgt.DeviceManagementAas;
import de.iip_ecosphere.platform.deviceMgt.ecs.EcsAasClient;
import de.iip_ecosphere.platform.deviceMgt.storage.Storage;
import de.iip_ecosphere.platform.deviceMgt.storage.StorageFactory;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class AasDeviceFirmwareOperations
implements DeviceFirmwareOperations {
    @Override
    public void updateRuntime(String id) throws ExecutionException {
        Storage runtimeStorage = StorageFactory.getInstance().createRuntimeStorage();
        String downloadUrl = null;
        try {
            EcsAasClient ecsAasClient = new EcsAasClient(id);
            String runtimeName = ecsAasClient.getRuntimeName();
            Integer newRuntimeVersion = this.getHighestVersion(runtimeStorage, runtimeName);
            if (newRuntimeVersion != -1) {
                downloadUrl = runtimeStorage.generateDownloadUrl(runtimeName + "_" + newRuntimeVersion);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (downloadUrl != null) {
            DeviceManagementAas.notifyUpdateRuntime(id, downloadUrl);
        }
    }

    private Integer getHighestVersion(Storage storage, String runtimeName) {
        return null == storage ? -1 : storage.list().stream().filter(key -> key.startsWith(storage.getPrefix() + runtimeName + "_")).map(key -> {
            int lastUnderscore = key.lastIndexOf("_");
            String versionString = key.substring(lastUnderscore + 1);
            return Integer.parseInt(versionString);
        }).findFirst().orElse(-1);
    }
}

