/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.ssh;

import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class Proxy
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Proxy.class);
    private final Socket in;
    private final Socket out;

    public Proxy(Socket in, Socket out) {
        this.in = in;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.info("Proxy {}:{} --> {}:{}", new Object[]{this.in.getInetAddress().getHostName(), this.in.getPort(), this.out.getInetAddress().getHostName(), this.out.getPort()});
        try {
            int bytesRead;
            InputStream inputStream = this.getInputStream();
            OutputStream outputStream = this.getOutputStream();
            if (inputStream == null || outputStream == null) {
                return;
            }
            byte[] reply = new byte[4096];
            while (-1 != (bytesRead = inputStream.read(reply))) {
                outputStream.write(reply, 0, bytesRead);
            }
        }
        catch (SocketException e) {
        }
        catch (IOException e) {
            LOGGER.error("IOException " + e.getMessage());
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException e) {
                LOGGER.error("IOException " + e.getMessage());
            }
        }
    }

    private InputStream getInputStream() {
        try {
            return this.in.getInputStream();
        }
        catch (IOException e) {
            LOGGER.error("IOException obtaining input stream " + e.getMessage());
            return null;
        }
    }

    private OutputStream getOutputStream() {
        try {
            return this.out.getOutputStream();
        }
        catch (IOException e) {
            LOGGER.error("IOException obtaining output stream " + e.getMessage());
            return null;
        }
    }
}

