/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt;

import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryClient;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryClientFactory;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.BeforeClass;
import org.junit.Test;
import test.de.iip_ecosphere.platform.support.aas.TestWithPlugin;

public class PerformanceTests
extends TestWithPlugin {
    private static Aas aas;
    private static Server implServer;
    private static Server aasServer;

    @BeforeClass
    public static void startup() throws IOException {
        PerformanceTests.loadPlugins();
        AasPartRegistry.AasBuildResult res = AasPartRegistry.build();
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup(), (boolean)true);
        implServer = (Server)res.getProtocolServerBuilder().build();
        implServer.start();
        aasServer = AasPartRegistry.deploy((List)res.getAas(), (String[])new String[0]);
        aasServer.start();
        aas = AasPartRegistry.retrieveIipAas();
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
    }

    @Test
    public void addDevice_single() throws IOException {
        DeviceRegistryClient deviceRegistryClient = DeviceRegistryClientFactory.createDeviceRegistryClient();
        List<String> ids = this.generateIds(10);
        this.createDevices(ids);
        System.out.println("time = " + this.add(ids, deviceRegistryClient));
        for (int i = 0; i < 3; ++i) {
            ids = this.generateIds(1);
            this.createDevices(ids);
            System.out.println("time = " + this.add(ids, deviceRegistryClient));
        }
    }

    @Test
    public void addDevice_mass() throws IOException {
        DeviceRegistryClient deviceRegistryClient = DeviceRegistryClientFactory.createDeviceRegistryClient();
        List<String> ids = this.generateIds(500);
        this.createDevices(ids);
        System.out.println("time = " + this.add(ids, deviceRegistryClient));
    }

    @Test
    public void removeDevice_single() throws IOException {
        DeviceRegistryClient deviceRegistryClient = DeviceRegistryClientFactory.createDeviceRegistryClient();
        List<String> ids = this.generateIds(10);
        this.createDevices(ids);
        this.add(ids, deviceRegistryClient);
        System.out.println("time = " + this.remove(ids, deviceRegistryClient));
        for (int i = 0; i < 3; ++i) {
            ids = this.generateIds(1);
            this.createDevices(ids);
            this.add(ids, deviceRegistryClient);
            System.out.println("time = " + this.remove(ids, deviceRegistryClient));
        }
    }

    @Test
    public void removeDevice_mass() throws IOException, InterruptedException {
        DeviceRegistryClient deviceRegistryClient = DeviceRegistryClientFactory.createDeviceRegistryClient();
        List<String> ids = this.generateIds(100);
        this.createDevices(ids);
        this.add(ids, deviceRegistryClient);
        Thread.sleep(200L);
        System.out.println("time = " + this.remove(ids, deviceRegistryClient));
    }

    private long add(List<String> ids, DeviceRegistryClient deviceRegistryClient) {
        long start = System.currentTimeMillis();
        ids.forEach(id -> {
            try {
                deviceRegistryClient.addDevice(id, "AN_IP");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        });
        long end = System.currentTimeMillis();
        return end - start;
    }

    private long remove(List<String> ids, DeviceRegistryClient deviceRegistryClient) {
        long start = System.currentTimeMillis();
        ids.forEach(id -> {
            try {
                deviceRegistryClient.removeDevice(id);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        });
        long end = System.currentTimeMillis();
        return end - start;
    }

    private List<String> generateIds(int count) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 1; i <= count; ++i) {
            ids.add("device" + i);
        }
        return ids;
    }

    private void createDevices(List<String> ids) throws IOException {
        ids.forEach(id -> {
            try {
                AasPartRegistry.retrieveIipAas().getSubmodel("resources").createSubmodelElementCollectionBuilder(AasUtils.fixId((String)id)).build();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        AasPartRegistry.retrieveIipAas().accept((AasVisitor)new AasPrintVisitor());
    }
}

