/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.ssh;

import de.iip_ecosphere.platform.deviceMgt.ssh.Proxy;
import de.iip_ecosphere.platform.deviceMgt.ssh.SocketUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ProxyTest {
    public static final String A_MESSAGE = "test";

    @Test
    public void proxy_withDateOnInputStream_proxiesDataToOutputStream() throws IOException, InterruptedException {
        Socket inSocket = SocketUtils.mockSocket();
        Socket outSocket = SocketUtils.mockSocket();
        SocketUtils.MockOutputStream outputStream = new SocketUtils.MockOutputStream();
        Mockito.when((Object)outSocket.getOutputStream()).thenReturn((Object)outputStream);
        Mockito.when((Object)inSocket.getInputStream()).thenReturn((Object)new SocketUtils.MockInputStream(A_MESSAGE));
        Proxy proxy = new Proxy(inSocket, outSocket);
        proxy.run();
        Assert.assertEquals((Object)A_MESSAGE, (Object)outputStream.getAsString());
    }

    @Test
    public void proxy_withoutInputStream_wontProxyData() throws IOException {
        Socket inSocket = SocketUtils.mockSocket();
        Socket outSocket = SocketUtils.mockSocket();
        SocketUtils.MockOutputStream outputStream = new SocketUtils.MockOutputStream();
        Mockito.when((Object)outSocket.getOutputStream()).thenReturn((Object)outputStream);
        Mockito.when((Object)inSocket.getInputStream()).thenReturn(null);
        Proxy proxy = new Proxy(inSocket, outSocket);
        proxy.run();
        Assert.assertNull((Object)outputStream.getAsString());
    }

    @Test
    public void proxy_withoutOutputStream_wontProxyData() throws IOException {
        Socket inSocket = SocketUtils.mockSocket();
        Socket outSocket = SocketUtils.mockSocket();
        Mockito.when((Object)outSocket.getOutputStream()).thenReturn(null);
        InputStream mockInputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inSocket.getInputStream()).thenReturn((Object)mockInputStream);
        Proxy proxy = new Proxy(inSocket, outSocket);
        proxy.run();
        ((InputStream)Mockito.verify((Object)mockInputStream, (VerificationMode)Mockito.times((int)0))).read();
    }

    @Test
    public void proxy_withThrowingInputStream_wontProxyData() throws IOException {
        Socket inSocket = SocketUtils.mockSocket();
        Socket outSocket = SocketUtils.mockSocket();
        SocketUtils.MockOutputStream outputStream = new SocketUtils.MockOutputStream();
        Mockito.when((Object)outSocket.getOutputStream()).thenReturn((Object)outputStream);
        Mockito.when((Object)inSocket.getInputStream()).thenThrow(new Throwable[]{new IOException()});
        Proxy proxy = new Proxy(inSocket, outSocket);
        proxy.run();
        Assert.assertNull((Object)outputStream.getAsString());
    }

    @Test
    public void proxy_withThrowingOutputStream_wontProxyData() throws IOException {
        Socket inSocket = SocketUtils.mockSocket();
        Socket outSocket = SocketUtils.mockSocket();
        InputStream mockInputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inSocket.getInputStream()).thenReturn((Object)mockInputStream);
        Mockito.when((Object)inSocket.getOutputStream()).thenThrow(new Throwable[]{new IOException()});
        Proxy proxy = new Proxy(inSocket, outSocket);
        proxy.run();
        ((InputStream)Mockito.verify((Object)mockInputStream, (VerificationMode)Mockito.times((int)0))).read();
    }
}

