/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt;

import de.iip_ecosphere.platform.deviceMgt.DeviceManagementFactory;
import de.iip_ecosphere.platform.deviceMgt.DeviceRemoteManagementOperations;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryFactory;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class DeviceManagementAas
implements AasContributor {
    public static final String NAME_SUBMODEL = "resources";
    public static final String NAME_COLL_DEVICE_MANAGER = "deviceManager";
    public static final String NAME_OP_UPDATE_RUNTIME = "updateRuntime";
    public static final String NAME_OP_ESTABLISH_SSH = "establishSsh";
    public static final String NAME_OP_SET_CONFIG = "setConfig";
    public static final String ECS_UPDATE_URI = "https://an.uri.local";

    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        AuthenticationDescriptor aDesc = this.getSubmodelAuthentication();
        Submodel.SubmodelBuilder smB = (Submodel.SubmodelBuilder)AasPartRegistry.createSubmodelBuilder((Aas.AasBuilder)aasBuilder, (String)NAME_SUBMODEL).rbacDevice(aDesc);
        SubmodelElementCollection.SubmodelElementCollectionBuilder deviceManager = smB.createSubmodelElementCollectionBuilder(NAME_COLL_DEVICE_MANAGER);
        deviceManager.createOperationBuilder(NAME_OP_UPDATE_RUNTIME).setInvocable(iCreator.createInvocable(this.getQName(NAME_OP_UPDATE_RUNTIME))).addInputVariable("deviceId", Type.STRING).build(aDesc);
        deviceManager.createOperationBuilder(NAME_OP_ESTABLISH_SSH).setInvocable(iCreator.createInvocable(this.getQName(NAME_OP_ESTABLISH_SSH))).addInputVariable("deviceId", Type.STRING).build(Type.STRING, aDesc);
        deviceManager.createOperationBuilder(NAME_OP_SET_CONFIG).setInvocable(iCreator.createInvocable(this.getQName(NAME_OP_SET_CONFIG))).addInputVariable("deviceId", Type.STRING).addInputVariable("configPath", Type.STRING).build(aDesc);
        deviceManager.build();
        smB.defer();
        return null;
    }

    public void contributeTo(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(this.getQName(NAME_OP_UPDATE_RUNTIME), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            DeviceManagementFactory.getDeviceManagement().updateRuntime(AasUtils.readString((Object[])p));
            return null;
        }));
        sBuilder.defineOperation(this.getQName(NAME_OP_ESTABLISH_SSH), p -> {
            try {
                DeviceRemoteManagementOperations.SSHConnectionDetails connectionDetails = DeviceManagementFactory.getDeviceManagement().establishSsh(AasUtils.readString((Object[])p));
                return Json.writeValueAsStringDflt((Object)connectionDetails);
            }
            catch (IOException | ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        });
        sBuilder.defineOperation(this.getQName(NAME_OP_SET_CONFIG), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            DeviceManagementFactory.getDeviceManagement().setConfig(AasUtils.readString((Object[])p), AasUtils.readString((Object[])p, (int)1));
            return null;
        }));
    }

    public static void notifySetConfig(String id, String downloadUri, String location) {
        ActiveAasBase.processNotification((String)NAME_SUBMODEL, (sub, aas) -> {
            try {
                sub.getSubmodelElementCollection(id).getOperation(NAME_OP_SET_CONFIG).invoke(new Object[]{downloadUri, location});
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        });
    }

    public static void notifyUpdateRuntime(String id, String downloadUrl) {
        ActiveAasBase.processNotification((String)NAME_SUBMODEL, (sub, aas) -> {
            try {
                sub.getSubmodelElementCollection(id).getOperation(NAME_OP_UPDATE_RUNTIME).invoke(new Object[]{downloadUrl});
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        });
    }

    private String getQName(String name) {
        return "resources_" + name;
    }

    public AasContributor.Kind getKind() {
        return AasContributor.Kind.ACTIVE;
    }

    public boolean isValid() {
        return null != DeviceManagementFactory.getDeviceManagement() || null != DeviceRegistryFactory.getDeviceRegistry();
    }
}

