/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.model;

import de.iip_ecosphere.platform.connectors.parser.InputParser;
import de.iip_ecosphere.platform.transport.serialization.QualifiedElement;
import de.iip_ecosphere.platform.transport.serialization.QualifiedElementFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ModelInputConverter
implements InputParser.InputConverter<Object> {
    public static final ModelInputConverter INSTANCE = new ModelInputConverter();

    protected ModelInputConverter() {
    }

    @Override
    public int toInteger(Object data) throws IOException {
        return (Integer)data;
    }

    @Override
    public byte toByte(Object data) throws IOException {
        return (Byte)data;
    }

    @Override
    public long toLong(Object data) throws IOException {
        return (Long)data;
    }

    @Override
    public short toShort(Object data) throws IOException {
        return (Short)data;
    }

    @Override
    public String toString(Object data) throws IOException {
        return null != data ? data.toString() : null;
    }

    @Override
    public double toDouble(Object data) throws IOException {
        return (Double)data;
    }

    @Override
    public float toFloat(Object data) throws IOException {
        return ((Float)data).floatValue();
    }

    @Override
    public boolean toBoolean(Object data) throws IOException {
        return (Boolean)data;
    }

    @Override
    public int[] toIntegerArray(Object data) throws IOException {
        return (int[])data;
    }

    @Override
    public double[] toDoubleArray(Object data) throws IOException {
        return (double[])data;
    }

    @Override
    public String[] toStringArray(Object data) throws IOException {
        return (String[])data;
    }

    @Override
    public byte[] toByteArray(Object data) throws IOException {
        return (byte[])data;
    }

    @Override
    public Object toObject(Object data) throws IOException {
        return data;
    }

    @Override
    public <E> List<E> toList(Object data, Class<E> eltCls) throws IOException {
        if (data instanceof List) {
            List src = (List)data;
            ArrayList<E> result = new ArrayList<E>(src.size());
            for (int i = 0; i < src.size(); ++i) {
                Object obj = src.get(i);
                if (obj instanceof QualifiedElement) {
                    obj = ((QualifiedElement)obj).getValue();
                }
                if (!eltCls.isInstance(obj)) {
                    throw new IOException("Element " + i + " " + String.valueOf(obj) + " is not of type " + eltCls.getName());
                }
                result.add(eltCls.cast(obj));
            }
            return result;
        }
        throw new IOException("Cannot handle " + String.valueOf(data) + " as list.");
    }

    @Override
    public <E> List<QualifiedElement<E>> toElementList(Object data, Class<E> eltCls) throws IOException {
        if (data instanceof List) {
            List src = (List)data;
            ArrayList<QualifiedElement<QualifiedElement>> result = new ArrayList<QualifiedElement<QualifiedElement>>(src.size());
            for (int i = 0; i < src.size(); ++i) {
                Object obj = src.get(i);
                if (obj instanceof QualifiedElement) {
                    obj = ((QualifiedElement)obj).getValue();
                }
                if (!eltCls.isInstance(obj)) {
                    throw new IOException("Element " + i + " " + String.valueOf(obj) + " is not of type " + eltCls.getName());
                }
                QualifiedElement elt = QualifiedElementFactory.createElement(eltCls);
                elt.setValue(eltCls.cast(obj));
                result.add(elt);
            }
            return result;
        }
        throw new IOException("Cannot handle " + String.valueOf(data) + " as list.");
    }

    @Override
    public BigInteger toBigInteger(Object data) throws IOException {
        if (data.getClass() == Number.class) {
            return BigInteger.valueOf(((Number)data).longValue());
        }
        return (BigInteger)data;
    }

    @Override
    public BigDecimal toBigDecimal(Object data) throws IOException {
        if (data.getClass() == Number.class) {
            return BigDecimal.valueOf(((Number)data).doubleValue());
        }
        return (BigDecimal)data;
    }

    @Override
    public long toLongIndex(Object data) throws IOException {
        return (Long)data;
    }

    @Override
    public float toFloatIndex(Object data) throws IOException {
        return ((Float)data).floatValue();
    }
}

