/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.collector;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.collector.CollectorSetup;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.FolderResourceResolver;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.function.Function;

public class Collector {
    public static final String PROPERTY_BUILDID = "iip.ciBuildId";
    public static final String SETUP_NAME = "oktoflow-collector.yml";
    private static final String SEPARATOR = ",";
    private static CollectorSetup setup;
    private static Field[] fields;

    private static String compose(Function<Object, String> toString, Object ... entries) {
        String result = "";
        boolean first = true;
        for (Object e : entries) {
            if (!first) {
                result = result + SEPARATOR;
            }
            result = result + toString.apply(e);
            first = false;
        }
        for (int f = entries.length; f < fields.length; ++f) {
            if (!first) {
                result = result + SEPARATOR;
            }
            result = result + toString.apply(fields[f].dflt);
            first = false;
        }
        return result;
    }

    private static void checkMigration(File dataFile, Function<Object, String> toString) {
        File tmpFile = null;
        PrintWriter out = null;
        try (LineNumberReader lnr = new LineNumberReader(new FileReader(dataFile));){
            String line;
            do {
                if ((line = lnr.readLine()) == null) continue;
                boolean firstLine = lnr.getLineNumber() == 1;
                String[] orig = line.split(SEPARATOR);
                Object[] entries = Collector.adjust(orig, firstLine, toString);
                if (firstLine && orig.length != entries.length) {
                    tmpFile = File.createTempFile("collector", ".csv");
                    out = new PrintWriter(new FileWriter(tmpFile));
                }
                if (null == out) continue;
                out.println(Collector.compose(o -> o.toString(), entries));
            } while (line != null);
            FileUtils.closeQuietly(out);
            FileUtils.closeQuietly((Closeable)lnr);
            if (null != tmpFile) {
                Files.copy(tmpFile.toPath(), dataFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                FileUtils.deleteQuietly((File)tmpFile);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Collector.class).error("Cannot migrate {}: {}", (Object)dataFile, (Object)e.getMessage());
        }
    }

    private static Object[] adjust(String[] entries, boolean header, Function<Object, String> toString) {
        Object[] result = entries;
        if (fields.length > entries.length) {
            result = new String[fields.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = i < entries.length ? entries[i] : toString.apply(header ? fields[i].getName() : fields[i].getDflt());
            }
        }
        return result;
    }

    public static void setFields(Field[] newFields) {
        fields = newFields;
    }

    public static Field[] getFields() {
        return fields;
    }

    private static Object[] fieldNames() {
        Object[] result = new String[fields.length];
        for (int f = 0; f < fields.length; ++f) {
            result[f] = fields[f].name;
        }
        return result;
    }

    public static CollectorSetup setSetup(CollectorSetup aSetup) {
        CollectorSetup old = setup;
        setup = aSetup;
        return old;
    }

    private static void loadPropertiesIfNeeded() {
        if (null == setup) {
            InputStream in = ResourceLoader.getResourceAsStream((String)SETUP_NAME, (ResourceResolver[])new ResourceResolver[]{FolderResourceResolver.USER_HOME});
            if (null == in) {
                LoggerFactory.getLogger(Collector.class).info("Cannot load collector properties {}. Disabling.", (Object)SETUP_NAME);
            } else {
                try {
                    setup = CollectorSetup.readFromYaml(CollectorSetup.class, in, null);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(Collector.class).info("Cannot load collector properties {}: {} Disabling.", (Object)SETUP_NAME, (Object)e.getMessage());
                }
            }
        }
    }

    public static DatapointConstructor collect(String tag) {
        Collector.loadPropertiesIfNeeded();
        return new CsvDatapointConstructor(tag);
    }

    static {
        fields = new Field[]{new Field("timestamp", 0), new Field("buildId", ""), new Field("execTimeMs", 0)};
    }

    public static class Field {
        private String name;
        private Object dflt;

        public Field(String name, Object dflt) {
            this.name = name;
            this.dflt = dflt;
        }

        public String getName() {
            return this.name;
        }

        public Object getDflt() {
            return this.dflt;
        }
    }

    private static class CsvDatapointConstructor
    implements DatapointConstructor {
        private String tag;
        private long timestamp;
        private String buildId = OsUtils.getPropertyOrEnv((String)"iip.ciBuildId", (String)"").replace(",", "_");
        private Long execTimeMs;

        private CsvDatapointConstructor(String tag) {
            this.timestamp = System.currentTimeMillis();
            this.tag = tag;
        }

        @Override
        public DatapointConstructor addExecutionTimeMs(long execTimeMs) {
            this.execTimeMs = execTimeMs;
            return this;
        }

        @Override
        public void close() {
            if (setup != null) {
                File dataFile;
                boolean dataFileExists;
                File dataDir = new File(setup.getDataDir());
                if (!dataDir.exists()) {
                    dataDir.mkdirs();
                }
                if (dataFileExists = (dataFile = new File(dataDir, this.tag + ".csv")).exists()) {
                    Collector.checkMigration(dataFile, s -> this.toString(s));
                }
                try (PrintWriter out = new PrintWriter(new FileWriter(dataFile, true));){
                    if (!dataFileExists) {
                        out.println(this.compose(Collector.fieldNames()));
                    }
                    out.println(this.compose(this.timestamp, this.buildId, this.execTimeMs));
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(Collector.class).info("Cannot write collector entry for tag '{}': {}.", (Object)this.tag, (Object)e.getMessage());
                }
            } else {
                LoggerFactory.getLogger(Collector.class).info("No collector setup, will discard collector entry for tag '{}'.", (Object)this.tag);
            }
        }

        private String compose(Object ... entries) {
            return Collector.compose(o -> this.toString(o), entries);
        }

        private String toString(Object entry) {
            String result = entry instanceof String ? this.quote(entry.toString()) : entry.toString();
            return result;
        }

        private String quote(String text) {
            return "\"" + text + "\"";
        }
    }

    public static interface DatapointConstructor {
        public DatapointConstructor addExecutionTimeMs(long var1);

        default public DatapointConstructor measureMs(Runnable run) {
            long now = System.currentTimeMillis();
            run.run();
            this.addExecutionTimeMs(System.currentTimeMillis() - now);
            return this;
        }

        public void close();
    }
}

