/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.devicemanager;

import org.eclipse.basyx.components.devicemanager.TCPDeviceManagerComponent;
import org.eclipse.basyx.components.netcomm.NetworkReceiver;
import org.eclipse.basyx.models.controlcomponent.ControlComponentChangeListener;
import org.eclipse.basyx.models.controlcomponent.ExecutionMode;
import org.eclipse.basyx.models.controlcomponent.ExecutionState;
import org.eclipse.basyx.models.controlcomponent.OccupationState;
import org.eclipse.basyx.models.controlcomponent.SimpleControlComponent;
import org.eclipse.basyx.vab.modelprovider.map.VABMapProvider;
import org.eclipse.basyx.vab.protocol.basyx.server.BaSyxTCPServer;

public abstract class TCPControllableDeviceManagerComponent
extends TCPDeviceManagerComponent
implements NetworkReceiver,
ControlComponentChangeListener {
    protected int controlComponentServerPort = -1;
    protected BaSyxTCPServer<VABMapProvider> server = null;
    protected SimpleControlComponent simpleControlComponent = null;

    public TCPControllableDeviceManagerComponent(int portNumber, int ctrlComponentServerPort) {
        super(portNumber);
        this.controlComponentServerPort = ctrlComponentServerPort;
        this.simpleControlComponent = new SimpleControlComponent(true);
        this.simpleControlComponent.addControlComponentChangeListener(this);
    }

    @Override
    public void onReceive(byte[] rxData) {
        if (rxData == null) {
            return;
        }
        String rxStr = new String(rxData);
        if (this.hasPrefix(rxStr = rxStr.trim(), "invocation:end")) {
            this.simpleControlComponent.setExecutionState(ExecutionState.COMPLETE.getValue());
            return;
        }
    }

    @Override
    public void onVariableChange(String varName, Object newValue) {
    }

    @Override
    public void onNewOccupier(String occupierId) {
    }

    @Override
    public void onNewOccupationState(OccupationState state) {
    }

    @Override
    public void onChangedExecutionMode(ExecutionMode newExecutionMode) {
    }

    @Override
    public void onChangedExecutionState(ExecutionState newExecutionState) {
        if (newExecutionState == ExecutionState.COMPLETE) {
            return;
        }
        if (this.tcpServer != null) {
            this.tcpServer.sendMessage("state:" + newExecutionState.getValue());
        }
    }

    @Override
    public void onChangedOperationMode(String newOperationMode) {
        if (this.tcpServer != null) {
            this.tcpServer.sendMessage("opMode:" + newOperationMode);
        }
    }

    @Override
    public void onChangedWorkState(String newWorkState) {
    }

    @Override
    public void onChangedErrorState(String newWorkState) {
    }
}

