/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.sqlproxy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.basyx.tools.sql.query.DynamicSQLQuery;
import org.eclipse.basyx.tools.sql.query.DynamicSQLUpdate;
import org.eclipse.basyx.tools.sqlproxy.SQLCollection;
import org.eclipse.basyx.tools.sqlproxy.SQLConnector;
import org.eclipse.basyx.tools.sqlproxy.SQLMap;

public class SQLRootElement
extends SQLConnector {
    public SQLRootElement(String user, String pass, String url, String driver, String prefix, String tableID) {
        super(user, pass, url, driver, prefix, tableID);
    }

    public void createRootTableIfNotExists() {
        this.createSchema();
        this.createRootTable();
    }

    public void drop() {
        this.dropRootTable();
        this.dropSchema();
    }

    public int getNextIdentifier() {
        Map<String, Object> sqlResult = this.readCurrentElementPointer();
        int elementId = (Integer)sqlResult.get("NextElementID");
        String updateString = "UPDATE elements." + this.getSqlTableID() + " SET NextElementID=" + (elementId + 1) + ", ElementPrefix='" + sqlResult.get("ElementPrefix") + "'";
        DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(this.getDriver(), updateString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        dynUpdate.accept((Map<String, Object>)parameter);
        return elementId;
    }

    private Map<String, Object> readCurrentElementPointer() {
        String queryString = "SELECT * FROM elements." + this.getSqlTableID();
        DynamicSQLQuery dynQuery = new DynamicSQLQuery(this.getDriver(), queryString, "mapArray(NextElementID:Integer,ElementPrefix:String)");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        return (Map)dynQuery.get(parameter);
    }

    protected void createSchema() {
        String sqlCommandString = "CREATE SCHEMA IF NOT EXISTS elements;";
        DynamicSQLUpdate dynCmd = new DynamicSQLUpdate(this.getDriver(), sqlCommandString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        dynCmd.accept((Map<String, Object>)parameter);
    }

    protected void dropSchema() {
        String sqlCommandString = "DROP SCHEMA IF EXISTS elements RESTRICT;";
        DynamicSQLUpdate dynCmd = new DynamicSQLUpdate(this.getDriver(), sqlCommandString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        dynCmd.accept((Map<String, Object>)parameter);
    }

    protected void createRootTable() {
        String sqlCommandString = "CREATE TABLE IF NOT EXISTS elements." + this.getSqlTableID() + " (NextElementID int, ElementPrefix varchar(255));";
        DynamicSQLUpdate dynCmd = new DynamicSQLUpdate(this.getDriver(), sqlCommandString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        dynCmd.accept((Map<String, Object>)parameter);
        Map<String, Object> currentPointer = this.readCurrentElementPointer();
        if (!currentPointer.containsKey("NextElementID")) {
            String sqlInsertString = "INSERT INTO elements." + this.getSqlTableID() + " (NextElementID, ElementPrefix) VALUES (1, '" + this.getSqlTableID() + ":')";
            DynamicSQLUpdate dynUpdate = new DynamicSQLUpdate(this.getDriver(), sqlInsertString);
            parameter.clear();
            dynUpdate.accept((Map<String, Object>)parameter);
        }
    }

    public SQLMap createMap(int elementID) {
        String sqlCommandString = "CREATE TABLE IF NOT EXISTS elements." + this.getSqlTableID() + "__" + elementID + " (name text, type int, value text);";
        DynamicSQLUpdate dynCmd = new DynamicSQLUpdate(this.getDriver(), sqlCommandString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        dynCmd.accept((Map<String, Object>)parameter);
        return new SQLMap(this, elementID);
    }

    public SQLCollection createCollection(int elementID) {
        String sqlCommandString = "CREATE TABLE IF NOT EXISTS elements." + this.getSqlTableID() + "__" + elementID + " (type int, value text);";
        DynamicSQLUpdate dynCmd = new DynamicSQLUpdate(this.getDriver(), sqlCommandString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        dynCmd.accept((Map<String, Object>)parameter);
        return new SQLCollection(this, elementID);
    }

    private Set<String> getContainedTables() {
        String queryString = "SELECT table_name FROM information_schema.tables WHERE table_type = 'BASE TABLE' AND table_schema = 'elements' AND table_name LIKE '" + this.getSqlTableID() + "__%';";
        DynamicSQLQuery dynQuery = new DynamicSQLQuery(this.getDriver(), queryString, "stringArray(table_name:String)");
        Collection tableNames = (Collection)dynQuery.get(new HashMap<String, Object>());
        return tableNames.stream().map(name -> "elements." + name).collect(Collectors.toSet());
    }

    protected void dropRootTable() {
        Set<String> containedTables = this.getContainedTables();
        containedTables.add("elements." + this.getSqlTableID());
        String sqlCommandString = "DROP TABLE IF EXISTS " + String.join((CharSequence)",", containedTables) + ";";
        DynamicSQLUpdate dynCmd = new DynamicSQLUpdate(this.getDriver(), sqlCommandString);
        dynCmd.accept((Map<String, Object>)new HashMap<String, Object>());
    }

    public void dropTable(int elementID) {
        String sqlCommandString = "DROP TABLE IF EXISTS elements." + this.getSqlTableID() + "__" + elementID + ";";
        DynamicSQLUpdate dynCmd = new DynamicSQLUpdate(this.getDriver(), sqlCommandString);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        dynCmd.accept((Map<String, Object>)parameter);
    }

    public SQLMap retrieveRootMap() {
        Map<String, Object> currentPointer = this.readCurrentElementPointer();
        int elementId = (Integer)currentPointer.get("NextElementID");
        if (elementId == 1) {
            return this.createMap(this.getNextIdentifier());
        }
        return new SQLMap(this, 1);
    }
}

