/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.net.SocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.protocol.ConnectionClosingTicker;
import org.apache.qpid.server.protocol.v0_10.AMQPConnection_0_10;
import org.apache.qpid.server.protocol.v0_10.ConnectionInvoker;
import org.apache.qpid.server.protocol.v0_10.FrameSizeObserver;
import org.apache.qpid.server.protocol.v0_10.ProtocolEventSender;
import org.apache.qpid.server.protocol.v0_10.ServerConnectionDelegate;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.protocol.v0_10.transport.Binary;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionClose;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionCloseCode;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionCloseOk;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionException;
import org.apache.qpid.server.protocol.v0_10.transport.ExecutionErrorCode;
import org.apache.qpid.server.protocol.v0_10.transport.ExecutionException;
import org.apache.qpid.server.protocol.v0_10.transport.MessageTransfer;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.Option;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolEvent;
import org.apache.qpid.server.protocol.v0_10.transport.SessionDetachCode;
import org.apache.qpid.server.protocol.v0_10.transport.SessionDetached;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.transport.network.NetworkConnection;
import org.apache.qpid.server.transport.network.Ticker;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnection
extends ConnectionInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConnection.class);
    private final Broker<?> _broker;
    private final long _connectionId;
    private final Object _reference = new Object();
    private final AmqpPort<?> _port;
    private final AtomicLong _lastIoTime = new AtomicLong();
    private final Map<Binary, ServerSession> sessions = new HashMap<Binary, ServerSession>();
    private final Map<Integer, ServerSession> channels = new ConcurrentHashMap<Integer, ServerSession>();
    private final Object lock = new Object();
    private final AtomicBoolean connectionLost = new AtomicBoolean(false);
    private boolean _blocking;
    private final Transport _transport;
    private final Queue<Action<? super ServerConnection>> _asyncTaskList = new ConcurrentLinkedQueue<Action<? super ServerConnection>>();
    private final AMQPConnection_0_10 _amqpConnection;
    private boolean _ignoreFutureInput;
    private boolean _ignoreAllButConnectionCloseOk;
    private NetworkConnection _networkConnection;
    private FrameSizeObserver _frameSizeObserver;
    private ServerConnectionDelegate delegate;
    private ProtocolEventSender sender;
    private State state = State.NEW;
    private int _channelMax = 1;
    private String locale;
    private SocketAddress _remoteAddress;
    private int _heartBeatDelay;
    private volatile int _connectionCloseCode;
    private volatile String _connectionCloseMessage;

    public ServerConnection(long connectionId, Broker<?> broker, AmqpPort<?> port, Transport transport, AMQPConnection_0_10 serverProtocolEngine) {
        this._connectionId = connectionId;
        this._broker = broker;
        this._port = port;
        this._transport = transport;
        this._amqpConnection = serverProtocolEngine;
    }

    public Object getReference() {
        return this._reference;
    }

    public Broker<?> getBroker() {
        return this._broker;
    }

    @Override
    protected void invoke(Method method) {
        if (method.isConnectionControl()) {
            method.setChannel(0);
        }
        this.send(method);
        if (!method.isBatch()) {
            this.flush();
        }
        if (method instanceof ConnectionClose) {
            this._ignoreAllButConnectionCloseOk = true;
        }
    }

    EventLogger getEventLogger() {
        return this._amqpConnection.getEventLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(State state) {
        Object object = this.lock;
        synchronized (object) {
            this.state = state;
            this.lock.notifyAll();
        }
        if (state == State.CLOSING) {
            long timeoutTime = System.currentTimeMillis() + (Long)this.getAmqpConnection().getContextValue(Long.class, "connection.closeResponseTimeout");
            this.getAmqpConnection().getAggregateTicker().addTicker((Ticker)new ConnectionClosingTicker(timeoutTime, (ServerNetworkConnection)this.getNetworkConnection()));
            this.getAmqpConnection().notifyWork();
        }
    }

    public ServerConnectionDelegate getConnectionDelegate() {
        return this.delegate;
    }

    public AMQPConnection_0_10 getAmqpConnection() {
        return this._amqpConnection;
    }

    public NamedAddressSpace getAddressSpace() {
        return this._amqpConnection.getAddressSpace();
    }

    public void setVirtualHost(NamedAddressSpace addressSpace) {
        addressSpace.registerConnection((AMQPConnection)this._amqpConnection);
        this._amqpConnection.setAddressSpace(addressSpace);
    }

    public AmqpPort<?> getPort() {
        return this._port;
    }

    public Transport getTransport() {
        return this._transport;
    }

    public void closeSessionAsync(final ServerSession session, AMQPConnection.CloseReason reason, final String message) {
        int cause;
        switch (reason) {
            case MANAGEMENT: {
                cause = 320;
                break;
            }
            case TRANSACTION_TIMEOUT: {
                cause = 506;
                break;
            }
            default: {
                cause = 541;
            }
        }
        this.addAsyncTask((Action<? super ServerConnection>)new Action<ServerConnection>(){

            public void performAction(ServerConnection conn) {
                if (!session.isClosing()) {
                    ExecutionException ex = new ExecutionException();
                    ExecutionErrorCode code = ExecutionErrorCode.INTERNAL_ERROR;
                    try {
                        code = ExecutionErrorCode.get(cause);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    ex.setErrorCode(code);
                    ex.setDescription(message);
                    session.invoke(ex);
                    session.close(cause, message);
                }
            }
        });
    }

    public void exception(Throwable t) {
        try {
            this.exception(new ConnectionException(t));
        }
        finally {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof ServerScopedRuntimeException) {
                throw (ServerScopedRuntimeException)t;
            }
        }
    }

    public void received(ProtocolEvent event) {
        this._lastIoTime.set(System.currentTimeMillis());
        if (!this._ignoreAllButConnectionCloseOk || event instanceof ConnectionCloseOk) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("RECV: [{}] {}", (Object)this, (Object)String.valueOf(event));
            }
            event.delegate(this, this.delegate);
        } else if (event instanceof MessageTransfer) {
            ((MessageTransfer)event).dispose();
        }
    }

    void sendConnectionCloseAsync(final ConnectionCloseCode replyCode, final String message) {
        this.addAsyncTask((Action<? super ServerConnection>)new Action<ServerConnection>(){

            public void performAction(ServerConnection object) {
                if (!ServerConnection.this.isClosing()) {
                    ServerConnection.this.markAllSessionsClosed();
                    ServerConnection.this.setState(State.CLOSING);
                    ServerConnection.this.sendConnectionClose(replyCode, message, new Option[0]);
                }
            }
        });
    }

    protected void performDeleteTasks() {
        this._amqpConnection.performDeleteTasks();
    }

    public synchronized void block() {
        if (!this._blocking) {
            this._blocking = true;
            for (ServerSession serverSession : this.getSessionModels()) {
                serverSession.block();
            }
        }
    }

    public synchronized void unblock() {
        if (this._blocking) {
            this._blocking = false;
            for (ServerSession serverSession : this.getSessionModels()) {
                serverSession.unblock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerSession(ServerSession ssn) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.put(ssn.getName(), ssn);
        }
        if (this._blocking) {
            ssn.block();
        }
    }

    public Collection<? extends ServerSession> getSessionModels() {
        return Collections.unmodifiableCollection(this.getChannels());
    }

    protected Collection<ServerSession> getChannels() {
        return new ArrayList<ServerSession>(this.channels.values());
    }

    public void setAuthorizedSubject(Subject authorizedSubject) {
        this._amqpConnection.setSubject(authorizedSubject);
    }

    public Principal getAuthorizedPrincipal() {
        return this._amqpConnection.getAuthorizedPrincipal();
    }

    public long getConnectionId() {
        return this._connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        try {
            this.performDeleteTasks();
            if (this.state == State.OPEN) {
                this.exception(new ConnectionException("connection aborted"));
            }
            LOGGER.debug("connection closed: {}", (Object)this);
            Object object = this.lock;
            synchronized (object) {
                ArrayList<ServerSession> values = new ArrayList<ServerSession>(this.channels.values());
                for (ServerSession ssn : values) {
                    ssn.closed();
                }
                try {
                    this.sender.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sender = null;
                this.setState(State.CLOSED);
            }
        }
        finally {
            NamedAddressSpace addressSpace = this.getAddressSpace();
            if (addressSpace != null) {
                addressSpace.deregisterConnection((AMQPConnection)this._amqpConnection);
            }
        }
    }

    private void markAllSessionsClosed() {
        for (ServerSession ssn : this.getChannels()) {
            ssn.setClose(true);
            ssn.closed();
        }
    }

    public void receivedComplete() {
        for (ServerSession ssn : this.getChannels()) {
            ssn.receivedComplete();
        }
    }

    public void send(ProtocolEvent event) {
        ProtocolEventSender s;
        this._lastIoTime.set(System.currentTimeMillis());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SEND: [{}] {}", (Object)this, (Object)String.valueOf(event));
        }
        if ((s = this.sender) == null) {
            throw new ConnectionException("connection closed");
        }
        s.send(event);
    }

    public int getSessionCountLimit() {
        return this.getChannelMax();
    }

    void addAsyncTask(Action<? super ServerConnection> action) {
        this._asyncTaskList.add(action);
        this.getAmqpConnection().notifyWork();
    }

    public int getMessageCompressionThreshold() {
        return this._amqpConnection.getMessageCompressionThreshold();
    }

    public int getMaxMessageSize() {
        return (int)Math.min(this._amqpConnection.getMaxMessageSize(), Integer.MAX_VALUE);
    }

    public void transportStateChanged() {
        for (ServerSession serverSession : this.getSessionModels()) {
            serverSession.getModelObject().transportStateChanged();
        }
    }

    public Iterator<Runnable> processPendingIterator(Set<AMQPSession<?, ?>> sessionsWithWork) {
        return new ProcessPendingIterator(sessionsWithWork);
    }

    public void setConnectionDelegate(ServerConnectionDelegate delegate) {
        this.delegate = delegate;
    }

    public ProtocolEventSender getSender() {
        return this.sender;
    }

    public void setSender(ProtocolEventSender sender) {
        this.sender = sender;
    }

    protected void setLocale(String locale) {
        this.locale = locale;
    }

    String getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(ServerSession ssn) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.remove(ssn.getName());
        }
    }

    public void flush() {
        ProtocolEventSender theSender;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("FLUSH: [{}]", (Object)this);
        }
        if ((theSender = this.sender) != null) {
            theSender.flush();
        }
    }

    public void dispatch(Method method) {
        int channel = method.getChannel();
        ServerSession ssn = this.getSession(channel);
        if (ssn != null) {
            ssn.received(method);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Control received on unattached channel : {}", (Object)channel);
            }
            this.invokeSessionDetached(channel, SessionDetachCode.NOT_ATTACHED);
        }
    }

    public int getChannelMax() {
        return this._channelMax;
    }

    protected void setChannelMax(int max) {
        this._channelMax = max;
    }

    private int map(ServerSession ssn) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.getChannelMax(); ++i) {
                if (this.channels.containsKey(i)) continue;
                this.map(ssn, i);
                return i;
            }
            throw new RuntimeException("no more channels available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void map(ServerSession ssn, int channel) {
        Object object = this.lock;
        synchronized (object) {
            this.channels.put(channel, ssn);
            ssn.setChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmap(ServerSession ssn) {
        Object object = this.lock;
        synchronized (object) {
            this.channels.remove(ssn.getChannel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession getSession(int channel) {
        Object object = this.lock;
        synchronized (object) {
            return this.channels.get(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            for (ServerSession ssn : this.sessions.values()) {
                this.map(ssn);
                ssn.resume();
            }
            this.setState(State.OPEN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(ConnectionException e) {
        this.connectionLost.set(true);
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case OPENING: 
                case CLOSING: {
                    this.lock.notifyAll();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCode(ConnectionClose close) {
        Object object = this.lock;
        synchronized (object) {
            ConnectionCloseCode code = close.getReplyCode();
            if (code != ConnectionCloseCode.NORMAL) {
                this.exception(new ConnectionException(close));
            }
        }
    }

    protected void sendConnectionClose(ConnectionCloseCode replyCode, String replyText, Option ... _options) {
        this.connectionClose(replyCode, replyText, _options);
    }

    public String toString() {
        return String.format("conn:%x", System.identityHashCode(this));
    }

    protected boolean isConnectionLost() {
        return this.connectionLost.get();
    }

    public boolean hasSessionWithName(byte[] name) {
        return this.sessions.containsKey(new Binary(name));
    }

    public SocketAddress getRemoteSocketAddress() {
        return this._remoteAddress;
    }

    protected void setRemoteAddress(SocketAddress remoteAddress) {
        this._remoteAddress = remoteAddress;
    }

    private void invokeSessionDetached(int channel, SessionDetachCode sessionDetachCode) {
        SessionDetached sessionDetached = new SessionDetached();
        sessionDetached.setChannel(channel);
        sessionDetached.setCode(sessionDetachCode);
        this.invoke(sessionDetached);
    }

    protected void doHeartBeat() {
        this.connectionHeartbeat(new Option[0]);
    }

    public void setNetworkConnection(NetworkConnection network) {
        this._networkConnection = network;
    }

    public NetworkConnection getNetworkConnection() {
        return this._networkConnection;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        if (this._frameSizeObserver != null) {
            this._frameSizeObserver.setMaxFrameSize(maxFrameSize);
        }
    }

    public void addFrameSizeObserver(final FrameSizeObserver frameSizeObserver) {
        if (this._frameSizeObserver == null) {
            this._frameSizeObserver = frameSizeObserver;
        } else {
            final FrameSizeObserver currentObserver = this._frameSizeObserver;
            this._frameSizeObserver = new FrameSizeObserver(){

                @Override
                public void setMaxFrameSize(int frameSize) {
                    currentObserver.setMaxFrameSize(frameSize);
                    frameSizeObserver.setMaxFrameSize(frameSize);
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosing() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == State.CLOSING || this.state == State.CLOSED;
        }
    }

    protected void sendConnectionSecure(byte[] challenge, Option ... options) {
        super.connectionSecure(challenge, options);
    }

    protected void sendConnectionTune(int channelMax, int maxFrameSize, int heartbeatMin, int heartbeatMax, Option ... options) {
        super.connectionTune(channelMax, maxFrameSize, heartbeatMin, heartbeatMax, options);
    }

    protected void sendConnectionStart(Map<String, Object> clientProperties, List<Object> mechanisms, List<Object> locales, Option ... options) {
        super.connectionStart(clientProperties, mechanisms, locales, options);
    }

    public void setHeartBeatDelay(int heartBeatDelay) {
        this._heartBeatDelay = heartBeatDelay;
    }

    public int getHeartBeatDelay() {
        return this._heartBeatDelay;
    }

    public void closeAndIgnoreFutureInput() {
        this._ignoreFutureInput = true;
        this.getSender().close();
    }

    public boolean isIgnoreFutureInput() {
        return this._ignoreFutureInput;
    }

    void setConnectionCloseCause(AMQPConnection.CloseReason reason, String description) {
        int cause;
        switch (reason) {
            case MANAGEMENT: {
                cause = 320;
                break;
            }
            case TRANSACTION_TIMEOUT: {
                cause = 506;
                break;
            }
            default: {
                cause = 541;
            }
        }
        this._connectionCloseCode = cause;
        this._connectionCloseMessage = description;
    }

    int getConnectionCloseCode() {
        return this._connectionCloseCode;
    }

    String getConnectionCloseMessage() {
        return this._connectionCloseMessage;
    }

    private class ProcessPendingIterator
    implements Iterator<Runnable> {
        private final Collection<AMQPSession<?, ?>> _sessionsWithPending;
        private Iterator<? extends AMQPSession<?, ?>> _sessionIterator;

        private ProcessPendingIterator(Set<AMQPSession<?, ?>> sessionsWithWork) {
            this._sessionsWithPending = sessionsWithWork;
            this._sessionIterator = this._sessionsWithPending.iterator();
        }

        @Override
        public boolean hasNext() {
            return !this._sessionsWithPending.isEmpty() && !ServerConnection.this.isClosing() && !ServerConnection.this._amqpConnection.isConnectionStopped() || !ServerConnection.this._asyncTaskList.isEmpty();
        }

        @Override
        public Runnable next() {
            if (!this._sessionsWithPending.isEmpty()) {
                if (ServerConnection.this.isClosing() || ServerConnection.this._amqpConnection.isConnectionStopped()) {
                    final Action<? super ServerConnection> asyncAction = ServerConnection.this._asyncTaskList.poll();
                    if (asyncAction != null) {
                        return new Runnable(){

                            @Override
                            public void run() {
                                asyncAction.performAction((Object)ServerConnection.this);
                            }
                        };
                    }
                    return new Runnable(){

                        @Override
                        public void run() {
                        }
                    };
                }
                if (!this._sessionIterator.hasNext()) {
                    this._sessionIterator = this._sessionsWithPending.iterator();
                }
                final AMQPSession<?, ?> session = this._sessionIterator.next();
                return new Runnable(){

                    @Override
                    public void run() {
                        ProcessPendingIterator.this._sessionIterator.remove();
                        if (session.processPending()) {
                            ProcessPendingIterator.this._sessionsWithPending.add(session);
                        }
                    }
                };
            }
            if (!ServerConnection.this._asyncTaskList.isEmpty()) {
                final Action<? super ServerConnection> asyncAction = ServerConnection.this._asyncTaskList.poll();
                return new Runnable(){

                    @Override
                    public void run() {
                        asyncAction.performAction((Object)ServerConnection.this);
                    }
                };
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum State {
        NEW,
        CLOSED,
        OPENING,
        OPEN,
        CLOSING,
        CLOSE_RCVD,
        RESUMING;

    }
}

