/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.types.softwareNameplate.SoftwareNameplateBuilder;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.TechnicalDataBuilder;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ApplicationSetup;
import de.iip_ecosphere.platform.support.iip_aas.IipVersion;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class PlatformAas
implements AasContributor {
    public static final String NAME_SUBMODEL = "platform";
    public static final String SUBMODEL_NAMEPLATE = "TechnicalData";
    public static final String NAME_PROPERTY_NAME = "name";
    public static final String NAME_PROPERTY_VERSION = "version";
    public static final String NAME_PROPERTY_RELEASE = "isRelease";
    public static final String NAME_PROPERTY_BUILDID = "buildId";
    public static final String NAME_OPERATION_SNAPSHOTAAS = "snapshotAas";
    public static final String NAME_OPERATION_RESOLVE_SEMANTICID = "resolveSemanticId";
    public static final String NAME_PROPERTY_ID = "Id";
    public static final String NAME_PROPERTY_PRODUCTIMAGE = "ProductImage";
    public static final String NAME_PROPERTY_MANUFACTURER_LOGO = "ManufacturerLogo";
    public static final String NAME_PROPERTY_MANUFACTURER_NAME = "ManufacturerName";
    public static final String NAME_PROPERTY_MANUFACTURER_PRODUCT_DESIGNATION = "ManufacturerProductDesignation";
    public static final String NAME_SMC_ADDRESS = "Address";
    public static final String NAME_PROPERTY_CITYTOWN = "CityTown";
    public static final String NAME_PROPERTY_DEPARTMENT = "Department";
    public static final String NAME_PROPERTY_STREET = "Street";
    public static final String NAME_PROPERTY_ZIPCODE = "ZipCode";
    private static ResourceResolver imageResolver = AasUtils.CLASSPATH_RESOURCE_RESOLVER;

    public static void setImageResolver(ResourceResolver resolver) {
        if (null != resolver) {
            imageResolver = resolver;
        }
    }

    public static ResourceResolver getImageResolver() {
        return imageResolver;
    }

    @Override
    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        AuthenticationDescriptor auth = this.getSubmodelAuthentication();
        Submodel.SubmodelBuilder smB = AasPartRegistry.createSubmodelBuilderRbac(aasBuilder, NAME_SUBMODEL);
        if (smB.isNew()) {
            IipVersion versionInfo = IipVersion.getInstance();
            ApplicationSetup setup = new ApplicationSetup();
            setup.setVersion(versionInfo.getVersion());
            setup.setName("oktoflow platform");
            setup.setManufacturerName("oktoflow team@de");
            setup.setManufacturerLogo("IIP-Ecosphere-Logo.png");
            setup.setProductImage("IIP-Ecosphere-Platform.png");
            setup.setDescription("The oktoflow AI-enabled I4.0 platform.@de");
            ApplicationSetup.Address addr = new ApplicationSetup.Address();
            addr.setDepartment("University of Hildesheim, SSE - Software Systems Engineering@de");
            addr.setStreet("Universit\u00e4tsplatz 1@de");
            addr.setZipCode("31141@de");
            addr.setCityTown("Hildesheim/Hannover@de");
            setup.setAddress(addr);
            Submodel.SubmodelBuilder smBuilder = PlatformAas.createNameplate(aasBuilder, setup, AasPartRegistry.composeIdentifier("TD"));
            PlatformAas.addSoftwareInfo(smBuilder, setup);
            smBuilder.build();
            this.createSoftwareNameplate(aasBuilder, setup, versionInfo, AasPartRegistry.composeIdentifier("SW"));
            PlatformAas.addSoftwareInfo(smB, setup);
            smB.createPropertyBuilder(NAME_PROPERTY_RELEASE).setValue(Type.BOOLEAN, (Object)versionInfo.isRelease()).build(auth);
            smB.createPropertyBuilder(NAME_PROPERTY_BUILDID).setValue(Type.STRING, (Object)versionInfo.getBuildId()).setSemanticId("irdi:0173-1#02-ABF809#001").build(auth);
            smB.createOperationBuilder(NAME_OPERATION_SNAPSHOTAAS).addInputVariable("id", Type.STRING).setInvocable(iCreator.createInvocable(NAME_OPERATION_SNAPSHOTAAS)).build(Type.STRING, auth);
            smB.createOperationBuilder(NAME_OPERATION_RESOLVE_SEMANTICID).addInputVariable("semanticId", Type.STRING).setInvocable(iCreator.createInvocable(NAME_OPERATION_RESOLVE_SEMANTICID)).build(Type.STRING, auth);
            smB.build();
        }
        return null;
    }

    public static void addSoftwareInfo(Submodel.SubmodelBuilder smB, ApplicationSetup appSetup) {
        if (null != appSetup.getId()) {
            smB.createPropertyBuilder(NAME_PROPERTY_ID).setValue(Type.STRING, (Object)appSetup.getId()).setSemanticId("irdi:0173-1#02-ABF809#001").build();
        }
        smB.createPropertyBuilder(NAME_PROPERTY_NAME).setValue(Type.STRING, (Object)appSetup.getName()).setSemanticId("irdi:0173-1#02-AAO247#002").build();
        smB.createPropertyBuilder(NAME_PROPERTY_VERSION).setValue(Type.STRING, (Object)(null == appSetup.getVersion() ? "" : appSetup.getVersion().toString())).setSemanticId("irdi:0173-1#02-AAM737#002").build();
    }

    public static Submodel.SubmodelBuilder createNameplate(Aas.AasBuilder aasBuilder, ApplicationSetup appSetup, String identifier) {
        TechnicalDataBuilder tdBuilder = new TechnicalDataBuilder(aasBuilder, identifier);
        tdBuilder.rbacPlatform(AasPartRegistry.getSubmodelAuthentication());
        TechnicalDataBuilder.GeneralInformationBuilder giBuilder = tdBuilder.createGeneralInformationBuilder().setManufacturerName(appSetup.getManufacturerName()).setManufacturerArticleNumber("oktoflow").setManufacturerOrderCode("oktoflow").setManufacturerProductDesignation(new LangString[]{LangString.create((String)appSetup.getManufacturerProductDesignation())});
        PlatformAas.createAddress((SubmodelElementContainerBuilder)giBuilder, appSetup.getAddress());
        AasUtils.resolveImage((String)appSetup.getProductImage(), (ResourceResolver)AasUtils.CLASSPATH_RESOURCE_RESOLVER, (boolean)false, (n, r, m) -> giBuilder.setProductImage(r, m));
        AasUtils.resolveImage((String)appSetup.getManufacturerLogo(), (ResourceResolver)AasUtils.CLASSPATH_RESOURCE_RESOLVER, (boolean)true, (n, r, m) -> giBuilder.setManufacturerLogo(r, m));
        giBuilder.build();
        GregorianCalendar now = new GregorianCalendar();
        TechnicalDataBuilder.FurtherInformationBuilder fiBuilder = tdBuilder.createFurtherInformationBuilder().setValidDate(now.getTime());
        fiBuilder.build();
        tdBuilder.createTechnicalPropertiesBuilder().build();
        tdBuilder.createProductClassificationsBuilder().build();
        tdBuilder.build();
        AasUtils.resolveImage((String)appSetup.getProductImage(), (ResourceResolver)imageResolver, (boolean)true, (n, r, m) -> tdBuilder.createFileDataElementBuilder(NAME_PROPERTY_PRODUCTIMAGE, r, m).setSemanticId("iri:https://admin-shell.io/ZVEI/TechnicalData/ProductImage/1/1").build());
        AasUtils.resolveImage((String)appSetup.getManufacturerLogo(), (ResourceResolver)imageResolver, (boolean)true, (n, r, m) -> tdBuilder.createFileDataElementBuilder(NAME_PROPERTY_MANUFACTURER_LOGO, r, m).setSemanticId("iri:https://admin-shell.io/ZVEI/TechnicalData/ManufacturerLogo/1/1").build());
        tdBuilder.createPropertyBuilder(NAME_PROPERTY_MANUFACTURER_NAME).setValue(Type.LANG_STRING, (Object)appSetup.getManufacturerName()).setSemanticId("iri:https://admin-shell.io/ZVEI/TechnicalData/ManufacturerName/1/1").build();
        tdBuilder.createPropertyBuilder(NAME_PROPERTY_MANUFACTURER_PRODUCT_DESIGNATION).setValue(Type.LANG_STRING, (Object)appSetup.getManufacturerProductDesignation()).setSemanticId("iri:https://admin-shell.io/ZVEI/TechnicalData/ManufacturerProductDesignation/1/1").build();
        PlatformAas.createAddress((SubmodelElementContainerBuilder)tdBuilder, appSetup.getAddress());
        return tdBuilder;
    }

    private void createSoftwareNameplate(Aas.AasBuilder aasBuilder, ApplicationSetup appSetup, IipVersion versionInfo, String identification) {
        String version = null == appSetup.getVersion() ? "" : appSetup.getVersion().toString();
        Date buildDate = new Date(0L);
        if (versionInfo.isBuildIdSet()) {
            try {
                buildDate = new Date(Long.parseLong(versionInfo.getBuildId()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        SoftwareNameplateBuilder snBuilder = new SoftwareNameplateBuilder(aasBuilder, identification);
        snBuilder.rbacPlatform(this.getSubmodelAuthentication());
        snBuilder.createSoftwareNameplate_TypeBuilder().setManufacturerName(new LangString[]{LangString.create((String)appSetup.getManufacturerName())}).setVersion(version).setVersionName(new LangString[]{LangString.create((String)(version + " " + (versionInfo.isRelease() ? "release" : "snapshot")))}).setBuildDate(buildDate).setURIOfTheProduct("https://oktoflow.de").setSoftwareType("I4.0 platform").setReleaseNotes(new LangString[]{LangString.create((String)"-")}).setReleaseDate(buildDate).setManufacturerProductType(new LangString[]{LangString.create((String)"I4.0 platform")}).setManufacturerProductFamily(new LangString[]{LangString.create((String)NAME_SUBMODEL)}).setManufacturerProductDesignation(new LangString[]{LangString.create((String)"I4.0 platform")}).setManufacturerProductDescription(new LangString[]{LangString.create((String)"Open Source I4.0 platform")}).setInstallerType("mvn/EASy-Producer").setInstallationURI("https://oktoflow.de").setInstallationFile("platform.jar", "application/java-archive").setInstallationChecksum("").build();
        snBuilder.build();
    }

    public static void createAddress(SubmodelElementContainerBuilder smBuilder, ApplicationSetup.Address address) {
        if (null != address) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder aBuilder = smBuilder.createSubmodelElementCollectionBuilder(NAME_SMC_ADDRESS);
            aBuilder.createPropertyBuilder(NAME_PROPERTY_CITYTOWN).setValue(Type.LANG_STRING, (Object)address.getCityTown()).build();
            aBuilder.createPropertyBuilder(NAME_PROPERTY_DEPARTMENT).setValue(Type.LANG_STRING, (Object)address.getDepartment()).build();
            aBuilder.createPropertyBuilder(NAME_PROPERTY_STREET).setValue(Type.LANG_STRING, (Object)address.getStreet()).build();
            aBuilder.createPropertyBuilder(NAME_PROPERTY_ZIPCODE).setValue(Type.LANG_STRING, (Object)address.getZipCode()).build();
            aBuilder.build();
        }
    }

    @Override
    public void contributeTo(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(NAME_OPERATION_SNAPSHOTAAS, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> PlatformAas.snapshotAas(AasUtils.readString((Object[])p))));
        sBuilder.defineOperation(NAME_OPERATION_RESOLVE_SEMANTICID, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> JsonUtils.toJson((Object)SemanticIdResolver.resolve((String)AasUtils.readString((Object[])p)))));
    }

    static String snapshotAas(String id) throws ExecutionException {
        String result = "";
        List<Aas> aas = AasPartRegistry.getIipAasInstance();
        if (null != aas) {
            Object name = "platform-";
            if (null != id && id.length() > 0) {
                name = (String)name + id + "-";
            }
            name = (String)name + System.currentTimeMillis() + ".aasx";
            try {
                File file = new File(FileUtils.getTempDirectory(), (String)name);
                AasFactory.getInstance().createPersistenceRecipe().writeTo(aas, file);
                result = file.getAbsolutePath();
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
        } else {
            throw new ExecutionException("No suitable AAS instance available. Cannot write AAS.", null);
        }
        return result;
    }

    @Override
    public AasContributor.Kind getKind() {
        return AasContributor.Kind.ACTIVE;
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

