/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.io.File;
import jetbrains.exodus.crypto.KryptKt;
import jetbrains.exodus.entitystore.MetaServer;
import jetbrains.exodus.env.ContextualEnvironment;
import jetbrains.exodus.env.ContextualEnvironmentImpl;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogConfig;
import org.jetbrains.annotations.NotNull;

public final class Environments {
    private Environments() {
    }

    @NotNull
    public static Environment newInstance(@NotNull String dir, @NotNull String subDir, @NotNull EnvironmentConfig ec) {
        return Environments.prepare(new EnvironmentImpl(Environments.newLogInstance(new File(dir, subDir), ec), ec));
    }

    @NotNull
    public static Environment newInstance(@NotNull String dir) {
        return Environments.newInstance(dir, new EnvironmentConfig());
    }

    @NotNull
    public static Environment newInstance(@NotNull Log log, @NotNull EnvironmentConfig ec) {
        return Environments.prepare(new EnvironmentImpl(log, ec));
    }

    @NotNull
    public static Environment newInstance(@NotNull String dir, @NotNull EnvironmentConfig ec) {
        return Environments.prepare(new EnvironmentImpl(Environments.newLogInstance(new File(dir), ec), ec));
    }

    @NotNull
    public static Environment newInstance(@NotNull File dir) {
        return Environments.newInstance(dir, new EnvironmentConfig());
    }

    @NotNull
    public static Environment newInstance(@NotNull File dir, @NotNull EnvironmentConfig ec) {
        return Environments.prepare(new EnvironmentImpl(Environments.newLogInstance(dir, ec), ec));
    }

    @NotNull
    public static Environment newInstance(@NotNull LogConfig config) {
        return Environments.newInstance(config, new EnvironmentConfig());
    }

    @NotNull
    public static Environment newInstance(@NotNull LogConfig config, @NotNull EnvironmentConfig ec) {
        return Environments.prepare(new EnvironmentImpl(Environments.newLogInstance(config, ec), ec));
    }

    @NotNull
    public static ContextualEnvironment newContextualInstance(@NotNull String dir, @NotNull String subDir, @NotNull EnvironmentConfig ec) {
        return Environments.prepare(new ContextualEnvironmentImpl(Environments.newLogInstance(new File(dir, subDir), ec), ec));
    }

    @NotNull
    public static ContextualEnvironment newContextualInstance(@NotNull String dir) {
        return Environments.newContextualInstance(dir, new EnvironmentConfig());
    }

    @NotNull
    public static ContextualEnvironment newContextualInstance(@NotNull String dir, @NotNull EnvironmentConfig ec) {
        return Environments.prepare(new ContextualEnvironmentImpl(Environments.newLogInstance(new File(dir), ec), ec));
    }

    @NotNull
    public static ContextualEnvironment newContextualInstance(@NotNull File dir) {
        return Environments.newContextualInstance(dir, new EnvironmentConfig());
    }

    @NotNull
    public static ContextualEnvironment newContextualInstance(@NotNull File dir, @NotNull EnvironmentConfig ec) {
        return Environments.prepare(new ContextualEnvironmentImpl(Environments.newLogInstance(dir, ec), ec));
    }

    @NotNull
    public static ContextualEnvironment newContextualInstance(@NotNull LogConfig config, @NotNull EnvironmentConfig ec) {
        return Environments.prepare(new ContextualEnvironmentImpl(Environments.newLogInstance(config, ec), ec));
    }

    @NotNull
    public static Log newLogInstance(@NotNull File dir, @NotNull EnvironmentConfig ec) {
        return Environments.newLogInstance(new LogConfig().setDir(dir), ec);
    }

    @NotNull
    public static Log newLogInstance(@NotNull LogConfig config, @NotNull EnvironmentConfig ec) {
        Long maxMemory = ec.getMemoryUsage();
        if (maxMemory != null) {
            config.setMemoryUsage(maxMemory);
        } else {
            config.setMemoryUsagePercentage(ec.getMemoryUsagePercentage());
        }
        return Environments.newLogInstance(config.setFileSize(ec.getLogFileSize()).setLockTimeout(ec.getLogLockTimeout()).setLockId(ec.getLogLockId()).setCachePageSize(ec.getLogCachePageSize()).setCacheOpenFilesCount(ec.getLogCacheOpenFilesCount()).setCacheUseNio(ec.getLogCacheUseNio()).setCacheFreePhysicalMemoryThreshold(ec.getLogCacheFreePhysicalMemoryThreshold()).setDurableWrite(ec.getLogDurableWrite()).setSharedCache(ec.isLogCacheShared()).setNonBlockingCache(ec.isLogCacheNonBlocking()).setCleanDirectoryExpected(ec.isLogCleanDirectoryExpected()).setClearInvalidLog(ec.isLogClearInvalid()).setSyncPeriod(ec.getLogSyncPeriod()).setFullFileReadonly(ec.isLogFullFileReadonly()).setCipherProvider(ec.getCipherId() == null ? null : KryptKt.newCipherProvider((String)ec.getCipherId())).setCipherKey(ec.getCipherKey()).setCipherBasicIV(ec.getCipherBasicIV()));
    }

    @NotNull
    public static Log newLogInstance(@NotNull LogConfig config) {
        return new Log(config);
    }

    @NotNull
    static <T extends EnvironmentImpl> T prepare(@NotNull T env) {
        env.getGC().getUtilizationProfile().load();
        MetaServer metaServer = env.getEnvironmentConfig().getMetaServer();
        if (metaServer != null) {
            metaServer.start(env);
        }
        return env;
    }
}

