/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io.inMemory;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Map;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.LongObjectCache;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.log.LogUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Memory {
    @Nullable
    private Block lastBlock;
    @NotNull
    private final LongHashMap<Block> data = new LongHashMap();
    @NotNull
    private final LongObjectCache<Block> removedBlocks = new LongObjectCache(100);

    protected Collection<Block> getAllBlocks() {
        return this.data.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Block getBlockData(long address) {
        LongHashMap<Block> longHashMap = this.data;
        synchronized (longHashMap) {
            return (Block)this.data.get(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Block getOrCreateBlockData(long address, long length) {
        Block block;
        LongHashMap<Block> longHashMap = this.data;
        synchronized (longHashMap) {
            block = (Block)this.data.get(address);
            if (block == null) {
                int initialSize = this.lastBlock == null ? 2048 : this.lastBlock.getSize();
                this.lastBlock = block = new Block(address, initialSize);
                this.data.put(address, (Object)this.lastBlock);
            } else {
                if ((long)block.getSize() != length) {
                    block.setSize(length);
                }
                this.lastBlock = block;
            }
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeBlock(long blockAddress) {
        boolean result;
        Block removed;
        LongHashMap<Block> longHashMap = this.data;
        synchronized (longHashMap) {
            removed = (Block)this.data.remove(blockAddress);
        }
        boolean bl = result = removed != null;
        if (result) {
            LongHashMap<Block> longHashMap2 = this.data;
            synchronized (longHashMap2) {
                this.removedBlocks.cacheObject(blockAddress, (Object)removed);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        LongHashMap<Block> longHashMap = this.data;
        synchronized (longHashMap) {
            this.data.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(final @NotNull File location) {
        location.mkdirs();
        ObjectProcedure<Map.Entry<Long, Block>> saver = new ObjectProcedure<Map.Entry<Long, Block>>(){

            public boolean execute(Map.Entry<Long, Block> object) {
                try {
                    File dest = new File(location, LogUtil.getLogFilename(object.getKey()));
                    RandomAccessFile output = new RandomAccessFile(dest, "rw");
                    Block block = object.getValue();
                    output.write(block.getData(), 0, block.getSize());
                    output.close();
                }
                catch (IOException e) {
                    throw new ExodusException((Throwable)e);
                }
                return true;
            }
        };
        LongHashMap<Block> longHashMap = this.data;
        synchronized (longHashMap) {
            this.data.forEachEntry((ObjectProcedure)saver);
            this.removedBlocks.forEachEntry((ObjectProcedure)saver);
        }
    }

    static final class Block {
        private final long address;
        private int size;
        private byte[] data;

        Block(long address, int initialSize) {
            this.address = address;
            this.data = new byte[initialSize];
        }

        public long getAddress() {
            return this.address;
        }

        public int getSize() {
            return this.size;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setSize(long size) {
            this.size = (int)size;
        }

        public void write(byte[] b, int off, int len) {
            int newSize = this.size + len;
            this.ensureCapacity(newSize);
            System.arraycopy(b, off, this.data, this.size, len);
            this.size = newSize;
        }

        public int read(byte[] output, long position, int count) {
            long maxRead;
            if (position < 0L || (maxRead = (long)this.size - position) < 0L) {
                throw new ExodusException("Block index out of range");
            }
            if (maxRead < (long)count) {
                count = (int)maxRead;
            }
            System.arraycopy(this.data, (int)position, output, 0, count);
            return count;
        }

        public void ensureCapacity(int minCapacity) {
            int oldCapacity = this.data.length;
            if (minCapacity > oldCapacity) {
                byte[] oldData = this.data;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.data = new byte[newCapacity];
                System.arraycopy(oldData, 0, this.data, 0, oldCapacity);
            }
        }
    }
}

