/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.persistent.PersistentBitTreeLongSet;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongSet;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002*+B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0003J\u0012\u0010$\u001a\u00020\b2\b\b\u0002\u0010%\u001a\u00020\u0012H\u0007J\u0010\u0010&\u001a\u00020'2\b\b\u0002\u0010#\u001a\u00020\u0003J\u0006\u0010(\u001a\u00020)R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u00020\u0003*\u00020\u00038DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\u00020\u0003*\u00020\u00038DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001d\u0082\u0001\u0002,!\u00a8\u0006-"}, d2={"Ljetbrains/exodus/log/LogFileSet;", "", "fileSize", "", "set", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet;", "(JLjetbrains/exodus/core/dataStructures/persistent/PersistentLongSet;)V", "array", "", "getArray", "()[J", "current", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet$ImmutableSet;", "getCurrent", "()Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet$ImmutableSet;", "getFileSize", "()J", "isEmpty", "", "()Z", "maximum", "getMaximum", "()Ljava/lang/Long;", "minimum", "getMinimum", "getSet", "()Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet;", "addressToKey", "getAddressToKey", "(J)J", "keyToAddress", "getKeyToAddress", "beginWrite", "Ljetbrains/exodus/log/LogFileSet$Mutable;", "contains", "fileAddress", "getFiles", "reversed", "getFilesFrom", "Ljetbrains/exodus/core/dataStructures/hash/LongIterator;", "size", "", "Immutable", "Mutable", "Ljetbrains/exodus/log/LogFileSet$Immutable;", "xodus-environment"})
public abstract class LogFileSet {
    private final long fileSize;
    @NotNull
    private final PersistentLongSet set;

    @NotNull
    protected abstract PersistentLongSet.ImmutableSet getCurrent();

    public final int size() {
        return this.getCurrent().size();
    }

    public final boolean isEmpty() {
        return this.getCurrent().isEmpty();
    }

    @Nullable
    public final Long getMinimum() {
        LongIterator longIterator = this.getCurrent().longIterator();
        LongIterator it = longIterator;
        return it.hasNext() ? Long.valueOf(this.getKeyToAddress(it.nextLong())) : null;
    }

    @Nullable
    public final Long getMaximum() {
        LongIterator longIterator = this.getCurrent().reverseLongIterator();
        LongIterator it = longIterator;
        return it.hasNext() ? Long.valueOf(this.getKeyToAddress(it.nextLong())) : null;
    }

    @NotNull
    public final long[] getArray() {
        return this.getFiles(true);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final long[] getFiles(boolean reversed) {
        PersistentLongSet.ImmutableSet current = this.getCurrent();
        long[] result = new long[current.size()];
        LongIterator it = reversed ? current.reverseLongIterator() : current.longIterator();
        int n = 0;
        int n2 = result.length;
        while (n < n2) {
            void i;
            result[i] = this.getKeyToAddress(it.nextLong());
            ++i;
        }
        return result;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ long[] getFiles$default(LogFileSet logFileSet, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFiles");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return logFileSet.getFiles(bl);
    }

    @JvmOverloads
    @NotNull
    public final long[] getFiles() {
        return LogFileSet.getFiles$default(this, false, 1, null);
    }

    public final boolean contains(long fileAddress) {
        return this.getCurrent().contains(this.getAddressToKey(fileAddress));
    }

    @NotNull
    public final LongIterator getFilesFrom(long fileAddress) {
        return new LongIterator(this, fileAddress){
            private final LongIterator it;
            final /* synthetic */ LogFileSet this$0;
            final /* synthetic */ long $fileAddress;

            public final LongIterator getIt() {
                return this.it;
            }

            @NotNull
            public Long next() {
                return this.nextLong();
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public long nextLong() {
                return this.this$0.getKeyToAddress(this.it.nextLong());
            }

            @NotNull
            public Void remove() {
                throw (Throwable)new UnsupportedOperationException();
            }
            {
                this.this$0 = $outer;
                this.$fileAddress = $captured_local_variable$1;
                this.it = $captured_local_variable$1 == 0L ? $outer.getCurrent().longIterator() : $outer.getCurrent().tailLongIterator($outer.getAddressToKey($captured_local_variable$1));
            }
        };
    }

    @NotNull
    public static /* bridge */ /* synthetic */ LongIterator getFilesFrom$default(LogFileSet logFileSet, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFilesFrom");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return logFileSet.getFilesFrom(l);
    }

    @NotNull
    public final Mutable beginWrite() {
        PersistentLongSet persistentLongSet = this.set.getClone();
        Intrinsics.checkExpressionValueIsNotNull((Object)persistentLongSet, (String)"set.clone");
        return new Mutable(this.fileSize, persistentLongSet);
    }

    protected final long getKeyToAddress(long $receiver) {
        return $receiver * this.fileSize;
    }

    protected final long getAddressToKey(long $receiver) {
        return $receiver / this.fileSize;
    }

    public final long getFileSize() {
        return this.fileSize;
    }

    @NotNull
    public final PersistentLongSet getSet() {
        return this.set;
    }

    private LogFileSet(long fileSize, PersistentLongSet set) {
        this.fileSize = fileSize;
        this.set = set;
    }

    public /* synthetic */ LogFileSet(long fileSize, @NotNull PersistentLongSet set, DefaultConstructorMarker $constructor_marker) {
        this(fileSize, set);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/exodus/log/LogFileSet$Immutable;", "Ljetbrains/exodus/log/LogFileSet;", "fileSize", "", "set", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet;", "(JLjetbrains/exodus/core/dataStructures/persistent/PersistentLongSet;)V", "current", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet$ImmutableSet;", "getCurrent", "()Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet$ImmutableSet;", "immutable", "xodus-environment"})
    public static final class Immutable
    extends LogFileSet {
        private final PersistentLongSet.ImmutableSet immutable;

        @Override
        @NotNull
        public PersistentLongSet.ImmutableSet getCurrent() {
            return this.immutable;
        }

        @JvmOverloads
        public Immutable(long fileSize, @NotNull PersistentLongSet set) {
            Intrinsics.checkParameterIsNotNull((Object)set, (String)"set");
            super(fileSize, set, null);
            PersistentLongSet.ImmutableSet immutableSet = set.beginRead();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"set.beginRead()");
            this.immutable = immutableSet;
        }

        @JvmOverloads
        public /* synthetic */ Immutable(long l, PersistentLongSet persistentLongSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                persistentLongSet = (PersistentLongSet)new PersistentBitTreeLongSet(7);
            }
            this(l, persistentLongSet);
        }

        @JvmOverloads
        public Immutable(long fileSize) {
            this(fileSize, null, 2, null);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0003R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/exodus/log/LogFileSet$Mutable;", "Ljetbrains/exodus/log/LogFileSet;", "fileSize", "", "set", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet;", "(JLjetbrains/exodus/core/dataStructures/persistent/PersistentLongSet;)V", "current", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet$ImmutableSet;", "getCurrent", "()Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet$ImmutableSet;", "mutable", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet$MutableSet;", "add", "", "fileAddress", "clear", "endWrite", "Ljetbrains/exodus/log/LogFileSet$Immutable;", "remove", "", "xodus-environment"})
    public static final class Mutable
    extends LogFileSet {
        private final PersistentLongSet.MutableSet mutable;

        @Override
        @NotNull
        protected PersistentLongSet.ImmutableSet getCurrent() {
            return (PersistentLongSet.ImmutableSet)this.mutable;
        }

        public final void clear() {
            this.mutable.clear();
        }

        public final void add(long fileAddress) {
            this.mutable.add(this.getAddressToKey(fileAddress));
        }

        public final boolean remove(long fileAddress) {
            return this.mutable.remove(this.getAddressToKey(fileAddress));
        }

        @NotNull
        public final Immutable endWrite() {
            if (!this.mutable.endWrite()) {
                throw (Throwable)new IllegalStateException("File set can't be updated");
            }
            long l = this.getFileSize();
            PersistentLongSet persistentLongSet = this.getSet().getClone();
            Intrinsics.checkExpressionValueIsNotNull((Object)persistentLongSet, (String)"set.clone");
            return new Immutable(l, persistentLongSet);
        }

        public Mutable(long fileSize, @NotNull PersistentLongSet set) {
            Intrinsics.checkParameterIsNotNull((Object)set, (String)"set");
            super(fileSize, set, null);
            PersistentLongSet.MutableSet mutableSet = set.beginWrite();
            Intrinsics.checkExpressionValueIsNotNull((Object)mutableSet, (String)"set.beginWrite()");
            this.mutable = mutableSet;
        }
    }
}

