/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.FileFormat;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.OperationsProvider;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.SimpleLocalProtocolCreator;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxDeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRegistry;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxServerRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.JsonPersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.VabHttpInvocablesCreator;
import de.iip_ecosphere.platform.support.aas.basyx.VabHttpsInvocablesCreator;
import de.iip_ecosphere.platform.support.aas.basyx.VabOperationsProvider;
import de.iip_ecosphere.platform.support.aas.basyx.VabTcpInvocablesCreator;
import de.iip_ecosphere.platform.support.aas.basyx.XmlPersistenceRecipe;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.SubmodelElementIdShortBlacklist;
import org.eclipse.basyx.vab.coder.json.connector.JSONConnector;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IBaSyxConnector;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnector;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;
import org.eclipse.basyx.vab.protocol.https.HTTPSConnectorProvider;

public abstract class AbstractBaSyxAasFactory
extends AasFactory {
    public static final String PROTOCOL_VAB_TCP = "VAB-TCP";
    public static final String PROTOCOL_VAB_HTTP = "VAB-HTTP";
    public static final String PROTOCOL_VAB_HTTPS = "VAB-HTTPS";
    private final Map<FileFormat, PersistenceRecipe> recipes = new HashMap<FileFormat, PersistenceRecipe>();

    public AbstractBaSyxAasFactory() {
        this.registerProtocolCreator("local", (AasFactory.ProtocolCreator)new SimpleLocalProtocolCreator(){

            protected OperationsProvider createOperationsProvider() {
                return new VabOperationsProvider();
            }
        });
        VabTcpProtocolCreator tcp = new VabTcpProtocolCreator();
        this.registerProtocolCreator("", tcp);
        this.registerProtocolCreator(PROTOCOL_VAB_TCP, tcp);
        this.registerProtocolCreator(PROTOCOL_VAB_HTTP, new VabHttpProtocolCreator());
        this.registerPersistenceRecipe(new XmlPersistenceRecipe());
        this.registerPersistenceRecipe(new JsonPersistenceRecipe());
        this.registerAvailabilityFunction(s -> NetUtils.connectionOk((String)this.getFullRegistryUri(s.getEndpoint())), new SetupSpec.AasComponent[]{SetupSpec.AasComponent.AAS_REGISTRY, SetupSpec.AasComponent.SUBMODEL_REGISTRY});
        this.registerAvailabilityFunction(s -> NetUtils.connectionOk((String)(s.getEndpoint().toUri() + "/health")), new SetupSpec.AasComponent[]{SetupSpec.AasComponent.AAS_REPOSITORY, SetupSpec.AasComponent.SUBMODEL_REPOSITORY});
    }

    protected void registerPersistenceRecipe(PersistenceRecipe recipe) {
        if (null != recipe) {
            for (FileFormat f : recipe.getSupportedFormats()) {
                this.recipes.put(f, recipe);
            }
        }
    }

    public Aas.AasBuilder createAasBuilder(String idShort, String identifier) {
        return new BaSyxAas.BaSyxAasBuilder(idShort, identifier);
    }

    public Submodel.SubmodelBuilder createSubmodelBuilder(String idShort, String identifier) {
        return new BaSyxSubmodel.BaSyxSubmodelBuilder(null, idShort, identifier);
    }

    protected ServerRecipe createDefaultServerRecipe() {
        return new BaSyxServerRecipe();
    }

    public Registry obtainRegistry(SetupSpec spec) throws IOException {
        return this.obtainRegistry(spec, spec.getAasRegistryEndpoint().getSchema());
    }

    public Registry obtainRegistry(SetupSpec spec, Schema aasSchema) throws IOException {
        SetupSpec.ComponentSetup cSetup = spec.getSetup(SetupSpec.AasComponent.AAS_REGISTRY);
        Object cFactory = Schema.HTTPS == aasSchema ? new HTTPSConnectorProvider() : new HTTPConnectorFactory(){

            protected IModelProvider createProvider(String addr) {
                return new JSONConnector((IBaSyxConnector)new HTTPConnector(addr));
            }
        };
        return new BaSyxRegistry(cSetup.getEndpoint(), (IConnectorFactory)cFactory);
    }

    protected String getFullRegistryUri(Endpoint regEndpoint) {
        return regEndpoint.toUri() + "/api/v1/registry";
    }

    public String getServerBaseUri(Endpoint serverEndpoint) {
        return serverEndpoint.toUri() + "/shells";
    }

    public DeploymentRecipe createDeploymentRecipe(SetupSpec spec) {
        return new BaSyxDeploymentRecipe(spec);
    }

    public PersistenceRecipe createPersistenceRecipe() {
        return new BaSyxPersistenceRecipe();
    }

    protected boolean needsIdFix(String id) {
        return SubmodelElementIdShortBlacklist.isBlacklisted((String)id);
    }

    public boolean supportsOperationExecutionAuthorization() {
        return false;
    }

    public boolean supportsSamePorts() {
        return true;
    }

    public boolean supportsUrlPaths() {
        return true;
    }

    public String getMetaModelVersion() {
        return "v2";
    }

    protected static class VabTcpProtocolCreator
    implements AasFactory.ProtocolCreator {
        protected VabTcpProtocolCreator() {
        }

        public InvocablesCreator createInvocablesCreator(SetupSpec spec) {
            ServerAddress addr = spec.getAssetServerAddress();
            return new VabTcpInvocablesCreator(addr.getHost(), addr.getPort());
        }

        public ProtocolServerBuilder createProtocolServerBuilder(SetupSpec spec) {
            return new VabOperationsProvider.VabTcpOperationsBuilder(spec.getAssetServerAddress().getPort());
        }
    }

    protected static class VabHttpProtocolCreator
    implements AasFactory.ProtocolCreator {
        protected VabHttpProtocolCreator() {
        }

        public InvocablesCreator createInvocablesCreator(SetupSpec spec) {
            ServerAddress addr = spec.getAssetServerAddress();
            return new VabHttpInvocablesCreator("http://" + addr.getHost() + ":" + addr.getPort());
        }

        public ProtocolServerBuilder createProtocolServerBuilder(SetupSpec spec) {
            return new VabOperationsProvider.VabHttpOperationsBuilder(spec, SetupSpec.AasComponent.ASSET, Schema.HTTP);
        }
    }

    private class BaSyxPersistenceRecipe
    implements PersistenceRecipe {
        private BaSyxPersistenceRecipe() {
        }

        private PersistenceRecipe findMatching(File file) {
            PersistenceRecipe result = null;
            for (FileFormat ff : AbstractBaSyxAasFactory.this.recipes.keySet()) {
                if (!ff.matches(file)) continue;
                result = AbstractBaSyxAasFactory.this.recipes.get(ff);
            }
            if (null == result) {
                throw new IllegalArgumentException("Unrecognized file format for " + String.valueOf(file));
            }
            return result;
        }

        public void writeTo(List<Aas> aas, File thumbnail, List<PersistenceRecipe.FileResource> resources, File file) throws IOException {
            this.findMatching(file).writeTo(aas, thumbnail, resources, file);
        }

        public List<Aas> readFrom(File file) throws IOException {
            return this.findMatching(file).readFrom(file);
        }

        public Collection<FileFormat> getSupportedFormats() {
            return Collections.unmodifiableCollection(AbstractBaSyxAasFactory.this.recipes.keySet());
        }
    }

    protected static class VabHttpsProtocolCreator
    implements AasFactory.ProtocolCreator {
        protected VabHttpsProtocolCreator() {
        }

        public InvocablesCreator createInvocablesCreator(SetupSpec spec) {
            ServerAddress addr = spec.getAssetServerAddress();
            return new VabHttpsInvocablesCreator("https://" + addr.getHost() + ":" + addr.getPort(), spec.getAssetServerKeyStore());
        }

        public ProtocolServerBuilder createProtocolServerBuilder(SetupSpec spec) {
            return new VabOperationsProvider.VabHttpOperationsBuilder(spec, SetupSpec.AasComponent.ASSET, Schema.HTTPS);
        }
    }
}

