/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Builder;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.DataElement;
import de.iip_ecosphere.platform.support.aas.DeferredBuilder;
import de.iip_ecosphere.platform.support.aas.Entity;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.RelationshipElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.SubmodelElementList;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxBlob;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxDataElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxElementTranslator;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxEntity;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxFile;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxMultiLanguageProperty;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxOperation;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxProperty;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRange;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReference;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReferenceElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRelationshipElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;

public class BaSyxSubmodelElementList
extends BaSyxSubmodelElement
implements SubmodelElementList,
BaSyxElementTranslator.SubmodelElementsRegistrar {
    private ISubmodelElementCollection collection;
    private List<SubmodelElement> elementsList;
    private Map<String, Builder<?>> deferred;

    protected BaSyxSubmodelElementList() {
    }

    protected BaSyxSubmodelElementList(ISubmodelElementCollection collection) {
        this.collection = collection;
    }

    private void createElementsStructure() {
        this.elementsList = new ArrayList<SubmodelElement>();
    }

    private void initialize() {
        if (null == this.elementsList) {
            this.createElementsStructure();
            BaSyxElementTranslator.registerSubmodelElements(this.collection.getSubmodelElements(), (BaSyxElementTranslator.SubmodelElementsRegistrar)this);
        }
    }

    public int getElementsCount() {
        this.initialize();
        return this.elementsList.size();
    }

    public Iterable<SubmodelElement> submodelElements() {
        return this.elements();
    }

    public Iterable<SubmodelElement> elements() {
        return this.elementsCollection();
    }

    private Collection<SubmodelElement> elementsCollection() {
        this.initialize();
        return this.elementsList;
    }

    private Stream<SubmodelElement> elementsStream() {
        return this.elementsCollection().stream();
    }

    private <T extends SubmodelElement> T add(T elt) {
        this.elementsList.add(elt);
        return elt;
    }

    protected Iterable<SubmodelElement> getElements(final Predicate<SubmodelElement> filter) {
        return new Iterable<SubmodelElement>(){

            @Override
            public Iterator<SubmodelElement> iterator() {
                return BaSyxSubmodelElementList.this.elementsStream().filter(filter).iterator();
            }
        };
    }

    protected <E extends SubmodelElement> Iterable<E> getElements(final Predicate<SubmodelElement> filter, final Class<E> castType) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return BaSyxSubmodelElementList.this.elementsStream().filter(e -> castType.isInstance(e)).filter(filter).map(e -> (SubmodelElement)castType.cast(e)).iterator();
            }
        };
    }

    protected Iterable<SubmodelElementCollection> getSubmodelElementCollections(final Predicate<SubmodelElementCollection> filter) {
        return new Iterable<SubmodelElementCollection>(){

            @Override
            public Iterator<SubmodelElementCollection> iterator() {
                return BaSyxSubmodelElementList.this.elementsStream().filter(e -> e instanceof SubmodelElementCollection).map(SubmodelElementCollection.class::cast).filter(filter).iterator();
            }
        };
    }

    public String getIdShort() {
        return this.collection.getIdShort();
    }

    public ISubmodelElementCollection getSubmodelElement() {
        return this.collection;
    }

    public DataElement getDataElement(String idShort) {
        return this.getElement(idShort, DataElement.class);
    }

    public Property getProperty(String idShort) {
        return this.getElement(idShort, Property.class);
    }

    public Operation getOperation(String idShort) {
        return this.getElement(idShort, Operation.class);
    }

    public ReferenceElement getReferenceElement(String idShort) {
        return this.getElement(idShort, ReferenceElement.class);
    }

    public RelationshipElement getRelationshipElement(String idShort) {
        return this.getElement(idShort, RelationshipElement.class);
    }

    public SubmodelElement getSubmodelElement(String idShort) {
        return this.getElement(idShort);
    }

    public SubmodelElement getElement(String idShort) {
        this.initialize();
        Optional<SubmodelElement> tmp = this.elementsStream().filter(s -> s.getIdShort().equals(idShort)).findFirst();
        return tmp.isPresent() ? tmp.get() : null;
    }

    private <T extends SubmodelElement> T getElement(String idShort, Class<T> type) {
        SubmodelElement result = null;
        SubmodelElement tmp = this.getElement(idShort);
        if (type.isInstance(tmp)) {
            result = (SubmodelElement)type.cast(tmp);
        }
        return (T)result;
    }

    public SubmodelElementCollection getSubmodelElementCollection(String idShort) {
        return this.getElement(idShort, SubmodelElementCollection.class);
    }

    public SubmodelElementList getSubmodelElementList(String idShort) {
        return this.getElement(idShort, SubmodelElementList.class);
    }

    public Entity getEntity(String idShort) {
        return this.getElement(idShort, Entity.class);
    }

    @Override
    public <T extends SubmodelElement> T registerElement(T elt) {
        return this.add(elt);
    }

    @Override
    public BaSyxProperty register(BaSyxProperty property) {
        return this.add(property);
    }

    @Override
    public BaSyxMultiLanguageProperty register(BaSyxMultiLanguageProperty property) {
        return this.add(property);
    }

    @Override
    public BaSyxBlob register(BaSyxBlob blob) {
        return this.add(blob);
    }

    @Override
    public BaSyxFile register(BaSyxFile file) {
        return this.add(file);
    }

    @Override
    public BaSyxRange register(BaSyxRange range) {
        return this.add(range);
    }

    @Override
    public BaSyxOperation register(BaSyxOperation operation) {
        return this.add(operation);
    }

    @Override
    public BaSyxRelationshipElement register(BaSyxRelationshipElement relationship) {
        return this.add(relationship);
    }

    @Override
    public BaSyxReferenceElement register(BaSyxReferenceElement reference) {
        return this.add(reference);
    }

    @Override
    public BaSyxEntity register(BaSyxEntity reference) {
        return this.add(reference);
    }

    @Override
    public BaSyxSubmodelElementCollection register(BaSyxSubmodelElementCollection collection) {
        return this.add(collection);
    }

    @Override
    public BaSyxSubmodelElementList register(BaSyxSubmodelElementList list) {
        return this.add(list);
    }

    @Override
    public <D extends org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.DataElement> BaSyxDataElement<D> register(BaSyxDataElement<D> dataElement) {
        return this.add(dataElement);
    }

    public void accept(AasVisitor visitor) {
        this.initialize();
        if (visitor.visitSubmodelElementList((SubmodelElementList)this)) {
            for (SubmodelElement se : visitor.sortSubmodelElements(this.elementsCollection())) {
                se.accept(visitor);
            }
        }
        visitor.endSubmodelElementList((SubmodelElementList)this);
    }

    public Reference createReference() {
        return new BaSyxReference(this.collection.getReference());
    }

    public void deleteElement(String idShort) {
        this.initialize();
        for (int i = 0; i < this.elementsList.size(); ++i) {
            SubmodelElement elt = this.elementsList.get(i);
            if (!elt.getIdShort().equalsIgnoreCase(idShort)) continue;
            this.elementsList.remove(i);
            this.collection.deleteSubmodelElement(idShort);
            break;
        }
    }

    @Override
    public void update() {
        this.elementsList = null;
    }

    public String getSemanticId(boolean stripPrefix) {
        return Tools.translateReference(this.collection.getSemanticId(), stripPrefix);
    }

    public void setSemanticId(String semanticId) {
        IReference ref = Tools.translateReference(semanticId);
        if (ref != null && this.collection instanceof org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection) {
            ((org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection)this.collection).setSemanticId(ref);
        }
    }

    public SubmodelElement getElement(int index) {
        return this.elementsList.get(index);
    }

    public void deleteElement(int index) {
        this.elementsList.remove(index);
    }

    public static class BaSyxSubmodelElementListBuilder
    extends BaSyxSubmodelElementContainerBuilder<ISubmodel>
    implements SubmodelElementList.SubmodelElementListBuilder {
        private BaSyxSubmodelElementContainerBuilder<?> parentBuilder;
        private BaSyxSubmodelElementList instance;
        private ISubmodelElementCollection collection;
        private boolean isNew = true;
        private boolean propagate = true;

        protected BaSyxSubmodelElementListBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort) {
            this(parentBuilder, idShort, () -> new BaSyxSubmodelElementList(), () -> {
                org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection coll = new org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection();
                coll.setIdShort(Tools.checkId(idShort));
                coll.setOrdered(true);
                coll.setAllowDuplicates(true);
                return coll;
            });
        }

        protected BaSyxSubmodelElementListBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort, Supplier<BaSyxSubmodelElementList> wCreator, Supplier<org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection> bCreator) {
            this.parentBuilder = parentBuilder;
            this.instance = wCreator.get();
            this.collection = (ISubmodelElementCollection)bCreator.get();
            this.instance.createElementsStructure();
        }

        protected BaSyxSubmodelElementListBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, BaSyxSubmodelElementList instance) {
            this.parentBuilder = parentBuilder;
            this.instance = instance;
            this.isNew = false;
            if (!(instance.collection instanceof ISubmodelElementCollection)) {
                throw new IllegalArgumentException("Cannot create a " + this.getClass().getSimpleName() + " on a " + instance.collection.getClass().getSimpleName());
            }
            this.collection = instance.collection;
            this.instance.initialize();
        }

        protected ISubmodelElementCollection getCollection() {
            return this.collection;
        }

        protected BaSyxSubmodelElementList getCollectionInstance() {
            return this.instance;
        }

        @Override
        protected String getIdShort() {
            return this.collection.getIdShort();
        }

        public SubmodelElementList.SubmodelElementListBuilder setSemanticId(String refValue) {
            IReference ref;
            if (this.collection instanceof org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement && (ref = Tools.translateReference(refValue)) != null) {
                ((org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement)this.collection).setSemanticId(ref);
            }
            return this;
        }

        @Override
        public Property.PropertyBuilder createPropertyBuilder(String idShort) {
            return new BaSyxProperty.BaSyxPropertyBuilder(this, idShort);
        }

        @Override
        public ReferenceElement.ReferenceElementBuilder createReferenceElementBuilder(String idShort) {
            return new BaSyxReferenceElement.BaSyxReferenceElementBuilder(this, idShort);
        }

        @Override
        public Operation.OperationBuilder createOperationBuilder(String idShort) {
            return new BaSyxOperation.BaSxyOperationBuilder(this, idShort);
        }

        public SubmodelElementCollection.SubmodelElementCollectionBuilder createSubmodelElementCollectionBuilder(String idShort) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder result = (SubmodelElementCollection.SubmodelElementCollectionBuilder)DeferredBuilder.getDeferred((String)idShort, SubmodelElementCollection.SubmodelElementCollectionBuilder.class, this.instance.deferred);
            if (null == result) {
                SubmodelElementCollection sub = this.instance.getSubmodelElementCollection(idShort);
                result = null == sub ? new BaSyxSubmodelElementCollection.BaSyxSubmodelElementCollectionBuilder(this, idShort, false, false) : new BaSyxSubmodelElementCollection.BaSyxSubmodelElementCollectionBuilder(this, (BaSyxSubmodelElementCollection)sub);
            }
            return result;
        }

        public SubmodelElementList.SubmodelElementListBuilder createSubmodelElementListBuilder(String idShort) {
            SubmodelElementList.SubmodelElementListBuilder result = (SubmodelElementList.SubmodelElementListBuilder)DeferredBuilder.getDeferred((String)idShort, SubmodelElementList.SubmodelElementListBuilder.class, this.instance.deferred);
            if (null == result) {
                SubmodelElementList sub = this.instance.getSubmodelElementList(idShort);
                result = null == sub ? new BaSyxSubmodelElementListBuilder(this, idShort) : new BaSyxSubmodelElementListBuilder(this, (BaSyxSubmodelElementList)sub);
            }
            return result;
        }

        public SubmodelElementContainerBuilder createSubmodelElementContainerBuilder(String idShort) {
            SubmodelElement sub = this.instance.getSubmodelElement(idShort);
            Object result = sub instanceof SubmodelElementList ? this.createSubmodelElementListBuilder(idShort) : this.createSubmodelElementCollectionBuilder(idShort);
            return result;
        }

        @Override
        public Reference createReference() {
            return new BaSyxReference(this.collection.getReference());
        }

        @Override
        protected BaSyxFile register(BaSyxFile file) {
            this.collection.addSubmodelElement(file.getSubmodelElement());
            return this.instance.register(file);
        }

        @Override
        protected BaSyxRange register(BaSyxRange range) {
            this.collection.addSubmodelElement(range.getSubmodelElement());
            return this.instance.register(range);
        }

        @Override
        protected BaSyxBlob register(BaSyxBlob blob) {
            this.collection.addSubmodelElement(blob.getSubmodelElement());
            return this.instance.register(blob);
        }

        @Override
        protected BaSyxOperation register(BaSyxOperation operation) {
            this.collection.addSubmodelElement((ISubmodelElement)operation.getSubmodelElement());
            return this.instance.register(operation);
        }

        @Override
        protected BaSyxProperty register(BaSyxProperty property) {
            this.collection.addSubmodelElement(property.getSubmodelElement());
            return this.instance.register(property);
        }

        @Override
        protected BaSyxMultiLanguageProperty register(BaSyxMultiLanguageProperty property) {
            this.collection.addSubmodelElement(property.getSubmodelElement());
            return this.instance.register(property);
        }

        @Override
        protected BaSyxRelationshipElement register(BaSyxRelationshipElement relationship) {
            this.collection.addSubmodelElement(relationship.getSubmodelElement());
            return this.instance.register(relationship);
        }

        @Override
        protected BaSyxEntity register(BaSyxEntity entity) {
            this.collection.addSubmodelElement((ISubmodelElement)entity.getSubmodelElement());
            return this.instance.register(entity);
        }

        @Override
        protected BaSyxReferenceElement register(BaSyxReferenceElement reference) {
            this.collection.addSubmodelElement((ISubmodelElement)reference.getSubmodelElement());
            return this.instance.register(reference);
        }

        @Override
        protected BaSyxSubmodelElementCollection register(BaSyxSubmodelElementCollection collection, boolean propagate) {
            this.collection.addSubmodelElement((ISubmodelElement)collection.getSubmodelElement());
            if (propagate) {
                this.instance.register(collection);
            }
            return collection;
        }

        @Override
        protected BaSyxSubmodelElementList register(BaSyxSubmodelElementList collection, boolean propagate) {
            this.collection.addSubmodelElement((ISubmodelElement)collection.getSubmodelElement());
            if (propagate) {
                this.instance.register(collection);
            }
            return collection;
        }

        public void defer() {
            this.parentBuilder.defer(this.collection.getIdShort(), (Builder<?>)this);
        }

        @Override
        void defer(String shortId, Builder<?> builder) {
            this.instance.deferred = DeferredBuilder.defer((String)shortId, builder, this.instance.deferred);
        }

        @Override
        void buildMyDeferred() {
            DeferredBuilder.buildDeferred(this.instance.deferred);
        }

        public void buildDeferred() {
            this.parentBuilder.buildMyDeferred();
        }

        public BaSyxSubmodelElementList build() {
            this.buildMyDeferred();
            this.instance.collection = this.collection;
            if (this.isNew) {
                this.parentBuilder.register(this.instance, this.propagate);
            }
            return this.instance;
        }

        public Aas.AasBuilder getAasBuilder() {
            return this.parentBuilder.getAasBuilder();
        }

        public SubmodelElementContainerBuilder getParentBuilder() {
            return this.parentBuilder;
        }

        @Override
        protected AbstractSubmodel<ISubmodel> getInstance() {
            return null;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public boolean hasElement(String idShort) {
            return this.instance.getElement(idShort) != null;
        }

        public SubmodelElementList.SubmodelElementListBuilder rbac(AuthenticationDescriptor auth, AuthenticationDescriptor.Role role, AuthenticationDescriptor.RbacAction ... actions) {
            return (SubmodelElementList.SubmodelElementListBuilder)AuthenticationDescriptor.elementRbac((Object)this, (AuthenticationDescriptor)auth, (AuthenticationDescriptor.Role)role, (String)this.parentBuilder.composeRbacPath(this.instance.getIdShort()), (AuthenticationDescriptor.RbacAction[])actions);
        }

        public SubmodelElementList.SubmodelElementListBuilder rbac(AuthenticationDescriptor auth) {
            return this;
        }

        void setPropagation(boolean propagate) {
            this.propagate = propagate;
        }
    }
}

