/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.ExtensionBasedFileFormat;
import de.iip_ecosphere.platform.support.FileFormat;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractAas;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractPersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.basyx.aas.factory.xml.MetamodelToXMLConverter;
import org.eclipse.basyx.aas.factory.xml.XMLToMetamodelConverter;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.xml.sax.SAXException;

class XmlPersistenceRecipe
extends AbstractPersistenceRecipe {
    private static final FileFormat XML = new ExtensionBasedFileFormat("xml", "AAS XML", "AAS in XML");

    XmlPersistenceRecipe() {
        super(XML);
    }

    public void writeTo(List<Aas> aas, File thumbnail, List<PersistenceRecipe.FileResource> resources, File file) throws IOException {
        ArrayList basyxAas = new ArrayList();
        ArrayList basyxSubmodels = new ArrayList();
        ArrayList assetList = new ArrayList();
        ArrayList conceptDescriptionList = new ArrayList();
        for (Aas a : aas) {
            basyxAas.add(((AbstractAas)a).getAas());
            for (Submodel s : a.submodels()) {
                basyxSubmodels.add(((AbstractSubmodel)s).getSubmodel());
            }
            XmlPersistenceRecipe.addAsset(a, assetList, IAsset.class);
        }
        try (FileWriter result = new FileWriter(file);){
            MetamodelToXMLConverter.convertToXML(basyxAas, assetList, conceptDescriptionList, basyxSubmodels, (Result)new StreamResult(result));
        }
        catch (IOException e) {
            throw e;
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IOException(e);
        }
    }

    public List<Aas> readFrom(File file) throws IOException {
        ArrayList<Aas> result = new ArrayList<Aas>();
        try {
            String content = new String(Files.readAllBytes(file.toPath()));
            XMLToMetamodelConverter conv = new XMLToMetamodelConverter(content);
            this.transform(conv.parseAAS(), conv.parseSubmodels(), conv.parseAssets(), result);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        return result;
    }
}

