/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v6_1.category;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.ManagementResponse;
import org.apache.qpid.server.management.plugin.controller.CategoryController;
import org.apache.qpid.server.management.plugin.controller.GenericLegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.model.ConfiguredObject;

public class ConsumerController
implements CategoryController {
    public static final String TYPE = "Consumer";
    private final LegacyManagementController _managementController;

    ConsumerController(LegacyManagementController managementController) {
        this._managementController = managementController;
    }

    @Override
    public String getCategory() {
        return TYPE;
    }

    @Override
    public String getNextVersionCategory() {
        return TYPE;
    }

    @Override
    public String getDefaultType() {
        return null;
    }

    @Override
    public String[] getParentCategories() {
        return new String[]{"Session", "Queue"};
    }

    @Override
    public LegacyManagementController getManagementController() {
        return this._managementController;
    }

    private ManagementController getNextVersionManagementController() {
        return this._managementController.getNextVersionManagementController();
    }

    @Override
    public Object get(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        Collection consumers;
        Object queues;
        Collection<String> hierarchy = this._managementController.getCategoryHierarchy(root, TYPE);
        String consumerName = path.size() == hierarchy.size() ? path.get(hierarchy.size() - 1) : null;
        String queueName = path.size() >= hierarchy.size() - 1 ? path.get(hierarchy.size() - 2) : null;
        String sessionName = path.size() >= hierarchy.size() - 2 ? path.get(hierarchy.size() - 3) : null;
        List<String> virtualHostPath = path;
        if (virtualHostPath.size() > hierarchy.size() - 3) {
            virtualHostPath = virtualHostPath.subList(0, hierarchy.size() - 3);
        }
        if ((queues = this.getNextVersionManagementController().get(root, "Queue", virtualHostPath, Collections.emptyMap())) instanceof LegacyConfiguredObject) {
            consumers = this.getQueueConsumers(sessionName, queueName, consumerName, (LegacyConfiguredObject)queues);
        } else if (queues instanceof Collection) {
            consumers = ((Collection)queues).stream().map(LegacyConfiguredObject.class::cast).map(q -> this.getQueueConsumers(sessionName, queueName, consumerName, (LegacyConfiguredObject)q)).flatMap(Collection::stream).collect(Collectors.toList());
        } else {
            throw ManagementException.createInternalServerErrorManagementException("Unexpected consumer format from next version");
        }
        return consumers;
    }

    @Override
    public int delete(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        throw ManagementException.createBadRequestManagementException("Consumer cannot be deleted via management interfaces");
    }

    @Override
    public LegacyConfiguredObject createOrUpdate(ConfiguredObject<?> root, List<String> path, Map<String, Object> attributes, boolean isPost) throws ManagementException {
        throw ManagementException.createBadRequestManagementException("Consumer cannot be created or updated via management interfaces");
    }

    @Override
    public ManagementResponse invoke(ConfiguredObject<?> root, List<String> path, String operation, Map<String, Object> parameters, boolean isPost, boolean isSecure) throws ManagementException {
        Object result = this.get(root, path, Collections.emptyMap());
        if (result instanceof Collection && ((Collection)result).size() == 1) {
            LegacyConfiguredObject object = (LegacyConfiguredObject)((Collection)result).iterator().next();
            return object.invoke(operation, parameters, isSecure);
        }
        throw ManagementException.createBadRequestManagementException(String.format("Cannot find consumer for path %s", String.join((CharSequence)("/" + path), new CharSequence[0])));
    }

    @Override
    public Object getPreferences(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        throw ManagementException.createBadRequestManagementException("Preferences not supported for Consumer");
    }

    @Override
    public void setPreferences(ConfiguredObject<?> root, List<String> path, Object preferences, Map<String, List<String>> parameters, boolean isPost) throws ManagementException {
        throw ManagementException.createBadRequestManagementException("Preferences not supported for Consumer");
    }

    @Override
    public int deletePreferences(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        throw ManagementException.createBadRequestManagementException("Preferences not supported for Consumer");
    }

    @Override
    public LegacyConfiguredObject convertFromNextVersion(LegacyConfiguredObject nextVersionObject) {
        return new LegacyConsumer(this.getManagementController(), nextVersionObject);
    }

    private Collection<LegacyConfiguredObject> getQueueConsumers(String sessionName, String queueName, String consumerName, LegacyConfiguredObject nextVersionQueue) {
        Collection<LegacyConfiguredObject> queueConsumers;
        if ((queueName == null || queueName.equals("*") || queueName.equals(nextVersionQueue.getAttribute("name"))) && (queueConsumers = nextVersionQueue.getChildren(TYPE)) != null) {
            return queueConsumers.stream().filter(c -> consumerName == null || "*".equals(consumerName) || consumerName.equals(c.getAttribute("name"))).filter(c -> {
                if (sessionName == null || "*".equals(sessionName)) {
                    return true;
                }
                Object obj = c.getAttribute("session");
                if (obj instanceof LegacyConfiguredObject) {
                    return sessionName.equals(((LegacyConfiguredObject)obj).getAttribute("name"));
                }
                return false;
            }).map(this::convertFromNextVersion).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static class LegacyConsumer
    extends GenericLegacyConfiguredObject {
        LegacyConsumer(LegacyManagementController managementController, LegacyConfiguredObject nextVersionLegacyConfiguredObject) {
            super(managementController, nextVersionLegacyConfiguredObject, ConsumerController.TYPE);
        }

        @Override
        public LegacyConfiguredObject getParent(String category) {
            if ("Session".equals(category)) {
                LegacyConfiguredObject nextVersionConsumer = this.getNextVersionLegacyConfiguredObject();
                LegacyConfiguredObject nextVersionSession = (LegacyConfiguredObject)nextVersionConsumer.getAttribute("Session".toLowerCase());
                return this.getManagementController().convertFromNextVersion(nextVersionSession);
            }
            return this.getManagementController().convertFromNextVersion(this.getNextVersionLegacyConfiguredObject().getParent(category));
        }
    }
}

