/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.Version;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public abstract class AbstractDelegatingService<S extends Service>
implements Service {
    private S service;

    public AbstractDelegatingService(YamlService yaml) {
        this.initService(yaml);
    }

    protected void initService(YamlService yaml) {
        this.assignService(yaml);
    }

    protected final void assignService(YamlService yaml) {
        this.service = this.createService(yaml);
    }

    protected abstract S createService(YamlService var1);

    @Override
    public String getName() {
        return this.service.getName();
    }

    @Override
    public Version getVersion() {
        return this.service.getVersion();
    }

    @Override
    public String getDescription() {
        return this.service.getDescription();
    }

    @Override
    public boolean isDeployable() {
        return this.service.isDeployable();
    }

    @Override
    public boolean isTopLevel() {
        return this.service.isTopLevel();
    }

    @Override
    public ServiceKind getKind() {
        return this.service.getKind();
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
        this.service.migrate(resourceId);
    }

    @Override
    public void update(URI location) throws ExecutionException {
        this.service.update(location);
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
        this.service.switchTo(targetId);
    }

    @Override
    public void activate() throws ExecutionException {
        this.service.activate();
    }

    @Override
    public void passivate() throws ExecutionException {
        this.service.passivate();
    }

    @Override
    public void reconfigure(Map<String, String> values) throws ExecutionException {
        this.service.reconfigure(values);
    }

    @Override
    public String getId() {
        return this.service.getId();
    }

    @Override
    public ServiceState getState() {
        return this.service.getState();
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        this.service.setState(state);
    }

    protected S getService() {
        return this.service;
    }
}

