/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.MeterRepresentation;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonArray;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonObjectBuilder;
import de.iip_ecosphere.platform.support.metrics.Gauge;
import de.iip_ecosphere.platform.support.metrics.Measurement;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MetricsFactory;
import de.iip_ecosphere.platform.support.metrics.Statistic;
import java.util.ArrayList;
import java.util.List;

public class GaugeRepresentation
extends MeterRepresentation
implements Gauge {
    private double value;
    private List<Measurement> measurements;

    private GaugeRepresentation(JsonObject object, String ... tags) {
        super(object, Meter.Type.GAUGE, tags);
        JsonArray ja = object.getJsonArray("measurements");
        JsonObject jo = ja.getJsonObject(0);
        if (ja.size() != 1 || Statistic.valueOf((String)jo.getString("statistic")) != Statistic.VALUE) {
            throw new IllegalArgumentException("This JsonObject does not represent a valid Gauge!");
        }
        this.value = jo.getJsonNumber("value").doubleValue();
        this.measurements = new ArrayList<Measurement>();
        this.measurements.add(MetricsFactory.buildMeasurement(() -> this.value(), (Statistic)Statistic.VALUE));
    }

    private GaugeRepresentation(String name) {
        super(name, Meter.Type.GAUGE);
        this.value = 0.0;
        this.measurements = new ArrayList<Measurement>();
        this.measurements.add(MetricsFactory.buildMeasurement(() -> this.value, (Statistic)Statistic.VALUE));
    }

    public static Gauge parseGauge(JsonObject object, String ... tags) {
        return new GaugeRepresentation(object, tags);
    }

    public static Gauge createNewGauge(String name) {
        return new GaugeRepresentation(name);
    }

    public double value() {
        return this.value;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.measurements;
    }

    @Override
    public JsonObject getUpdater() {
        JsonObjectBuilder job = Json.createObjectBuilder();
        job.add("name", this.getId().getName());
        job.add("value", this.value);
        return (JsonObject)job.build();
    }

    public void setValue(double value) {
        this.value = value;
    }
}

