/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.environment.services.TransportConverter;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.SubmodelElementList;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class TransportToAasConverter<T>
extends TransportConverter<T> {
    public static final ValueConverter IDENTITY_CONVERTER = v -> v;
    public static final ValueConverter JSON_CONVERTER = v -> JsonUtils.toJson((Object)v);
    public static final ValueConverter SHORT2INT_CONVERTER = v -> (int)((Short)v).shortValue();
    public static final ValueConverter STRING_CONVERTER = v -> String.valueOf(v);
    public static final ValueConverter ENUM_NAME_CONVERTER = v -> ((Enum)v).name();
    private static final Map<Class<?>, TypeConverter> DEFAULT_CONVERTERS = new HashMap();
    private static final Set<String> METHODS_TO_IGNORE = new HashSet<String>();
    private Map<Class<?>, TypeConverter> converters = new HashMap();
    private long timeout = 1200000L;
    private long lastCleanup = System.currentTimeMillis();
    private long cleanupTimeout = 5000L;
    private long aasFailedTimestamp = -1L;
    private long aasFailedTimeout = 30000L;
    private String submodelIdShort;
    private AasPartRegistry.AasSetup aasSetup;
    private boolean aasStarted;
    private transient Aas aas;

    public TransportToAasConverter(String submodelIdShort, String transportStream, Class<T> dataType) {
        super(transportStream, dataType);
        this.converters.putAll(DEFAULT_CONVERTERS);
        this.submodelIdShort = submodelIdShort;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setCleanupTimeout(long cleanupTimeout) {
        this.cleanupTimeout = cleanupTimeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public abstract String getAasId();

    public abstract String getAasUrn();

    @Override
    protected void handleNew(T data) {
        long now = System.currentTimeMillis();
        if (this.isAasEnabled() && this.aasFailedTimestamp > 0L && now - this.aasFailedTimestamp < this.aasFailedTimeout) {
            this.aasFailedTimestamp = -1L;
        }
        if (this.isAasEnabled() && this.aasFailedTimestamp < 0L) {
            try {
                if (null == this.aas) {
                    this.aas = AasPartRegistry.retrieveAas((AasPartRegistry.AasSetup)this.aasSetup, (String)this.getAasUrn(), (boolean)false);
                }
                this.aas.getSubmodel(this.submodelIdShort).create(b -> {
                    SubmodelElementList.SubmodelElementListBuilder smcBuilder = b.createSubmodelElementListBuilder(this.getSubmodelElementIdFunction().apply(data));
                    this.populateSubmodelElementCollection((SubmodelElementContainerBuilder)smcBuilder, data);
                    smcBuilder.build();
                }, false, new String[0]);
                this.cleanup(this.aas);
            }
            catch (IOException e) {
                if (Starter.expectAas()) {
                    LoggerFactory.getLogger(this.getClass()).error("Cannot obtain AAS {}: {}", (Object)this.getAasUrn(), (Object)e.getMessage());
                }
                this.aasFailedTimestamp = now;
            }
        }
    }

    protected abstract void populateSubmodelElementCollection(SubmodelElementContainerBuilder var1, T var2);

    protected abstract Function<T, String> getSubmodelElementIdFunction();

    protected void addConverter(Class<?> cls, TypeConverter converter) {
        this.converters.put(cls, converter);
    }

    protected void createPayloadEntries(SubmodelElementContainerBuilder payloadBuilder, Object payload) {
        if (null != payload) {
            Class<?> cls = payload.getClass();
            for (Method m : cls.getMethods()) {
                if (!TransportToAasConverter.isGetter(m)) continue;
                String fieldName = m.getName();
                String field = fieldName.substring("get".length());
                if (this.isExcludedField(fieldName)) continue;
                Class<?> valueCls = null;
                Object value = null;
                TypeConverter tConv = this.converters.get(m.getReturnType());
                if (null == tConv && null != (value = this.getValue(payload, m, field))) {
                    valueCls = value.getClass();
                    tConv = this.converters.get(valueCls);
                }
                if (null != tConv) {
                    if (null == valueCls) {
                        value = this.getValue(payload, m, field);
                    }
                    payloadBuilder.createPropertyBuilder(AasUtils.fixId((String)field)).setValue(tConv.getType(), tConv.convert(value)).build();
                    continue;
                }
                if (METHODS_TO_IGNORE.contains(m.getName())) continue;
                Object type = cls.getName();
                if (null != valueCls) {
                    type = (String)type + "/" + String.valueOf(valueCls);
                }
                LoggerFactory.getLogger(this.getClass()).warn("Cannot map value of operation {}/field {} of type {} to AAS: No converter defined", new Object[]{m.getName(), field, type});
            }
            payloadBuilder.justBuild();
        }
    }

    @Override
    public boolean cleanup() {
        boolean done = false;
        if (null != this.aas) {
            done = this.cleanup(this.aas);
        }
        return done;
    }

    public boolean cleanup(Aas aas) {
        boolean done = false;
        long now = System.currentTimeMillis();
        if (this.cleanupTimeout > 0L && now - this.lastCleanup > this.cleanupTimeout) {
            long timestamp = now - this.timeout;
            Submodel sm = aas.getSubmodel(this.submodelIdShort);
            CleanupPredicate delPred = this.getCleanupPredicate();
            sm.iterate(e -> {
                boolean cont;
                if (delPred.test((SubmodelElementCollection)e, timestamp)) {
                    sm.deleteElement(e);
                    cont = true;
                } else {
                    cont = false;
                }
                return cont;
            }, SubmodelElementCollection.class, new String[0]);
            this.lastCleanup = now;
            done = true;
        }
        return done;
    }

    public abstract CleanupPredicate getCleanupPredicate();

    @Override
    public boolean isAasStarted() {
        return this.aasStarted;
    }

    @Override
    public void start(AasPartRegistry.AasSetup aasSetup) {
        this.aasSetup = aasSetup;
        super.start(aasSetup);
    }

    @Override
    public void stop() {
        super.stop();
        if (this.isAasEnabled()) {
            try {
                this.cleanUpAas(AasPartRegistry.retrieveAas((AasPartRegistry.AasSetup)this.aasSetup, (String)this.getAasUrn()));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cleaning up AAS: " + e.getMessage());
            }
        }
    }

    @Override
    public boolean isTraceInAas() {
        return true;
    }

    protected boolean cleanUpAas(Aas aas) {
        return true;
    }

    protected abstract void doWatch(SubmodelElementCollection var1, long var2);

    @Override
    public TransportConverter.Watcher<T> createWatcher(int period) {
        return new AasWatcher(period);
    }

    static {
        DEFAULT_CONVERTERS.put(String.class, new TypeConverter(Type.STRING, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Boolean.TYPE, new TypeConverter(Type.BOOLEAN, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Boolean.class, new TypeConverter(Type.BOOLEAN, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Integer.TYPE, new TypeConverter(Type.INTEGER, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Integer.class, new TypeConverter(Type.INTEGER, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Long.TYPE, new TypeConverter(Type.INTEGER, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Long.class, new TypeConverter(Type.INTEGER, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Float.TYPE, new TypeConverter(Type.DOUBLE, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Float.class, new TypeConverter(Type.DOUBLE, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Double.TYPE, new TypeConverter(Type.DOUBLE, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Double.class, new TypeConverter(Type.DOUBLE, IDENTITY_CONVERTER));
        DEFAULT_CONVERTERS.put(Short.TYPE, new TypeConverter(Type.INTEGER, SHORT2INT_CONVERTER));
        DEFAULT_CONVERTERS.put(Short.class, new TypeConverter(Type.INTEGER, SHORT2INT_CONVERTER));
        DEFAULT_CONVERTERS.put(int[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(long[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(float[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(double[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(byte[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(boolean[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(String[].class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        DEFAULT_CONVERTERS.put(Object.class, new TypeConverter(Type.STRING, JSON_CONVERTER));
        METHODS_TO_IGNORE.add("getClass");
    }

    public static class TypeConverter
    implements ValueConverter {
        private ValueConverter conv;
        private Type type;

        public TypeConverter(Type type, ValueConverter conv) {
            this.type = type;
            this.conv = conv;
        }

        @Override
        public Object convert(Object value) {
            return this.conv.convert(value);
        }

        public Type getType() {
            return this.type;
        }
    }

    public static interface CleanupPredicate {
        public boolean test(SubmodelElementCollection var1, long var2);
    }

    protected class AasWatcher
    implements TransportConverter.Watcher<T> {
        private Timer timer;
        private int period;
        private long lastRun = System.currentTimeMillis();

        private AasWatcher(int period) {
            this.period = period;
        }

        @Override
        public TransportConverter.Watcher<T> start() {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    block3: {
                        try {
                            if (null == TransportToAasConverter.this.aas) {
                                TransportToAasConverter.this.aas = AasPartRegistry.retrieveAas((AasPartRegistry.AasSetup)TransportToAasConverter.this.aasSetup, (String)TransportToAasConverter.this.getAasUrn(), (boolean)false);
                            }
                            Submodel submodel = TransportToAasConverter.this.aas.getSubmodel(TransportToAasConverter.this.submodelIdShort);
                            submodel.iterate(coll -> {
                                TransportToAasConverter.this.doWatch((SubmodelElementCollection)coll, AasWatcher.this.lastRun);
                                return true;
                            }, SubmodelElementCollection.class, new String[0]);
                            AasWatcher.this.lastRun = System.currentTimeMillis();
                        }
                        catch (IOException e) {
                            if (!Starter.expectAas()) break block3;
                            LoggerFactory.getLogger(this.getClass()).error("Cannot obtain AAS {}: {}", (Object)TransportToAasConverter.this.getAasUrn(), (Object)e.getMessage());
                        }
                    }
                }
            }, 0L, (long)this.period);
            return this;
        }

        @Override
        public TransportConverter.Watcher<T> stop() {
            this.timer.cancel();
            return this;
        }

        @Override
        public void setConsumer(Consumer<T> consumer) {
        }
    }

    public static interface ValueConverter {
        public Object convert(Object var1);
    }
}

