/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.authorization.internal;

import org.eclipse.basyx.components.aas.aascomponent.IAASServerDecorator;
import org.eclipse.basyx.components.aas.authorization.AuthorizedAASServerFeature;
import org.eclipse.basyx.components.aas.authorization.internal.AuthorizedAASServerDecorator;
import org.eclipse.basyx.components.aas.authorization.internal.AuthorizedDefaultServletParams;
import org.eclipse.basyx.components.aas.authorization.internal.GrantedAuthorityFilesAuthorizer;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxSecurityConfiguration;
import org.eclipse.basyx.components.security.authorization.internal.AuthorizationDynamicClassLoader;
import org.eclipse.basyx.extensions.aas.aggregator.authorization.internal.GrantedAuthorityAASAggregatorAuthorizer;
import org.eclipse.basyx.extensions.aas.api.authorization.internal.GrantedAuthorityAASAPIAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.IGrantedAuthorityAuthenticator;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.eclipse.basyx.extensions.submodel.aggregator.authorization.internal.GrantedAuthoritySubmodelAggregatorAuthorizer;
import org.eclipse.basyx.extensions.submodel.authorization.internal.GrantedAuthoritySubmodelAPIAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrantedAuthorityAuthorizedAASServerFeature<SubjectInformationType>
extends AuthorizedAASServerFeature<SubjectInformationType> {
    private static Logger logger = LoggerFactory.getLogger(GrantedAuthorityAuthorizedAASServerFeature.class);

    public GrantedAuthorityAuthorizedAASServerFeature(BaSyxSecurityConfiguration securityConfig) {
        super(securityConfig);
    }

    @Override
    public IAASServerDecorator getDecorator() {
        logger.info("use GrantedAuthority authorization strategy");
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getSubjectInformationProvider();
        IGrantedAuthorityAuthenticator<SubjectInformationType> grantedAuthorityAuthenticator = this.getGrantedAuthorityAuthenticator();
        return new AuthorizedAASServerDecorator<SubjectInformationType>(new GrantedAuthoritySubmodelAPIAuthorizer(grantedAuthorityAuthenticator), new GrantedAuthoritySubmodelAggregatorAuthorizer(grantedAuthorityAuthenticator), new GrantedAuthorityAASAPIAuthorizer(grantedAuthorityAuthenticator), new GrantedAuthorityAASAggregatorAuthorizer(grantedAuthorityAuthenticator), subjectInformationProvider);
    }

    @Override
    public AuthorizedDefaultServletParams<SubjectInformationType> getFilesAuthorizerParams() {
        logger.info("use GrantedAuthority authorization strategy for files authorizer");
        IGrantedAuthorityAuthenticator<SubjectInformationType> grantedAuthorityAuthenticator = this.getGrantedAuthorityAuthenticator();
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getSubjectInformationProvider();
        return new AuthorizedDefaultServletParams<SubjectInformationType>(new GrantedAuthorityFilesAuthorizer<SubjectInformationType>(grantedAuthorityAuthenticator), subjectInformationProvider);
    }

    private IGrantedAuthorityAuthenticator<SubjectInformationType> getGrantedAuthorityAuthenticator() {
        return (IGrantedAuthorityAuthenticator)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.grantedAuthority.grantedAuthorityAuthenticator", IGrantedAuthorityAuthenticator.class);
    }

    private ISubjectInformationProvider<SubjectInformationType> getSubjectInformationProvider() {
        return (ISubjectInformationProvider)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.grantedAuthority.subjectInformationProvider", ISubjectInformationProvider.class);
    }
}

