/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDBAASAPI
implements IAASAPI {
    private static final String DEFAULT_CONFIG_PATH = "mongodb.properties";
    private static final String AASIDPATH = "identification.id";
    protected BaSyxMongoDBConfiguration config;
    protected MongoOperations mongoOps;
    protected String collection;
    protected String aasId;

    @Deprecated
    public MongoDBAASAPI(BaSyxMongoDBConfiguration config, String aasId) {
        this(config, aasId, MongoClients.create((String)config.getConnectionUrl()));
    }

    public MongoDBAASAPI(BaSyxMongoDBConfiguration config, String aasId, MongoClient client) {
        this.setConfiguration(config, client);
        this.setAASId(aasId);
    }

    @Deprecated
    public MongoDBAASAPI(String resourceConfigPath, String aasId) {
        this.config = new BaSyxMongoDBConfiguration();
        this.config.loadFromResource(resourceConfigPath);
        this.setConfiguration(this.config);
        this.setAASId(aasId);
    }

    public MongoDBAASAPI(String resourceConfigPath, String aasId, MongoClient client) {
        this.config = new BaSyxMongoDBConfiguration();
        this.config.loadFromResource(resourceConfigPath);
        this.setConfiguration(this.config, client);
        this.setAASId(aasId);
    }

    @Deprecated
    public MongoDBAASAPI(String aasId) {
        this(DEFAULT_CONFIG_PATH, aasId);
    }

    public MongoDBAASAPI(String aasId, MongoClient client) {
        this(DEFAULT_CONFIG_PATH, aasId, client);
    }

    @Deprecated
    public void setConfiguration(BaSyxMongoDBConfiguration config) {
        MongoClient client = MongoClients.create((String)config.getConnectionUrl());
        this.setConfiguration(config, client);
    }

    public void setConfiguration(BaSyxMongoDBConfiguration config, MongoClient client) {
        this.config = config;
        this.mongoOps = new MongoTemplate(client, config.getDatabase());
        this.collection = config.getAASCollection();
    }

    public void setAASId(String aasId) {
        this.aasId = aasId;
    }

    public void setAAS(AssetAdministrationShell aas) {
        String id = aas.getIdentification().getId();
        this.setAASId(id);
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)AASIDPATH).is((Object)this.aasId));
        Object replaced = this.mongoOps.findAndReplace(hasId, (Object)aas, this.collection);
        if (replaced == null) {
            this.mongoOps.insert((Object)aas, this.collection);
        }
    }

    public IAssetAdministrationShell getAAS() {
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)AASIDPATH).is((Object)this.aasId));
        AssetAdministrationShell aas = (AssetAdministrationShell)this.mongoOps.findOne(hasId, AssetAdministrationShell.class, this.collection);
        if (aas == null) {
            throw new ResourceNotFoundException("The AAS " + this.aasId + " could not be found in the database.");
        }
        aas.remove((Object)"_id");
        return aas;
    }

    public void addSubmodel(IReference submodel) {
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)AASIDPATH).is((Object)this.aasId));
        AssetAdministrationShell aas = (AssetAdministrationShell)this.mongoOps.findOne(hasId, AssetAdministrationShell.class, this.collection);
        if (aas == null) {
            throw new ResourceNotFoundException("The AAS " + this.aasId + " could not be found in the database.");
        }
        aas.addSubmodelReference(submodel);
        this.mongoOps.findAndReplace(hasId, (Object)aas, this.collection);
    }

    public void removeSubmodel(String id) {
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)AASIDPATH).is((Object)this.aasId));
        AssetAdministrationShell aas = (AssetAdministrationShell)this.mongoOps.findOne(hasId, AssetAdministrationShell.class, this.collection);
        if (aas == null) {
            throw new ResourceNotFoundException("The AAS " + this.aasId + " could not be found in the database.");
        }
        Collection smReferences = aas.getSubmodelReferences();
        Iterator iterator = smReferences.iterator();
        while (iterator.hasNext()) {
            IReference ref = (IReference)iterator.next();
            List keys = ref.getKeys();
            IKey lastKey = (IKey)keys.get(keys.size() - 1);
            String idValue = lastKey.getValue();
            if (!idValue.equals(id)) continue;
            iterator.remove();
            break;
        }
        aas.setSubmodelReferences(smReferences);
        this.mongoOps.findAndReplace(hasId, (Object)aas, this.collection);
    }
}

